package org.richfaces.cdk.rd;

import java.io.File;
import java.util.HashSet;
import java.util.Set;

import javax.xml.parsers.SAXParser;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/**
 * @author Anton Belevich
 *
 */
public class RichComponentsScanner implements ComponentsScanner {

	private SAXParser parser;
	
	private Set <String> components = new HashSet<String>();
	
	
	DefaultHandler defaultHandler = new DefaultHandler () {
		@Override
		public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
			components.add(name);
		}
	};
	
	public RichComponentsScanner(SAXParser parser) {
		this.parser = parser;
	}
			
	public Set<String> getResult() {
		return components;
	}
	
	public SAXParser getParser() {
		return parser;
	}

	public void setParser(SAXParser parser) {
		this.parser = parser;
	}

	public void doScan(File file) throws Exception {
		parser.parse(file, defaultHandler);
	}
}
