package org.richfaces.realworld.domain;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.hibernate.validator.Length;
import org.hibernate.validator.NotEmpty;
import org.hibernate.validator.NotNull;
import org.jboss.seam.annotations.Name;

@Entity
@Name("comment")
@Table(name = "comments")
public class Comment implements Serializable{

	private static final long serialVersionUID = 3429270322123226071L;

	@Id
	@GeneratedValue
	@Column(name = "COMMENT_ID")
	private Long id;
	
	@Temporal(TemporalType.TIMESTAMP)
	private Date date;
	
	@ManyToOne
    @JoinColumn(name="IMAGE_COMMENT_ID",
    referencedColumnName="IMAGE_ID")
	private Image image;
	
	@ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "FROM_USER_ID", nullable = false, updatable = false)
    @org.hibernate.annotations.ForeignKey(name = "FK_FROM_USER_ID")
	private User author;
	
	@Column(length = 1024, nullable = false)
    @NotNull
	@NotEmpty
    @Length(min=2)
	private String message;
	
	public Long getId() {
		return id;
	}

	public Date getDate() {
		return date;
	}
	
	public void setDate(Date date) {
		this.date = date;
	}
	
	public User getAuthor() {
		return author;
	}
	
	public void setAuthor(User author) {
		this.author = author;
	}
	
	public String getMessage() {
		return message;
	}
	
	public void setMessage(String message) {
		this.message = message;
	}

	public Image getImage() {
		return image;
	}

	public void setImage(Image image) {
		this.image = image;
	}
	
}
