package org.richfaces.realworld.error;

import java.util.ArrayList;
import java.util.List;

import javax.faces.context.FacesContext;

import org.ajax4jsf.context.AjaxContext;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;

@Name("errorHandlerBean")
@Scope(ScopeType.EVENT)
@AutoCreate
public class ErrorHandlerBean {

	private List<Exception> errors = new ArrayList<Exception>();

	public List<Exception> getErrors() {
		return errors;
	}

	public void setErrors(List<Exception> errors) {
		this.errors = errors;
	}
	
	public boolean isErrorExist(){
		return errors.size() > 0 ;
	}
	
	@Observer("clearErrorEvent")
	public void clearEvents(){
		errors.clear();
	}
	
	@Observer("addErrorEvent")
	public void addToErrors(Exception e){
		FacesContext context = FacesContext.getCurrentInstance();
		AjaxContext ac = AjaxContext.getCurrentInstance(context);
		ac.addRenderedArea("mainform:error");
		errors.add(e);
	}
}
