/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */
package org.richfaces.realworld.manager;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.richfaces.realworld.domain.Album;
import org.richfaces.realworld.domain.FriendshipRequest;
import org.richfaces.realworld.domain.Image;
import org.richfaces.realworld.domain.Message;
import org.richfaces.realworld.domain.User;
import org.richfaces.realworld.error.ErrorHandler;
import org.richfaces.realworld.navigation.NavigationEnum;
import org.richfaces.realworld.service.IMessageAction;
import org.richfaces.realworld.service.IUserAction;
import org.richfaces.realworld.util.SelectionHelper;

@Name("userManager")
@Scope(ScopeType.CONVERSATION)
public class UserManager implements Serializable{
	
	@In("#{messages['addedtofriends']}") private String ADDED_TO_FRIENDS_MESSAGE_THEME;
	@In("#{messages['addedtofriendsby']}") private String ADDED_TO_FRIENDS_MESSAGE;
	@In("#{messages['removedfromfriends']}") private String REMOVED_FROM_FRIENDS_MESSAGE_THEME;
	@In("#{messages['removedfromfriendsby']}") private String YOU_ARE_WERE_REMOVED_FROM_FRIENDS_MESSAGE;

	private static final String UPDATE_MAIN_AREA_EVENT = "updateMainArea";
	
	private static final long serialVersionUID = 6027103521084558931L;

	@In
	private User user;
	
	private Long countUnreadedMessages;
	
	@In(create=true, required=true)
	private IMessageAction messageAction;
	
	@In(create=true, required=true)
	private IUserAction userAction;
	
	@In(create=true) @Out
	private SelectionHelper selectionHelper;

	public List<String> availableUserLogins(Object suggest){
		List<String> suggestions = userAction.getUsers((String)suggest);
		return suggestions;
	}

	public void sendMessage(Message message) {
		messageAction.sendMessage(message);
	}

	public Long getCountUnreadedMessages() {
		if(null == countUnreadedMessages){
			countUnreadedMessages = userAction.countNotReadedMessages(user);
		}
		return countUnreadedMessages != null ? countUnreadedMessages : 0;
	}
	
	public void setCountUnreadedMessages(Long count){
		countUnreadedMessages = null;
	}

	public void removeFromFriends(User owner, User removed){
		userAction.removeFromFriends(owner, removed);
		Message message = new Message();
		message.setAuthor(user);
		message.setDate(new Date());
		message.setOwner(removed);
		message.setFriendshipRequest(false);
		message.setReaded(false);
		message.setMessage(YOU_ARE_WERE_REMOVED_FROM_FRIENDS_MESSAGE+ user.getLogin());
		message.setTheme(REMOVED_FROM_FRIENDS_MESSAGE_THEME);
		messageAction.sendMessage(message);
	}

	public void addToFriends(User friend){
		FriendshipRequest request = friend.getFriendshipRequest(user, friend);
		if(request != null){
			if(!userAction.friendExist(user, friend)){
				userAction.addFriend(user, friend, request);
				Message message = new Message();
				message.setAuthor(user);
				message.setDate(new Date());
				message.setOwner(friend);
				message.setFriendshipRequest(false);
				message.setReaded(false);
				message.setMessage(ADDED_TO_FRIENDS_MESSAGE+ user.getLogin());
				message.setTheme(ADDED_TO_FRIENDS_MESSAGE_THEME);
				messageAction.sendMessage(message);
			}	
		}/*else{
			throw new Exception("This user won't be your friend!");
		}*/
	}
	
	public void addToSharedAlbums(Image image){
		userAction.addSharedAlbum(image.getAlbum());
	}
	
	public void removeFromSharedAlbums(Album album){
		userAction.removeFromSharedAlbums(user, album);
	}

	public void showSharedAlbum(Image image){
		Events.instance().raiseEvent(UPDATE_MAIN_AREA_EVENT, NavigationEnum.IMAGE_PREVIEW);
		selectionHelper.setSelectedAlbum(image.getAlbum());
		selectionHelper.setSelectedImage(selectionHelper.getSelectedAlbum().getImages().get(0));
		selectionHelper.setSelectedImageIndex(1);
		selectionHelper.setUserAlbumSelected(false);
	}
	
	public void markAsReaded(Message message){
		messageAction.markAsReaded(message);
		this.setCountUnreadedMessages(null);
	}
	
	public void deleteMessage(Message message){
		messageAction.deleteMessage(message);
		this.setCountUnreadedMessages(null);
	}
}
