/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */
package org.richfaces.realworld.util;

import java.io.Serializable;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.richfaces.realworld.domain.Album;
import org.richfaces.realworld.domain.Image;

@Name("selectionHelper")
@Scope(ScopeType.CONVERSATION)
public class SelectionHelper implements Serializable{

	private static final long serialVersionUID = 5656562187249324512L;
	
	private Integer selectedImageIndex = 1;
	
	private Image selectedImage;

	private Album selectedAlbum;
	
	private boolean userAlbumSelected = true;

	public boolean isUserAlbumSelected() {
		return userAlbumSelected;
	}

	public void setUserAlbumSelected(boolean userAlbumSelected) {
		this.userAlbumSelected = userAlbumSelected;
	}

	public Integer getSelectedImageIndex() {
		return selectedImageIndex;
	}

	public void setSelectedImageIndex(Integer selectedImageIndex) {
		this.selectedImageIndex = selectedImageIndex;
	}

	public Image getSelectedImage() {
		return selectedImage;
	}

	public void setSelectedImage(Image selectedImage) {
		this.selectedImage = selectedImage;
	}

	public Album getSelectedAlbum() {
		return selectedAlbum;
	}

	public void setSelectedAlbum(Album selectedAlbum) {
		this.selectedAlbum = selectedAlbum;
	}
}
