/**
 * License Agreement.
 *
 * JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */ 
package org.richfaces.testng;

import org.ajax4jsf.template.Template;
import org.richfaces.SeleniumTestBase;
import org.testng.Assert;
import org.testng.annotations.Test;

/**
 * ajaxInclude component sselenium test
 * @author Alexandr Levkovsky
 *
 */
public class AjaxIncludeTest extends SeleniumTestBase {

    private final static String FORM1_ID = "form1:";    
    private final static String FORM2_ID = "form2:";

    private final static String INCLUDE1_ID = "include1";
    private final static String INCLUDE2_ID = "include2";
    private final static String INCLUDE3_ID = "include3";
    private final static String INCLUDE4_ID = "include4";
    
    private final static String BUTTON4_ID = "b4";
    
    private final static String INPUT_ID = "input";
    private final static String OUTPUT_ID = "output";
    
    private final static String NEXT_BUTTON_ID = "next";
    private final static String PREVIOUS_BUTTON_ID = "previous";
    
    private final static String RESET_BUTTON_ID = "reset";
    
    private final static String STEP1_PANEL_ID = "step1_panel";
    private final static String STEP2_PANEL_ID = "step2_panel";
    
    /**
     * @see org.richfaces.SeleniumTestBase#getTestUrl()
     */
    @Override
    public String getTestUrl() {	
	return "pages/ajaxInclude/ajaxIncludeTest.xhtml";
    }

    @Test
    public void testAjaxInclude(Template template) throws Exception {
	renderPage(template);
	String include1Prefix = getParentId() + FORM2_ID + INCLUDE4_ID + ":";

	AssertRendered(include1Prefix + STEP1_PANEL_ID);
	AssertNotRendered(include1Prefix + STEP2_PANEL_ID);

	String text = "1";
	type(include1Prefix + INPUT_ID, text);
	clickNext();

	AssertRendered(include1Prefix + STEP2_PANEL_ID);
	AssertNotRendered(include1Prefix + STEP1_PANEL_ID);
	AssertTextEquals(include1Prefix + OUTPUT_ID, text);

	clickPrevious();

	AssertRendered(include1Prefix + STEP1_PANEL_ID);
	AssertNotRendered(include1Prefix + STEP2_PANEL_ID);
	AssertValueEquals(include1Prefix + INPUT_ID, text);

    }

    @Test
    public void testLayoutAttribute(Template template) throws Exception {
	renderPage(template);
	// inlude_1 has layout=inline(default)
	// include_2 has layout=block
	// include_3 has layout=none
	writeStatus("Testing layout attribute...");

	String inlude1Id = getParentId() + FORM1_ID + INCLUDE1_ID;
	String inlude2Id = getParentId() + FORM1_ID + INCLUDE2_ID;
	String inlude3Id = getParentId() + FORM1_ID + INCLUDE3_ID;

	Assert.assertTrue(isPresentById(inlude1Id));
	Number type = selenium.getXpathCount("//*[@id='" + inlude1Id + "' and (name()='span' or name()='SPAN')]");
	Assert.assertTrue(type.intValue() == 1, "panel_1 has layout=inline(default) and should be 'span' element");

	Assert.assertTrue(isPresentById(inlude2Id));
	type = selenium.getXpathCount("//*[@id='" + inlude2Id + "' and (name()='DIV' or name()='div')]");
	Assert.assertTrue(type.intValue() == 1, "panel_2 has layout=block and should be 'div' element");

	// panel_3 has layout=none and should not present if a child component
	// is rendered
	Assert.assertFalse(isPresentById(inlude3Id), "panel_3 has layout=none and should not peresent if a child component is rendered ");

	//	// remove child component rendering
	//	writeStatus("Click button 3");
	//	String buttonId = getParentId() + FORM1_ID + BUTTON3_ID;
	//	clickById(buttonId);
	//	waitForAjaxCompletion();
	//
	//	// panel_3 has layout=none and should present if no child component is
	//	// rendered with id of a child component and display:none style
	//	Assert.assertTrue(isPresentById(inlude3Id + "_text"), "panel_3 has layout=none and should peresent if no child component is rendered with id of a child component");
	//	Assert.assertFalse(isVisibleById(inlude3Id + "_text"), "panel_3 has layout=none and should peresent if no child component is rendered with display:none style");
	clickReset();
    }

    @Test
    public void testRenderedAttribute(Template template) throws Exception {
	renderPage(template);
	writeStatus("Testing rendered attribute...");

	String panelId = getParentId() + FORM2_ID + INCLUDE4_ID;

	// panel_4 has rendered=true and should present on page
	AssertRendered(panelId);

	// change rendered attribute to false
	writeStatus("Click button 4");
	String buttonId = getParentId() + FORM2_ID + BUTTON4_ID;
	clickCommandAndWait(buttonId);

	// panel_4 has rendered=false and should not present on page
	AssertNotRendered(panelId);
	clickReset();
    }

    private void clickNext() {
	String buttonId = getParentId() + FORM2_ID + INCLUDE4_ID + ":" + NEXT_BUTTON_ID;
	clickAjaxCommandAndWait(buttonId);
    }

    private void clickPrevious() {
	String buttonId = getParentId() + FORM2_ID + INCLUDE4_ID + ":" + PREVIOUS_BUTTON_ID;
	clickAjaxCommandAndWait(buttonId);
    }

    private void clickReset() {
	String buttonId = getParentId() + FORM1_ID + RESET_BUTTON_ID;
	writeStatus("Click reset button");
	clickCommandAndWait(buttonId);
    }
}
