/**
 * License Agreement.
 *
 * JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */ 
package org.richfaces.testng;

import org.ajax4jsf.template.Template;
import org.richfaces.SeleniumTestBase;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AjaxLogTest extends SeleniumTestBase {

    @Test
    public void testAjaxLogLayout(Template template) {
        renderPage(template);

        String parentId = getParentId() + "_form:";

        String inputElemId = parentId + "input";
        String logElemId = "logConsole";

        writeStatus("Type smth. All typing is being logged");

        type(inputElemId, "typing");
        waitForAjaxCompletion();

        writeStatus("test that log element is present");
        AssertRendered(logElemId);

        writeStatus("test that clear button is present and has proper label");

        if (selenium.isElementPresent("//div[@id='logConsole']/button")) {
            String clearBtnLabel = selenium.getText("//div[@id='logConsole']/button");
            if (null == clearBtnLabel || !clearBtnLabel.trim().equalsIgnoreCase("Clear")) {
                Assert.fail("Clear button has obscure label");
            }
        } else {
            Assert.fail("Clear button is not rendered");
        }

        writeStatus("at least dozen messages have to be logged");
        int logCount = selenium.getXpathCount("//div[@id='logConsole']/div").intValue();
        if (logCount < 12) {
            Assert.fail("There are suspiciously few log messages here");
        }

        writeStatus("check clear button");
        selenium.click("//div[@id='logConsole']/button");

        logCount = selenium.getXpathCount("//div[@id='logConsole']/div").intValue();
        if (logCount > 0) {
            Assert.fail("log must be empty");
        }

        writeStatus("test style attribute");

        //String style = selenium.getAttribute("//div[@id='logConsole']/@style");
        int w = selenium.getElementWidth("//div[@id='logConsole']").intValue();
        int h = selenium.getElementHeight("//div[@id='logConsole']").intValue();

        if (800 != w || 300 != h) {
            Assert.fail("Style does not affect ajax log component");
        }
    }

    @Override
    public String getTestUrl() {
        return "pages/ajaxLog/ajaxLogTest.xhtml";
    }

}
