/**
 * License Agreement.
 *
 * JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */ 
package org.richfaces.testng;

import org.ajax4jsf.template.Template;
import org.richfaces.SeleniumTestBase;
import org.testng.annotations.Test;

public class ToolBarTest extends SeleniumTestBase {

    private static final String TOOLBAR = "toolbar";

    private final static String RESULT_FAILED_TEXT = "No";

    private final static String RESULT_PASSED_TEXT = "Passed";

    /* Tab panel group/item separator constants */
    private final static String LINE_SEPARATOR = "line";

    private final static String DISC_SEPARATOR = "disc";

    private final static String GRID_SEPARATOR = "grid";

    private final static String SQUARE_SEPARATOR = "square";

    private final static String NONE_SEPARATOR = "none";

    @Test
    public void testToolBarComponentLayout(Template template) {
        renderPage(template);

        writeStatus("Check component layout");

        String id = getParentId() + "_form:";

        writeStatus("Switch toolbar group separator");

        clickAjaxCommandAndWait(id + "gs_" + LINE_SEPARATOR);
        clickAjaxCommandAndWait(id + "gs_" + DISC_SEPARATOR);
        clickAjaxCommandAndWait(id + "gs_" + GRID_SEPARATOR);
        clickAjaxCommandAndWait(id + "gs_" + SQUARE_SEPARATOR);
        clickAjaxCommandAndWait(id + "gs_" + NONE_SEPARATOR);

        writeStatus("Switch toolbar group item separator");

        clickAjaxCommandAndWait(id + "gis_" + LINE_SEPARATOR);
        clickAjaxCommandAndWait(id + "gis_" + DISC_SEPARATOR);
        clickAjaxCommandAndWait(id + "gis_" + GRID_SEPARATOR);
        clickAjaxCommandAndWait(id + "gis_" + SQUARE_SEPARATOR);
        clickAjaxCommandAndWait(id + "gis_" + NONE_SEPARATOR);
    }

    @Test
    public void testToolBarEvents(Template template) {
        renderPage(template);

        writeStatus("Check component event triggering");

        String toolbar = getParentId() + TOOLBAR + "_click";
        testOnclickEvent(toolbar, toolbar + "_result", RESULT_FAILED_TEXT, RESULT_PASSED_TEXT);

        toolbar = getParentId() + TOOLBAR + "_dblclick";
        testOnDblclickEvent(toolbar, toolbar + "_result", RESULT_FAILED_TEXT, RESULT_PASSED_TEXT);

        toolbar = getParentId() + TOOLBAR + "_mousedown";
        testOnmousedownEvent(toolbar, toolbar + "_result", RESULT_FAILED_TEXT, RESULT_PASSED_TEXT);

        toolbar = getParentId() + TOOLBAR + "_mousemove";
        testOnmousemoveEvent(toolbar, toolbar + "_result", RESULT_FAILED_TEXT, RESULT_PASSED_TEXT);

        toolbar = getParentId() + TOOLBAR + "_mouseout";
        testOnmouseoutEvent(toolbar, toolbar + "_result", RESULT_FAILED_TEXT, RESULT_PASSED_TEXT);

        toolbar = getParentId() + TOOLBAR + "_mouseover";
        testOnmouseoverEvent(toolbar, toolbar + "_result", RESULT_FAILED_TEXT, RESULT_PASSED_TEXT);

        toolbar = getParentId() + TOOLBAR + "_mouseup";
        testOnmouseupEvent(toolbar, toolbar + "_result", RESULT_FAILED_TEXT, RESULT_PASSED_TEXT);
    }

    @Override
    public String getTestUrl() {
        return "pages/toolBar/toolBarTest.xhtml";
    }

}
