/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant;

import java.io.File;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Reference;
import org.sonatype.aether.ant.AetherUtils;
import org.sonatype.aether.ant.AntLogger;
import org.sonatype.aether.ant.AntModelResolver;
import org.sonatype.aether.ant.AntRepositoryListener;
import org.sonatype.aether.ant.AntServiceLocator;
import org.sonatype.aether.ant.AntSettingsDecryptorFactory;
import org.sonatype.aether.ant.AntTransferListener;
import org.sonatype.aether.ant.ConverterUtils;
import org.sonatype.aether.ant.ProjectWorkspaceReader;
import org.sonatype.aether.ant.SettingsUtils;
import org.sonatype.aether.ant.org.apache.maven.model.Dependency;
import org.sonatype.aether.ant.org.apache.maven.model.Model;
import org.sonatype.aether.ant.org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.sonatype.aether.ant.org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.sonatype.aether.ant.org.apache.maven.model.building.FileModelSource;
import org.sonatype.aether.ant.org.apache.maven.model.building.ModelBuilder;
import org.sonatype.aether.ant.org.apache.maven.model.building.ModelBuildingException;
import org.sonatype.aether.ant.org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.sonatype.aether.ant.org.apache.maven.settings.Mirror;
import org.sonatype.aether.ant.org.apache.maven.settings.Proxy;
import org.sonatype.aether.ant.org.apache.maven.settings.Server;
import org.sonatype.aether.ant.org.apache.maven.settings.Settings;
import org.sonatype.aether.ant.org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.sonatype.aether.ant.org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.sonatype.aether.ant.org.apache.maven.settings.building.SettingsBuilder;
import org.sonatype.aether.ant.org.apache.maven.settings.building.SettingsBuildingException;
import org.sonatype.aether.ant.org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.sonatype.aether.ant.org.apache.maven.settings.crypto.SettingsDecrypter;
import org.sonatype.aether.ant.org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.sonatype.aether.ant.org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.ant.org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.ant.org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.ant.org.sonatype.aether.collection.CollectResult;
import org.sonatype.aether.ant.org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.ant.org.sonatype.aether.connector.async.AsyncRepositoryConnectorFactory;
import org.sonatype.aether.ant.org.sonatype.aether.connector.file.FileRepositoryConnectorFactory;
import org.sonatype.aether.ant.org.sonatype.aether.impl.RemoteRepositoryManager;
import org.sonatype.aether.ant.org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.ant.org.sonatype.aether.repository.AuthenticationSelector;
import org.sonatype.aether.ant.org.sonatype.aether.repository.LocalRepositoryManager;
import org.sonatype.aether.ant.org.sonatype.aether.repository.MirrorSelector;
import org.sonatype.aether.ant.org.sonatype.aether.repository.ProxySelector;
import org.sonatype.aether.ant.org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.ant.org.sonatype.aether.spi.connector.RepositoryConnectorFactory;
import org.sonatype.aether.ant.org.sonatype.aether.spi.log.Logger;
import org.sonatype.aether.ant.org.sonatype.aether.util.DefaultRepositoryCache;
import org.sonatype.aether.ant.org.sonatype.aether.util.repository.ConservativeAuthenticationSelector;
import org.sonatype.aether.ant.org.sonatype.aether.util.repository.DefaultAuthenticationSelector;
import org.sonatype.aether.ant.org.sonatype.aether.util.repository.DefaultMirrorSelector;
import org.sonatype.aether.ant.org.sonatype.aether.util.repository.DefaultProxySelector;
import org.sonatype.aether.ant.types.Dependencies;
import org.sonatype.aether.ant.types.Exclusion;
import org.sonatype.aether.ant.types.LocalRepository;
import org.sonatype.aether.ant.types.Pom;
import org.sonatype.aether.ant.types.RemoteRepositories;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntRepoSys {
    private static boolean OS_WINDOWS = Os.isFamily((String)"windows");
    private static final ModelBuilder modelBuilder = new DefaultModelBuilderFactory().newInstance();
    private static final SettingsBuilder settingsBuilder = new DefaultSettingsBuilderFactory().newInstance();
    private static final SettingsDecrypter settingsDecrypter = new AntSettingsDecryptorFactory().newInstance();
    private Project project;
    private AntServiceLocator locator;
    private RepositorySystem repoSys;
    private RemoteRepositoryManager remoteRepoMan;
    private File userSettings;
    private File globalSettings;
    private Settings settings;
    private List<org.sonatype.aether.ant.types.Mirror> mirrors = new CopyOnWriteArrayList<org.sonatype.aether.ant.types.Mirror>();
    private List<org.sonatype.aether.ant.types.Proxy> proxies = new CopyOnWriteArrayList<org.sonatype.aether.ant.types.Proxy>();
    private List<org.sonatype.aether.ant.types.Authentication> authentications = new CopyOnWriteArrayList<org.sonatype.aether.ant.types.Authentication>();
    private LocalRepository localRepository;
    private Pom defaultPom;
    private File mavenRepoDirFromProperty;

    private static <T> boolean eq(T o1, T o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static synchronized AntRepoSys getInstance(Project project) {
        Object obj = project.getReference("aether");
        if (obj instanceof AntRepoSys) {
            return (AntRepoSys)obj;
        }
        AntRepoSys instance = new AntRepoSys(project);
        project.addReference("aether", (Object)instance);
        instance.initDefaults();
        return instance;
    }

    private AntRepoSys(Project project) {
        this.project = project;
        this.locator = new AntServiceLocator(project);
        this.locator.setServices(Logger.class, new AntLogger(project));
        this.locator.setServices(ModelBuilder.class, modelBuilder);
        this.locator.addService(RepositoryConnectorFactory.class, FileRepositoryConnectorFactory.class);
        this.locator.addService(RepositoryConnectorFactory.class, AsyncRepositoryConnectorFactory.class);
    }

    private void initDefaults() {
        org.sonatype.aether.ant.types.RemoteRepository repo = new org.sonatype.aether.ant.types.RemoteRepository();
        repo.setProject(this.project);
        repo.setId("central");
        repo.setUrl("http://repo1.maven.org/maven2/");
        this.project.addReference("central", (Object)repo);
        repo = new org.sonatype.aether.ant.types.RemoteRepository();
        repo.setProject(this.project);
        repo.setRefid(new Reference(this.project, "central"));
        RemoteRepositories repos = new RemoteRepositories();
        repos.setProject(this.project);
        repos.addRemoterepo(repo);
        this.project.addReference("aether.repositories", (Object)repos);
        String localRepoResolved = this.project.getProperty("maven.repo.local.resolved");
        if (localRepoResolved != null) {
            this.mavenRepoDirFromProperty = new File(localRepoResolved);
        } else {
            String mavenRepoProperty = this.project.getProperty("maven.repo.local");
            if (mavenRepoProperty != null) {
                this.mavenRepoDirFromProperty = this.project.resolveFile(mavenRepoProperty);
                this.project.setProperty("maven.repo.local.resolved", this.mavenRepoDirFromProperty.getAbsolutePath());
            }
        }
    }

    public synchronized RepositorySystem getSystem() {
        if (this.repoSys == null) {
            this.repoSys = this.locator.getService(RepositorySystem.class);
            if (this.repoSys == null) {
                throw new BuildException("The repository system could not be initialized");
            }
        }
        return this.repoSys;
    }

    private synchronized RemoteRepositoryManager getRemoteRepoMan() {
        if (this.remoteRepoMan == null) {
            this.remoteRepoMan = this.locator.getService(RemoteRepositoryManager.class);
            if (this.remoteRepoMan == null) {
                throw new BuildException("The repository system could not be initialized");
            }
        }
        return this.remoteRepoMan;
    }

    public RepositorySystemSession getSession(Task task, LocalRepository localRepo) {
        MavenRepositorySystemSession session = new MavenRepositorySystemSession();
        LinkedHashMap<Object, Object> configProps = new LinkedHashMap<Object, Object>();
        configProps.put("aether.connector.userAgent", this.getUserAgent());
        configProps.putAll(System.getProperties());
        configProps.putAll(this.project.getProperties());
        configProps.putAll(this.project.getUserProperties());
        session.setConfigProps(configProps);
        session.setNotFoundCachingEnabled(false);
        session.setTransferErrorCachingEnabled(false);
        session.setOffline(this.isOffline());
        session.setUserProps(this.project.getUserProperties());
        session.setLocalRepositoryManager(this.getLocalRepoMan(localRepo));
        session.setProxySelector(this.getProxySelector());
        session.setMirrorSelector(this.getMirrorSelector());
        session.setAuthenticationSelector(this.getAuthSelector());
        session.setCache(new DefaultRepositoryCache());
        session.setRepositoryListener(new AntRepositoryListener(task));
        session.setTransferListener(new AntTransferListener(task));
        session.setWorkspaceReader(ProjectWorkspaceReader.getInstance());
        return session;
    }

    private String getUserAgent() {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("Apache-Ant/").append(this.project.getProperty("ant.version"));
        buffer.append(" (");
        buffer.append("Java ").append(System.getProperty("java.version"));
        buffer.append("; ");
        buffer.append(System.getProperty("os.name")).append(" ").append(System.getProperty("os.version"));
        buffer.append(")");
        buffer.append(" Aether");
        return buffer.toString();
    }

    private boolean isOffline() {
        String prop = this.project.getProperty("aether.offline");
        if (prop != null) {
            return Boolean.parseBoolean(prop);
        }
        return this.getSettings().isOffline();
    }

    private File getDefaultLocalRepoDir() {
        if (this.mavenRepoDirFromProperty != null) {
            return this.mavenRepoDirFromProperty;
        }
        Settings settings = this.getSettings();
        if (settings.getLocalRepository() != null) {
            return new File(settings.getLocalRepository());
        }
        return new File(new File(this.project.getProperty("user.home"), ".m2"), "repository");
    }

    private LocalRepositoryManager getLocalRepoMan(LocalRepository localRepo) {
        if (localRepo == null) {
            localRepo = this.localRepository;
        }
        File repoDir = localRepo != null && localRepo.getDir() != null ? localRepo.getDir() : this.getDefaultLocalRepoDir();
        org.sonatype.aether.ant.org.sonatype.aether.repository.LocalRepository repo = new org.sonatype.aether.ant.org.sonatype.aether.repository.LocalRepository(repoDir);
        return this.getSystem().newLocalRepositoryManager(repo);
    }

    private synchronized Settings getSettings() {
        if (this.settings == null) {
            DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
            request.setUserSettingsFile(this.getUserSettings());
            request.setGlobalSettingsFile(this.getGlobalSettings());
            request.setSystemProperties(this.getSystemProperties());
            request.setUserProperties(this.getUserProperties());
            try {
                this.settings = settingsBuilder.build(request).getEffectiveSettings();
            }
            catch (SettingsBuildingException e) {
                this.project.log("Could not process settings.xml: " + e.getMessage(), (Throwable)e, 1);
            }
            SettingsDecryptionResult result = settingsDecrypter.decrypt(new DefaultSettingsDecryptionRequest(this.settings));
            this.settings.setServers(result.getServers());
            this.settings.setProxies(result.getProxies());
        }
        return this.settings;
    }

    private ProxySelector getProxySelector() {
        DefaultProxySelector selector = new DefaultProxySelector();
        for (org.sonatype.aether.ant.types.Proxy proxy : this.proxies) {
            selector.add(ConverterUtils.toProxy(proxy), proxy.getNonProxyHosts());
        }
        Settings settings = this.getSettings();
        for (Proxy proxy : settings.getProxies()) {
            Authentication auth = null;
            if (proxy.getUsername() != null || proxy.getPassword() != null) {
                auth = new Authentication(proxy.getUsername(), proxy.getPassword());
            }
            selector.add(new org.sonatype.aether.ant.org.sonatype.aether.repository.Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), auth), proxy.getNonProxyHosts());
        }
        return selector;
    }

    private MirrorSelector getMirrorSelector() {
        DefaultMirrorSelector selector = new DefaultMirrorSelector();
        for (org.sonatype.aether.ant.types.Mirror mirror : this.mirrors) {
            selector.add(mirror.getId(), mirror.getUrl(), mirror.getType(), false, mirror.getMirrorOf(), null);
        }
        Settings settings = this.getSettings();
        for (Mirror mirror : settings.getMirrors()) {
            selector.add(String.valueOf(mirror.getId()), mirror.getUrl(), mirror.getLayout(), false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        return selector;
    }

    private AuthenticationSelector getAuthSelector() {
        DefaultAuthenticationSelector selector = new DefaultAuthenticationSelector();
        HashSet<String> ids = new HashSet<String>();
        for (org.sonatype.aether.ant.types.Authentication auth : this.authentications) {
            List<String> servers = auth.getServers();
            if (servers.isEmpty()) continue;
            Authentication a = ConverterUtils.toAuthentication(auth);
            for (String server : servers) {
                if (!ids.add(server)) continue;
                selector.add(server, a);
            }
        }
        Settings settings = this.getSettings();
        for (Server server : settings.getServers()) {
            Authentication auth = new Authentication(server.getUsername(), server.getPassword(), server.getPrivateKey(), server.getPassphrase());
            selector.add(server.getId(), auth);
        }
        return new ConservativeAuthenticationSelector(selector);
    }

    public synchronized void setUserSettings(File file) {
        if (!AntRepoSys.eq(this.userSettings, file)) {
            this.settings = null;
        }
        this.userSettings = file;
    }

    File getUserSettings() {
        if (this.userSettings == null) {
            this.userSettings = AetherUtils.findUserSettings(this.project);
        }
        return this.userSettings;
    }

    public void setGlobalSettings(File file) {
        if (!AntRepoSys.eq(this.globalSettings, file)) {
            this.settings = null;
        }
        this.globalSettings = file;
    }

    File getGlobalSettings() {
        if (this.globalSettings == null) {
            this.globalSettings = AetherUtils.findGlobalSettings(this.project);
        }
        return this.globalSettings;
    }

    public void addProxy(org.sonatype.aether.ant.types.Proxy proxy) {
        this.proxies.add(proxy);
    }

    public void addMirror(org.sonatype.aether.ant.types.Mirror mirror) {
        this.mirrors.add(mirror);
    }

    public void addAuthentication(org.sonatype.aether.ant.types.Authentication authentication) {
        this.authentications.add(authentication);
    }

    public void setLocalRepository(LocalRepository localRepository) {
        this.localRepository = localRepository;
    }

    public Model loadModel(Task task, File pomFile, boolean local, RemoteRepositories remoteRepositories) {
        RepositorySystemSession session = this.getSession(task, null);
        remoteRepositories = remoteRepositories == null ? AetherUtils.getDefaultRepositories(this.project) : remoteRepositories;
        List<RemoteRepository> repositories = ConverterUtils.toRepositories(task.getProject(), session, remoteRepositories, this.getRemoteRepoMan());
        AntModelResolver modelResolver = new AntModelResolver(session, "project", this.getSystem(), this.getRemoteRepoMan(), repositories);
        Settings settings = this.getSettings();
        try {
            DefaultModelBuildingRequest request = new DefaultModelBuildingRequest();
            request.setLocationTracking(true);
            request.setProcessPlugins(false);
            if (local) {
                request.setPomFile(pomFile);
                request.setValidationLevel(30);
            } else {
                request.setModelSource(new FileModelSource(pomFile));
                request.setValidationLevel(0);
            }
            request.setSystemProperties(this.getSystemProperties());
            request.setUserProperties(this.getUserProperties());
            request.setProfiles((List)SettingsUtils.convert(settings.getProfiles()));
            request.setActiveProfileIds((List)settings.getActiveProfiles());
            request.setModelResolver(modelResolver);
            return modelBuilder.build(request).getEffectiveModel();
        }
        catch (ModelBuildingException e) {
            throw new BuildException("Could not load POM " + pomFile + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private Properties getSystemProperties() {
        Properties props = new Properties();
        this.getEnvProperties(props);
        props.putAll((Map<?, ?>)System.getProperties());
        ConverterUtils.addProperties(props, this.project.getProperties());
        return props;
    }

    private Properties getEnvProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        boolean envCaseInsensitive = OS_WINDOWS;
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            String key = entry.getKey();
            if (envCaseInsensitive) {
                key = key.toUpperCase(Locale.ENGLISH);
            }
            key = "env." + key;
            props.put(key, entry.getValue());
        }
        return props;
    }

    private Properties getUserProperties() {
        return ConverterUtils.addProperties(null, this.project.getUserProperties());
    }

    public void setDefaultPom(Pom pom) {
        this.defaultPom = pom;
    }

    public Pom getDefaultPom() {
        return this.defaultPom;
    }

    public CollectResult collectDependencies(Task task, Dependencies dependencies, LocalRepository localRepository, RemoteRepositories remoteRepositories) {
        CollectResult result;
        RepositorySystemSession session = this.getSession(task, localRepository);
        remoteRepositories = remoteRepositories == null ? AetherUtils.getDefaultRepositories(this.project) : remoteRepositories;
        List<RemoteRepository> repos = ConverterUtils.toRepositories(this.project, session, remoteRepositories, this.getRemoteRepoMan());
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRequestContext("project");
        for (RemoteRepository repo : repos) {
            task.getProject().log("Using remote repository " + repo, 3);
            collectRequest.addRepository(repo);
        }
        if (dependencies != null) {
            List<Exclusion> globalExclusions = dependencies.getExclusions();
            HashSet<String> ids = new HashSet<String>();
            for (org.sonatype.aether.ant.types.Dependency dep : dependencies.getDependencies()) {
                ids.add(dep.getVersionlessKey());
                collectRequest.addDependency(ConverterUtils.toDependency(dep, globalExclusions, session));
            }
            if (dependencies.getPom() != null) {
                Model model = dependencies.getPom().getModel(task);
                for (Dependency dep : model.getDependencies()) {
                    org.sonatype.aether.ant.types.Dependency dependency = new org.sonatype.aether.ant.types.Dependency();
                    dependency.setArtifactId(dep.getArtifactId());
                    dependency.setClassifier(dep.getClassifier());
                    dependency.setGroupId(dep.getGroupId());
                    dependency.setScope(dep.getScope());
                    dependency.setType(dep.getType());
                    dependency.setVersion(dep.getVersion());
                    if (ids.contains(dependency.getVersionlessKey())) continue;
                    if (dep.getSystemPath() != null && dep.getSystemPath().length() > 0) {
                        dependency.setSystemPath(task.getProject().resolveFile(dep.getSystemPath()));
                    }
                    for (org.sonatype.aether.ant.org.apache.maven.model.Exclusion exc : dep.getExclusions()) {
                        Exclusion exclusion = new Exclusion();
                        exclusion.setGroupId(exc.getGroupId());
                        exclusion.setArtifactId(exc.getArtifactId());
                        exclusion.setClassifier("*");
                        exclusion.setExtension("*");
                        dependency.addExclusion(exclusion);
                    }
                    collectRequest.addDependency(ConverterUtils.toDependency(dependency, globalExclusions, session));
                }
            }
        }
        task.getProject().log("Collecting dependencies", 3);
        try {
            result = this.getSystem().collectDependencies(session, collectRequest);
        }
        catch (DependencyCollectionException e) {
            throw new BuildException("Could not collect dependencies: " + e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

