/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.data;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jacoco.core.data.ExecutionDataReader;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.SessionInfoStore;

public class ExecFileLoader {
    private final SessionInfoStore sessionInfos = new SessionInfoStore();
    private final ExecutionDataStore executionData = new ExecutionDataStore();

    public void load(InputStream stream) throws IOException {
        ExecutionDataReader reader = new ExecutionDataReader(new BufferedInputStream(stream));
        reader.setExecutionDataVisitor(this.executionData);
        reader.setSessionInfoVisitor(this.sessionInfos);
        reader.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        try {
            this.load(stream);
        }
        finally {
            ((InputStream)stream).close();
        }
    }

    public SessionInfoStore getSessionInfoStore() {
        return this.sessionInfos;
    }

    public ExecutionDataStore getExecutionDataStore() {
        return this.executionData;
    }
}

