/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.FastRollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.helpers.Booleans;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.net.Advertiser;

@Plugin(name="FastRollingFile", category="Core", elementType="appender", printObject=true)
public final class FastRollingFileAppender<T extends Serializable>
extends AbstractOutputStreamAppender<T> {
    private final String fileName;
    private final String filePattern;
    private Object advertisement;
    private final Advertiser advertiser;

    private FastRollingFileAppender(String name, Layout<T> layout, Filter filter, RollingFileManager manager, String fileName, String filePattern, boolean handleException, boolean immediateFlush, Advertiser advertiser) {
        super(name, layout, filter, handleException, immediateFlush, manager);
        if (advertiser != null) {
            HashMap<String, String> configuration = new HashMap<String, String>(layout.getContentFormat());
            configuration.put("contentType", layout.getContentType());
            configuration.put("name", name);
            this.advertisement = advertiser.advertise(configuration);
        }
        this.fileName = fileName;
        this.filePattern = filePattern;
        this.advertiser = advertiser;
    }

    @Override
    public void stop() {
        super.stop();
        if (this.advertiser != null) {
            this.advertiser.unadvertise(this.advertisement);
        }
    }

    @Override
    public void append(LogEvent event) {
        FastRollingFileManager manager = (FastRollingFileManager)this.getManager();
        manager.checkRollover(event);
        manager.setEndOfBatch(event.isEndOfBatch());
        super.append(event);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    @PluginFactory
    public static <S extends Serializable> FastRollingFileAppender<S> createAppender(@PluginAttr(value="fileName") String fileName, @PluginAttr(value="filePattern") String filePattern, @PluginAttr(value="append") String append, @PluginAttr(value="name") String name, @PluginAttr(value="immediateFlush") String immediateFlush, @PluginElement(value="policy") TriggeringPolicy policy, @PluginElement(value="strategy") RolloverStrategy strategy, @PluginElement(value="layout") Layout<S> layout, @PluginElement(value="filter") Filter filter, @PluginAttr(value="suppressExceptions") String suppress, @PluginAttr(value="advertise") String advertise, @PluginAttr(value="advertiseURI") String advertiseURI, @PluginConfiguration Configuration config) {
        FastRollingFileManager manager;
        boolean isAppend = Booleans.parseBoolean(append, true);
        boolean handleExceptions = Booleans.parseBoolean(suppress, true);
        boolean isFlush = Booleans.parseBoolean(immediateFlush, true);
        boolean isAdvertise = Boolean.parseBoolean(advertise);
        if (name == null) {
            LOGGER.error("No name provided for FileAppender");
            return null;
        }
        if (fileName == null) {
            LOGGER.error("No filename was provided for FileAppender with name " + name);
            return null;
        }
        if (filePattern == null) {
            LOGGER.error("No filename pattern provided for FileAppender with name " + name);
            return null;
        }
        if (policy == null) {
            LOGGER.error("A TriggeringPolicy must be provided");
            return null;
        }
        if (strategy == null) {
            strategy = DefaultRolloverStrategy.createStrategy(null, null, "true", config);
        }
        if (layout == null) {
            PatternLayout l;
            layout = l = PatternLayout.createLayout(null, null, null, null, null);
        }
        if ((manager = FastRollingFileManager.getFastRollingFileManager(fileName, filePattern, isAppend, isFlush, policy, strategy, advertiseURI, layout)) == null) {
            return null;
        }
        return new FastRollingFileAppender<String>(name, layout, filter, manager, fileName, filePattern, handleExceptions, isFlush, isAdvertise ? config.getAdvertiser() : null);
    }
}

