/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.FileManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.helpers.Booleans;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.net.Advertiser;

@Plugin(name="File", category="Core", elementType="appender", printObject=true)
public final class FileAppender<T extends Serializable>
extends AbstractOutputStreamAppender<T> {
    private final String fileName;
    private final Advertiser advertiser;
    private Object advertisement;

    private FileAppender(String name, Layout<T> layout, Filter filter, FileManager manager, String filename, boolean handleException, boolean immediateFlush, Advertiser advertiser) {
        super(name, layout, filter, handleException, immediateFlush, manager);
        if (advertiser != null) {
            HashMap<String, String> configuration = new HashMap<String, String>(layout.getContentFormat());
            configuration.putAll(manager.getContentFormat());
            configuration.put("contentType", layout.getContentType());
            configuration.put("name", name);
            this.advertisement = advertiser.advertise(configuration);
        }
        this.fileName = filename;
        this.advertiser = advertiser;
    }

    @Override
    public void stop() {
        super.stop();
        if (this.advertiser != null) {
            this.advertiser.unadvertise(this.advertisement);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    @PluginFactory
    public static <S extends Serializable> FileAppender<S> createAppender(@PluginAttr(value="fileName") String fileName, @PluginAttr(value="append") String append, @PluginAttr(value="locking") String locking, @PluginAttr(value="name") String name, @PluginAttr(value="immediateFlush") String immediateFlush, @PluginAttr(value="suppressExceptions") String suppress, @PluginAttr(value="bufferedIO") String bufferedIO, @PluginElement(value="layout") Layout<S> layout, @PluginElement(value="filters") Filter filter, @PluginAttr(value="advertise") String advertise, @PluginAttr(value="advertiseURI") String advertiseURI, @PluginConfiguration Configuration config) {
        FileManager manager;
        boolean isAppend = Booleans.parseBoolean(append, true);
        boolean isLocking = Boolean.parseBoolean(locking);
        boolean isBuffered = Booleans.parseBoolean(bufferedIO, true);
        boolean isAdvertise = Boolean.parseBoolean(advertise);
        if (isLocking && isBuffered) {
            if (bufferedIO != null) {
                LOGGER.warn("Locking and buffering are mutually exclusive. No buffering will occur for " + fileName);
            }
            isBuffered = false;
        }
        boolean isFlush = Booleans.parseBoolean(immediateFlush, true);
        boolean handleExceptions = Booleans.parseBoolean(suppress, true);
        if (name == null) {
            LOGGER.error("No name provided for FileAppender");
            return null;
        }
        if (fileName == null) {
            LOGGER.error("No filename provided for FileAppender with name " + name);
            return null;
        }
        if (layout == null) {
            PatternLayout l;
            layout = l = PatternLayout.createLayout(null, null, null, null, null);
        }
        if ((manager = FileManager.getFileManager(fileName, isAppend, isLocking, isBuffered, advertiseURI, layout)) == null) {
            return null;
        }
        return new FileAppender<String>(name, layout, filter, manager, fileName, handleExceptions, isFlush, isAdvertise ? config.getAdvertiser() : null);
    }
}

