/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.helpers.Booleans;
import org.apache.logging.log4j.core.layout.SerializedLayout;
import org.apache.logging.log4j.core.net.AbstractSocketManager;
import org.apache.logging.log4j.core.net.Advertiser;
import org.apache.logging.log4j.core.net.DatagramSocketManager;
import org.apache.logging.log4j.core.net.Protocol;
import org.apache.logging.log4j.core.net.TCPSocketManager;
import org.apache.logging.log4j.util.EnglishEnums;

@Plugin(name="Socket", category="Core", elementType="appender", printObject=true)
public class SocketAppender<T extends Serializable>
extends AbstractOutputStreamAppender<T> {
    private Object advertisement;
    private final Advertiser advertiser;

    protected SocketAppender(String name, Layout<T> layout, Filter filter, AbstractSocketManager manager, boolean handleException, boolean immediateFlush, Advertiser advertiser) {
        super(name, layout, filter, handleException, immediateFlush, manager);
        if (advertiser != null) {
            HashMap<String, String> configuration = new HashMap<String, String>(layout.getContentFormat());
            configuration.putAll(manager.getContentFormat());
            configuration.put("contentType", layout.getContentType());
            configuration.put("name", name);
            this.advertisement = advertiser.advertise(configuration);
        }
        this.advertiser = advertiser;
    }

    @Override
    public void stop() {
        super.stop();
        if (this.advertiser != null) {
            this.advertiser.unadvertise(this.advertisement);
        }
    }

    @PluginFactory
    public static <S extends Serializable> SocketAppender<S> createAppender(@PluginAttr(value="host") String host, @PluginAttr(value="port") String portNum, @PluginAttr(value="protocol") String protocol, @PluginAttr(value="reconnectionDelay") String delay, @PluginAttr(value="immediateFail") String immediateFail, @PluginAttr(value="name") String name, @PluginAttr(value="immediateFlush") String immediateFlush, @PluginAttr(value="suppressExceptions") String suppress, @PluginElement(value="layout") Layout<S> layout, @PluginElement(value="filters") Filter filter, @PluginAttr(value="advertise") String advertise, @PluginConfiguration Configuration config) {
        AbstractSocketManager manager;
        boolean isFlush = Booleans.parseBoolean(immediateFlush, true);
        boolean isAdvertise = Boolean.parseBoolean(advertise);
        boolean handleExceptions = Booleans.parseBoolean(suppress, true);
        boolean fail = Booleans.parseBoolean(immediateFail, true);
        int reconnectDelay = AbstractAppender.parseInt(delay, 0);
        int port = AbstractAppender.parseInt(portNum, 0);
        if (layout == null) {
            SerializedLayout l;
            layout = l = SerializedLayout.createLayout();
        }
        if (name == null) {
            LOGGER.error("No name provided for SocketAppender");
            return null;
        }
        Protocol p = (Protocol)EnglishEnums.valueOf(Protocol.class, (String)(protocol != null ? protocol : Protocol.TCP.name()));
        if (p.equals((Object)Protocol.UDP)) {
            isFlush = true;
        }
        if ((manager = SocketAppender.createSocketManager(p, host, port, reconnectDelay, fail, layout)) == null) {
            return null;
        }
        return new SocketAppender<LogEvent>(name, layout, filter, manager, handleExceptions, isFlush, isAdvertise ? config.getAdvertiser() : null);
    }

    protected static AbstractSocketManager createSocketManager(Protocol p, String host, int port, int delay, boolean immediateFail, Layout layout) {
        switch (p) {
            case TCP: {
                return TCPSocketManager.getSocketManager(host, port, delay, immediateFail, layout);
            }
            case UDP: {
                return DatagramSocketManager.getSocketManager(host, port, layout);
            }
        }
        return null;
    }
}

