/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.nosql;

import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.db.AbstractDatabaseAppender;
import org.apache.logging.log4j.core.appender.db.nosql.NoSQLDatabaseManager;
import org.apache.logging.log4j.core.appender.db.nosql.NoSQLProvider;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="NoSql", category="Core", elementType="appender", printObject=true)
public final class NoSQLAppender
extends AbstractDatabaseAppender<NoSQLDatabaseManager<?>> {
    private final String description = this.getName() + "{ manager=" + this.getManager() + " }";

    private NoSQLAppender(String name, Filter filter, boolean handleException, NoSQLDatabaseManager<?> manager) {
        super(name, filter, handleException, manager);
    }

    @Override
    public String toString() {
        return this.description;
    }

    @PluginFactory
    public static NoSQLAppender createAppender(@PluginAttr(value="name") String name, @PluginAttr(value="suppressExceptions") String suppressExceptions, @PluginElement(value="filter") Filter filter, @PluginAttr(value="bufferSize") String bufferSize, @PluginElement(value="noSqlProvider") NoSQLProvider<?> provider) {
        if (provider == null) {
            LOGGER.error("NoSQL provider not specified for appender [{}].", new Object[]{name});
            return null;
        }
        int bufferSizeInt = AbstractAppender.parseInt(bufferSize, 0);
        boolean handleExceptions = !Boolean.parseBoolean(suppressExceptions);
        String managerName = "noSqlManager{ description=" + name + ", bufferSize=" + bufferSizeInt + ", provider=" + provider + " }";
        NoSQLDatabaseManager<?> manager = NoSQLDatabaseManager.getNoSQLDatabaseManager(managerName, bufferSizeInt, provider);
        if (manager == null) {
            return null;
        }
        return new NoSQLAppender(name, filter, handleExceptions, manager);
    }
}

