/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.helpers.Booleans;
import org.apache.logging.log4j.core.helpers.Charsets;
import org.apache.logging.log4j.core.helpers.Integers;
import org.apache.logging.log4j.core.helpers.NetUtils;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.LoggerFields;
import org.apache.logging.log4j.core.net.Facility;
import org.apache.logging.log4j.core.net.Priority;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.core.pattern.ThrowablePatternConverter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StructuredDataId;
import org.apache.logging.log4j.message.StructuredDataMessage;

@Plugin(name="RFC5424Layout", category="Core", elementType="layout", printObject=true)
public final class RFC5424Layout
extends AbstractStringLayout {
    public static final int DEFAULT_ENTERPRISE_NUMBER = 18060;
    public static final String DEFAULT_ID = "Audit";
    public static final Pattern NEWLINE_PATTERN = Pattern.compile("\\r?\\n");
    public static final Pattern PARAM_VALUE_ESCAPE_PATTERN = Pattern.compile("[\\\"\\]\\\\]");
    private static final String DEFAULT_MDCID = "mdc";
    private static final int TWO_DIGITS = 10;
    private static final int THREE_DIGITS = 100;
    private static final int MILLIS_PER_MINUTE = 60000;
    private static final int MINUTES_PER_HOUR = 60;
    private static final String COMPONENT_KEY = "RFC5424-Converter";
    private final Facility facility;
    private final String defaultId;
    private final Integer enterpriseNumber;
    private final boolean includeMDC;
    private final String mdcId;
    private final String localHostName;
    private final String appName;
    private final String messageId;
    private final String configName;
    private final String mdcPrefix;
    private final String eventPrefix;
    private final List<String> mdcExcludes;
    private final List<String> mdcIncludes;
    private final List<String> mdcRequired;
    private final ListChecker checker;
    private final ListChecker noopChecker = new NoopChecker();
    private final boolean includeNewLine;
    private final String escapeNewLine;
    private long lastTimestamp = -1L;
    private String timestamppStr;
    private final List<PatternFormatter> exceptionFormatters;
    private final Map<String, List<PatternFormatter>> fieldFormatters;

    private RFC5424Layout(Configuration config, Facility facility, String id, int ein, boolean includeMDC, boolean includeNL, String escapeNL, String mdcId, String mdcPrefix, String eventPrefix, String appName, String messageId, String excludes, String includes, String required, Charset charset, String exceptionPattern, Map<String, String> loggerFields) {
        super(charset);
        String[] array;
        PatternParser exceptionParser = RFC5424Layout.createPatternParser(config, ThrowablePatternConverter.class);
        this.exceptionFormatters = exceptionPattern == null ? null : exceptionParser.parse(exceptionPattern, false);
        this.facility = facility;
        this.defaultId = id == null ? DEFAULT_ID : id;
        this.enterpriseNumber = ein;
        this.includeMDC = includeMDC;
        this.includeNewLine = includeNL;
        this.escapeNewLine = escapeNL == null ? null : Matcher.quoteReplacement(escapeNL);
        this.mdcId = mdcId;
        this.mdcPrefix = mdcPrefix;
        this.eventPrefix = eventPrefix;
        this.appName = appName;
        this.messageId = messageId;
        this.localHostName = NetUtils.getLocalHostname();
        ListChecker c = null;
        if (excludes != null) {
            array = excludes.split(",");
            if (array.length > 0) {
                c = new ExcludeChecker();
                this.mdcExcludes = new ArrayList<String>(array.length);
                for (String str : array) {
                    this.mdcExcludes.add(str.trim());
                }
            } else {
                this.mdcExcludes = null;
            }
        } else {
            this.mdcExcludes = null;
        }
        if (includes != null) {
            array = includes.split(",");
            if (array.length > 0) {
                c = new IncludeChecker();
                this.mdcIncludes = new ArrayList<String>(array.length);
                for (String str : array) {
                    this.mdcIncludes.add(str.trim());
                }
            } else {
                this.mdcIncludes = null;
            }
        } else {
            this.mdcIncludes = null;
        }
        if (required != null) {
            array = required.split(",");
            if (array.length > 0) {
                this.mdcRequired = new ArrayList<String>(array.length);
                for (String str : array) {
                    this.mdcRequired.add(str.trim());
                }
            } else {
                this.mdcRequired = null;
            }
        } else {
            this.mdcRequired = null;
        }
        this.checker = c != null ? c : this.noopChecker;
        String name = config == null ? null : config.getName();
        String string = this.configName = name != null && name.length() > 0 ? name : null;
        if (loggerFields != null && !loggerFields.isEmpty()) {
            PatternParser fieldParser = RFC5424Layout.createPatternParser(config, null);
            HashMap<String, List<PatternFormatter>> map = new HashMap<String, List<PatternFormatter>>();
            for (Map.Entry<String, String> entry : loggerFields.entrySet()) {
                List<PatternFormatter> formatters = fieldParser.parse(entry.getValue(), false);
                map.put(entry.getKey(), formatters);
            }
            this.fieldFormatters = map;
        } else {
            this.fieldFormatters = null;
        }
    }

    public static PatternParser createPatternParser(Configuration config, Class<? extends PatternConverter> filterClass) {
        if (config == null) {
            return new PatternParser(config, "Converter", LogEventPatternConverter.class, filterClass);
        }
        PatternParser parser = (PatternParser)config.getComponent(COMPONENT_KEY);
        if (parser == null) {
            parser = new PatternParser(config, "Converter", ThrowablePatternConverter.class);
            config.addComponent(COMPONENT_KEY, parser);
            parser = (PatternParser)config.getComponent(COMPONENT_KEY);
        }
        return parser;
    }

    @Override
    public Map<String, String> getContentFormat() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("structured", "true");
        result.put("formatType", "RFC5424");
        return result;
    }

    @Override
    public String toSerializable(LogEvent event) {
        String type;
        Message msg = event.getMessage();
        boolean isStructured = msg instanceof StructuredDataMessage;
        StringBuilder buf = new StringBuilder();
        buf.append("<");
        buf.append(Priority.getPriority(this.facility, event.getLevel()));
        buf.append(">1 ");
        buf.append(this.computeTimeStampString(event.getMillis()));
        buf.append(' ');
        buf.append(this.localHostName);
        buf.append(' ');
        if (this.appName != null) {
            buf.append(this.appName);
        } else if (this.configName != null) {
            buf.append(this.configName);
        } else {
            buf.append("-");
        }
        buf.append(" ");
        buf.append(this.getProcId());
        buf.append(" ");
        String string = type = isStructured ? ((StructuredDataMessage)msg).getType() : null;
        if (type != null) {
            buf.append(type);
        } else if (this.messageId != null) {
            buf.append(this.messageId);
        } else {
            buf.append("-");
        }
        buf.append(" ");
        if (isStructured || this.includeMDC) {
            String text;
            StructuredDataId id = null;
            if (isStructured) {
                StructuredDataMessage data = (StructuredDataMessage)msg;
                Map map = data.getData();
                id = data.getId();
                this.formatStructuredElement(id, this.eventPrefix, map, buf, this.noopChecker);
                text = data.getFormat();
            } else {
                text = msg.getFormattedMessage();
            }
            if (this.includeMDC) {
                Map<String, String> map = event.getContextMap();
                if (this.mdcRequired != null) {
                    this.checkRequired(map);
                }
                int ein = id == null || id.getEnterpriseNumber() < 0 ? this.enterpriseNumber.intValue() : id.getEnterpriseNumber();
                StructuredDataId mdcSDID = new StructuredDataId(this.mdcId, ein, null, null);
                if (this.fieldFormatters != null) {
                    map = new HashMap<String, String>(map);
                    for (Map.Entry<String, List<PatternFormatter>> entry : this.fieldFormatters.entrySet()) {
                        StringBuilder value = new StringBuilder();
                        for (PatternFormatter formatter : entry.getValue()) {
                            formatter.format(event, value);
                        }
                        map.put(entry.getKey(), value.toString());
                    }
                }
                this.formatStructuredElement(mdcSDID, this.mdcPrefix, map, buf, this.checker);
            }
            if (text != null && text.length() > 0) {
                buf.append(" ").append(this.escapeNewlines(text, this.escapeNewLine));
            }
        } else {
            buf.append("- ");
            buf.append(this.escapeNewlines(msg.getFormattedMessage(), this.escapeNewLine));
        }
        if (this.exceptionFormatters != null && event.getThrown() != null) {
            StringBuilder exception = new StringBuilder("\n");
            for (PatternFormatter formatter : this.exceptionFormatters) {
                formatter.format(event, exception);
            }
            buf.append(this.escapeNewlines(exception.toString(), this.escapeNewLine));
        }
        if (this.includeNewLine) {
            buf.append("\n");
        }
        return buf.toString();
    }

    private String escapeNewlines(String text, String escapeNewLine) {
        if (null == escapeNewLine) {
            return text;
        }
        return NEWLINE_PATTERN.matcher(text).replaceAll(escapeNewLine);
    }

    protected String getProcId() {
        return "-";
    }

    protected List<String> getMdcExcludes() {
        return this.mdcExcludes;
    }

    protected List<String> getMdcIncludes() {
        return this.mdcIncludes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String computeTimeStampString(long now) {
        int tzmin;
        long last;
        RFC5424Layout rFC5424Layout = this;
        synchronized (rFC5424Layout) {
            last = this.lastTimestamp;
            if (now == this.lastTimestamp) {
                return this.timestamppStr;
            }
        }
        StringBuilder buf = new StringBuilder();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(now);
        buf.append(Integer.toString(cal.get(1)));
        buf.append("-");
        this.pad(cal.get(2) + 1, 10, buf);
        buf.append("-");
        this.pad(cal.get(5), 10, buf);
        buf.append("T");
        this.pad(cal.get(11), 10, buf);
        buf.append(":");
        this.pad(cal.get(12), 10, buf);
        buf.append(":");
        this.pad(cal.get(13), 10, buf);
        int millis = cal.get(14);
        if (millis != 0) {
            buf.append('.');
            this.pad(millis, 100, buf);
        }
        if ((tzmin = (cal.get(15) + cal.get(16)) / 60000) == 0) {
            buf.append("Z");
        } else {
            if (tzmin < 0) {
                tzmin = -tzmin;
                buf.append("-");
            } else {
                buf.append("+");
            }
            int tzhour = tzmin / 60;
            this.pad(tzhour, 10, buf);
            buf.append(":");
            this.pad(tzmin -= tzhour * 60, 10, buf);
        }
        RFC5424Layout rFC5424Layout2 = this;
        synchronized (rFC5424Layout2) {
            if (last == this.lastTimestamp) {
                this.lastTimestamp = now;
                this.timestamppStr = buf.toString();
            }
        }
        return buf.toString();
    }

    private void pad(int val, int max, StringBuilder buf) {
        while (max > 1) {
            if (val < max) {
                buf.append("0");
            }
            max /= 10;
        }
        buf.append(Integer.toString(val));
    }

    private void formatStructuredElement(StructuredDataId id, String prefix, Map<String, String> data, StringBuilder sb, ListChecker checker) {
        if (id == null && this.defaultId == null) {
            return;
        }
        sb.append("[");
        sb.append(this.getId(id));
        this.appendMap(prefix, data, sb, checker);
        sb.append("]");
    }

    private String getId(StructuredDataId id) {
        int ein;
        StringBuilder sb = new StringBuilder();
        if (id == null || id.getName() == null) {
            sb.append(this.defaultId);
        } else {
            sb.append(id.getName());
        }
        int n = ein = id != null ? id.getEnterpriseNumber() : this.enterpriseNumber.intValue();
        if (ein < 0) {
            ein = this.enterpriseNumber;
        }
        if (ein >= 0) {
            sb.append("@").append(ein);
        }
        return sb.toString();
    }

    private void checkRequired(Map<String, String> map) {
        for (String key : this.mdcRequired) {
            String value = map.get(key);
            if (value != null) continue;
            throw new LoggingException("Required key " + key + " is missing from the " + this.mdcId);
        }
    }

    private void appendMap(String prefix, Map<String, String> map, StringBuilder sb, ListChecker checker) {
        TreeMap<String, String> sorted = new TreeMap<String, String>(map);
        for (Map.Entry entry : sorted.entrySet()) {
            if (!checker.check((String)entry.getKey()) || entry.getValue() == null) continue;
            sb.append(" ");
            if (prefix != null) {
                sb.append(prefix);
            }
            sb.append(this.escapeNewlines(this.escapeSDParams((String)entry.getKey()), this.escapeNewLine)).append("=\"").append(this.escapeNewlines(this.escapeSDParams((String)entry.getValue()), this.escapeNewLine)).append("\"");
        }
    }

    private String escapeSDParams(String value) {
        return PARAM_VALUE_ESCAPE_PATTERN.matcher(value).replaceAll("\\\\$0");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("facility=").append(this.facility.name());
        sb.append(" appName=").append(this.appName);
        sb.append(" defaultId=").append(this.defaultId);
        sb.append(" enterpriseNumber=").append(this.enterpriseNumber);
        sb.append(" newLine=").append(this.includeNewLine);
        sb.append(" includeMDC=").append(this.includeMDC);
        sb.append(" messageId=").append(this.messageId);
        return sb.toString();
    }

    @PluginFactory
    public static RFC5424Layout createLayout(@PluginAttr(value="facility") String facility, @PluginAttr(value="id") String id, @PluginAttr(value="enterpriseNumber") String ein, @PluginAttr(value="includeMDC") String includeMDC, @PluginAttr(value="mdcId") String mdcId, @PluginAttr(value="mdcPrefix") String mdcPrefix, @PluginAttr(value="eventPrefix") String eventPrefix, @PluginAttr(value="newLine") String includeNL, @PluginAttr(value="newLineEscape") String escapeNL, @PluginAttr(value="appName") String appName, @PluginAttr(value="messageId") String msgId, @PluginAttr(value="mdcExcludes") String excludes, @PluginAttr(value="mdcIncludes") String includes, @PluginAttr(value="mdcRequired") String required, @PluginAttr(value="exceptionPattern") String exceptionPattern, @PluginElement(value="loggerFields") LoggerFields loggerFields, @PluginConfiguration Configuration config) {
        Map<String, String> loggerFieldValues;
        Charset charset = Charsets.UTF_8;
        if (includes != null && excludes != null) {
            LOGGER.error("mdcIncludes and mdcExcludes are mutually exclusive. Includes wil be ignored");
            includes = null;
        }
        Facility f = Facility.toFacility(facility, Facility.LOCAL0);
        int enterpriseNumber = Integers.parseInt(ein, 18060);
        boolean isMdc = Booleans.parseBoolean(includeMDC, true);
        boolean includeNewLine = Boolean.parseBoolean(includeNL);
        Map<String, String> map = loggerFieldValues = loggerFields == null ? null : loggerFields.getMap();
        if (mdcId == null) {
            mdcId = DEFAULT_MDCID;
        }
        return new RFC5424Layout(config, f, id, enterpriseNumber, isMdc, includeNewLine, escapeNL, mdcId, mdcPrefix, eventPrefix, appName, msgId, excludes, includes, required, charset, exceptionPattern, loggerFieldValues);
    }

    private class NoopChecker
    implements ListChecker {
        private NoopChecker() {
        }

        @Override
        public boolean check(String key) {
            return true;
        }
    }

    private class ExcludeChecker
    implements ListChecker {
        private ExcludeChecker() {
        }

        @Override
        public boolean check(String key) {
            return !RFC5424Layout.this.mdcExcludes.contains(key);
        }
    }

    private class IncludeChecker
    implements ListChecker {
        private IncludeChecker() {
        }

        @Override
        public boolean check(String key) {
            return RFC5424Layout.this.mdcIncludes.contains(key);
        }
    }

    private static interface ListChecker {
        public boolean check(String var1);
    }
}

