package org.apache.camel.itest.eap.utils;

import java.io.File;

import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public final class DeploymentBuilder {

    private static final String EAP_MODULES_PROPERTY = "eap.modules.library";

    public static WebArchive baseDeployment() {
        WebArchive war = ShrinkWrap.create(WebArchive.class, "test.war");
        if (System.getProperty(EAP_MODULES_PROPERTY) != null) {
            war = addEapModulesResources(war);
        } else {
            war = addEapLibraryResources(war);
            war = addEapHotRodResources(war);
        }
        return war;
    }

    public static WebArchive addEapLibraryResources(WebArchive war) {
        war.addAsLibraries(
                new File("target/test-libs/infinispan-embedded.jar"),
                new File("target/test-libs/infinispan-core-tests.jar"),
                new File("target/test-libs/camel-jbossdatagrid.jar"),
                new File("target/test-libs/camel-jbossdatagrid-tests.jar"),
                new File("target/test-libs/camel-test.jar"),
                new File("target/test-libs/camel-core.jar")
                );
        return war;
    }

    public static WebArchive addEapHotRodResources(WebArchive war) {
        war.addAsLibraries(
              new File("target/test-libs/infinispan-remote.jar"));
        return war;
    }

    public static WebArchive addEapModulesResources(WebArchive war) {
        war.addAsLibraries(
                new File("target/test-libs/camel-jbossdatagrid.jar"),
                new File("target/test-libs/camel-jbossdatagrid-tests.jar"),
                new File("target/test-libs/camel-core.jar"),
                new File("target/test-libs/camel-test.jar"),
                new File("target/test-libs/infinispan-core-tests.jar"),
                new File("target/test-libs/infinispan-server-testsuite-tests.jar") //contains custom event class for HR client
        );
        war.addAsWebInfResource(new File("target/test-classes/jboss-deployment-structure.xml"));
        return war;
    }
}
