package org.infinispan.cdi.test.interceptor.service;

import javax.cache.annotation.GeneratedCacheKey;

/**
 * @author Kevin Pollet <kevin.pollet@serli.com> (C) 2011 SERLI
 * @author Galder Zamarreño
 */
public class CustomCacheKey implements GeneratedCacheKey {

   private static final long serialVersionUID = -2393683631229917970L;

   private final String param1;
   private final String param2;

   public CustomCacheKey(String param1, String param2) {
      this.param1 = param1;
      this.param2 = param2;
   }

   @Override
   public boolean equals(Object o) {
      if (this == o) return true;
      if (o == null || getClass() != o.getClass()) return false;

      CustomCacheKey that = (CustomCacheKey) o;

      if (!param1.equals(that.param1)) return false;
      if (!param2.equals(that.param2)) return false;

      return true;
   }

   @Override
   public int hashCode() {
      int result = param1.hashCode();
      result = 31 * result + param2.hashCode();
      return result;
   }
}
