/*
 * Decompiled with CFR 0.152.
 */
package jdiff;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Javadoc;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.Path;

public class JDiffAntTask {
    private Project project;
    static String DIR_SEP = System.getProperty("file.separator");
    private String jdiffHome = "(not set)";
    private String jdiffClassPath = "(not set)";
    private File destdir = new File("jdiff_report");
    private boolean verbose = false;
    private boolean verboseAnt = false;
    private boolean docchanges = false;
    private boolean stats = false;
    private String source = "1.5";
    private ProjectInfo oldProject = null;
    private ProjectInfo newProject = null;

    public void execute() throws BuildException {
        this.jdiffHome = this.project.getProperty("JDIFF_HOME");
        if (this.jdiffHome == null || this.jdiffHome.compareTo("") == 0 | this.jdiffHome.compareTo("(not set)") == 0) {
            throw new BuildException("Error: invalid JDIFF_HOME property. Set it in the build file to the directory where jdiff is installed");
        }
        this.project.log(" JDiff home: " + this.jdiffHome, 2);
        this.jdiffClassPath = this.jdiffHome + DIR_SEP + "jdiff.jar" + System.getProperty("path.separator") + this.jdiffHome + DIR_SEP + "xerces.jar";
        if (!this.destdir.mkdir() && !this.destdir.exists()) {
            throw new BuildException(this.getDestdir() + " is not a valid directory");
        }
        this.project.log(" Report location: " + this.getDestdir() + DIR_SEP + "changes.html", 2);
        if (this.oldProject == null || this.newProject == null) {
            throw new BuildException("Error: two projects are needed, one <old> and one <new>");
        }
        this.generateJavadoc(this.oldProject);
        this.generateJavadoc(this.newProject);
        this.generateXML(this.oldProject);
        this.generateXML(this.newProject);
        this.compareXML(this.oldProject.getName(), this.newProject.getName());
        this.project.log(" Report location: " + this.getDestdir() + DIR_SEP + "changes.html", 2);
    }

    protected void generateXML(ProjectInfo proj) {
        String apiname = proj.getName();
        Javadoc jd = this.initJavadoc("Analyzing " + apiname);
        jd.setDestdir(this.getDestdir());
        this.addSourcePaths(jd, proj);
        jd.setPackagenames(this.getPackageList(proj));
        Javadoc.DocletInfo dInfo = jd.createDoclet();
        jd.setDoclet("jdiff.JDiff");
        jd.setDocletPath(new Path(this.project, this.jdiffClassPath));
        Javadoc.DocletParam dp1 = dInfo.createParam();
        dp1.setName("-apiname");
        dp1.setValue(apiname);
        Javadoc.DocletParam dp2 = dInfo.createParam();
        dp2.setName("-baseURI");
        dp2.setValue("http://www.w3.org");
        Javadoc.DocletParam dp3 = dInfo.createParam();
        dp3.setName("-apidir");
        dp3.setValue(this.getDestdir().toString());
        jd.perform();
    }

    protected void compareXML(String oldapiname, String newapiname) {
        Javadoc jd = this.initJavadoc("Comparing versions");
        jd.setDestdir(this.getDestdir());
        jd.setPrivate(true);
        jd.setSourcefiles(this.jdiffHome + DIR_SEP + "Null.java");
        Javadoc.DocletInfo dInfo = jd.createDoclet();
        jd.setDoclet("jdiff.JDiff");
        jd.setDocletPath(new Path(this.project, this.jdiffClassPath));
        Javadoc.DocletParam dp1 = dInfo.createParam();
        dp1.setName("-oldapi");
        dp1.setValue(oldapiname);
        Javadoc.DocletParam dp2 = dInfo.createParam();
        dp2.setName("-newapi");
        dp2.setValue(newapiname);
        Javadoc.DocletParam dp3 = dInfo.createParam();
        dp3.setName("-oldapidir");
        dp3.setValue(this.getDestdir().toString());
        Javadoc.DocletParam dp4 = dInfo.createParam();
        dp4.setName("-newapidir");
        dp4.setValue(this.getDestdir().toString());
        Javadoc.DocletParam dp5 = dInfo.createParam();
        dp5.setName("-javadocold");
        dp5.setValue(".." + DIR_SEP + oldapiname + DIR_SEP);
        Javadoc.DocletParam dp6 = dInfo.createParam();
        dp6.setName("-javadocnew");
        dp6.setValue(".." + DIR_SEP + newapiname + DIR_SEP);
        if (this.getStats()) {
            dInfo.createParam().setName("-stats");
            this.copyFile(this.jdiffHome + DIR_SEP + "black.gif", this.getDestdir().toString() + DIR_SEP + "black.gif");
            this.copyFile(this.jdiffHome + DIR_SEP + "background.gif", this.getDestdir().toString() + DIR_SEP + "background.gif");
        }
        if (this.getDocchanges()) {
            dInfo.createParam().setName("-docchanges");
        }
        jd.perform();
    }

    protected void generateJavadoc(ProjectInfo proj) {
        String javadoc = proj.getJavadoc();
        if (javadoc != null && javadoc.compareTo("generated") != 0) {
            this.project.log("Configured to use existing Javadoc located in " + javadoc, 2);
            return;
        }
        String apiname = proj.getName();
        Javadoc jd = this.initJavadoc("Javadoc for " + apiname);
        jd.setDestdir(new File(this.getDestdir().toString() + DIR_SEP + apiname));
        this.addSourcePaths(jd, proj);
        jd.setPrivate(true);
        jd.setPackagenames(this.getPackageList(proj));
        jd.perform();
    }

    protected Javadoc initJavadoc(String logMsg) {
        Javadoc jd = new Javadoc();
        jd.setProject(this.project);
        jd.setTaskName(logMsg);
        jd.setSource(this.getSource());
        jd.init();
        if (this.verboseAnt) {
            jd.setVerbose(true);
        }
        return jd;
    }

    protected void addSourcePaths(Javadoc jd, ProjectInfo proj) {
        Vector dirSets = proj.getDirsets();
        int numDirSets = dirSets.size();
        for (int i = 0; i < numDirSets; ++i) {
            DirSet dirSet = (DirSet)dirSets.elementAt(i);
            jd.setSourcepath(new Path(this.project, dirSet.getDir(this.project).toString()));
        }
    }

    protected String getPackageList(ProjectInfo proj) throws BuildException {
        String packageList = "";
        StringBuffer sb = new StringBuffer();
        Vector dirSets = proj.getDirsets();
        int numDirSets = dirSets.size();
        boolean addComma = false;
        for (int i = 0; i < numDirSets; ++i) {
            DirSet dirSet = (DirSet)dirSets.elementAt(i);
            DirectoryScanner dirScanner = dirSet.getDirectoryScanner(this.project);
            String[] files = dirScanner.getIncludedDirectories();
            for (int j = 0; j < files.length; ++j) {
                if (!addComma) {
                    addComma = true;
                } else {
                    sb.append(",");
                }
                sb.append(files[j]);
            }
        }
        packageList = sb.toString();
        if (packageList.compareTo("") == 0) {
            throw new BuildException("Error: no packages found to scan");
        }
        this.project.log(" Package list: " + packageList, 2);
        return packageList;
    }

    protected void copyFile(String src, String dst) {
        File srcFile = new File(src);
        File dstFile = new File(dst);
        try {
            int len;
            File reportSubdir = new File(this.getDestdir().toString() + DIR_SEP + "changes");
            if (!reportSubdir.mkdir() && !reportSubdir.exists()) {
                this.project.log("Warning: unable to create " + reportSubdir, 1);
            }
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (FileNotFoundException fnfe) {
            this.project.log("Warning: unable to copy " + src.toString() + " to " + dst.toString(), 1);
        }
        catch (IOException ioe) {
            this.project.log("Warning: unable to copy " + src.toString() + " to " + dst.toString(), 1);
        }
    }

    public void setProject(Project proj) {
        this.project = proj;
    }

    public void setDestdir(File value) {
        this.destdir = value;
    }

    public File getDestdir() {
        return this.destdir;
    }

    public void setVerbose(boolean value) {
        this.verbose = value;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setDocchanges(boolean value) {
        this.docchanges = value;
    }

    public boolean getDocchanges() {
        return this.docchanges;
    }

    public void setStats(boolean value) {
        this.stats = value;
    }

    public boolean getStats() {
        return this.stats;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public void addConfiguredOld(ProjectInfo projInfo) {
        this.oldProject = projInfo;
    }

    public void addConfiguredNew(ProjectInfo projInfo) {
        this.newProject = projInfo;
    }

    public static class ProjectInfo {
        private String name;
        private String javadoc;
        private Vector dirsets = new Vector();

        public void setName(String value) {
            this.name = value;
        }

        public String getName() {
            return this.name;
        }

        public void setJavadoc(String value) {
            this.javadoc = value;
        }

        public String getJavadoc() {
            return this.javadoc;
        }

        public void setDirset(DirSet value) {
            this.dirsets.add(value);
        }

        public Vector getDirsets() {
            return this.dirsets;
        }

        public void addDirset(DirSet aDirset) {
            this.setDirset(aDirset);
        }
    }
}

