package org.infinispan.cdi.event.cache;

import org.infinispan.Cache;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryEvicted;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvictedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryExpiredEvent;
import org.infinispan.transaction.xa.GlobalTransaction;

import javax.enterprise.event.Event;
import javax.enterprise.util.TypeLiteral;

/**
 * Event bridge for {@link org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted}.
 *
 * @author Pete Muir
 * @see org.infinispan.notifications.Listener
 * @see org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired
 */
@Listener
public class CacheEntryExpiredAdapter<K, V> extends AbstractAdapter<CacheEntryExpiredEvent<K, V>> {

   public static final CacheEntryExpiredEvent<?, ?> EMPTY = new CacheEntryExpiredEvent<Object, Object>() {

      @Override
      public Type getType() {
         return null;
      }

      @Override
      public Object getKey() {
         return null;
      }

      @Override
      public GlobalTransaction getGlobalTransaction() {
         return null;
      }

      @Override
      public boolean isOriginLocal() {
         return false;
      }

      @Override
      public boolean isPre() {
         return false;
      }

      @Override
      public Cache<Object, Object> getCache() {
         return null;
      }

      @Override
      public Object getValue() {
         return null;
      }

      @Override
      public Metadata getMetadata() {
         return null;
      }
   };

   @SuppressWarnings("serial")
   public static final TypeLiteral<CacheEntryExpiredEvent<?, ?>> WILDCARD_TYPE = new TypeLiteral<CacheEntryExpiredEvent<?, ?>>() {
   };

   public CacheEntryExpiredAdapter(Event<CacheEntryExpiredEvent<K, V>> event) {
      super(event);
   }

   @Override
   @CacheEntryExpired
   public void fire(CacheEntryExpiredEvent<K, V> payload) {
      super.fire(payload);
   }
}
