package org.infinispan.cdi.test.interceptor.service;

import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheKeyInvocationContext;
import javax.cache.annotation.GeneratedCacheKey;
import java.lang.annotation.Annotation;

/**
 * @author Kevin Pollet <kevin.pollet@serli.com> (C) 2011 SERLI
 */
public class CustomCacheKeyGenerator implements CacheKeyGenerator {

   @Override
   public GeneratedCacheKey generateCacheKey(CacheKeyInvocationContext<? extends Annotation> cacheKeyInvocationContext) {
      String param1 = null;
      String param2 = null;

      String methodName = cacheKeyInvocationContext.getMethod().getName();
      if (methodName.equals("removeEntryWithCacheKeyGenerator")) {
         param1 = "remove";
         param2 = (String) cacheKeyInvocationContext.getAllParameters()[0].getValue();
      } else if (methodName.equals("cacheResultWithCacheKeyGenerator")) {
         param1 = "result";
         param2 = (String) cacheKeyInvocationContext.getAllParameters()[0].getValue();
      } else if (methodName.equals("putWithCacheKeyGenerator")) {
         param1 = "put";
         param2 = (String) cacheKeyInvocationContext.getAllParameters()[1].getValue();
      }
      return new CustomCacheKey(param1, param2);
   }

}
