package org.infinispan.client.hotrod.impl.iteration;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.query.testdomain.protobuf.AccountPB;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.AccountHS;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map.Entry;
import java.util.Set;

import static org.testng.Assert.assertTrue;
import static org.testng.Assert.fail;

/**
 * @author gfernandes
 * @since 8.0
 */
@SuppressWarnings("unchecked")
public class RemoteIteratorTestUtils {

   public static <T> Set<T> setOf(T... values) {
      HashSet<T> set = new HashSet<T>();
      Collections.addAll(set, values);
      return set;
   }

   public static Set<Integer> range(int minInclusive, int maxExclusive) {
      HashSet<Integer> set = new HashSet<Integer>();
      for (int i = minInclusive; i < maxExclusive; i++) {
         set.add(i);
      }
      return set;
   }

   public static <T> void populateCache(int numElements, Function<Integer, T> function, RemoteCache<Integer, T> remoteCache) {
      for (Integer element : range(0, numElements)) {
         remoteCache.put(element, function.apply(element));
      }
   }

   public static <T> void assertForAll(Set<T> elements, Condition<? super T> condition) {
      for (T element : elements) {
         if (!condition.test(element)) fail();
      }
   }

   public static AccountHS newAccount(int id) {
      AccountHS account = new AccountHS();
      account.setId(id);
      account.setDescription("description for " + id);
      account.setCreationDate(new Date());
      return account;
   }

   public static AccountPB newAccountPB(int id) {
      AccountPB account = new AccountPB();
      account.setId(id);
      account.setDescription("description for " + id);
      account.setCreationDate(new Date());
      return account;
   }

   public static <K> Set<K> extractKeys(Collection<Entry<Object, Object>> entries) {
      Set<K> keys = new HashSet<K>();
      for (Entry<Object, Object> entry : entries) {
         keys.add((K) entry.getKey());
      }
      return keys;
   }

   public static <V> Set<V> extractValues(Collection<Entry<Object, Object>> entries) {
      Set<V> values = new HashSet<V>();
      for (Entry<Object, Object> entry : entries) {
         values.add((V) entry.getValue());
      }
      return values;
   }

   public static byte[] toByteBuffer(Object key, Marshaller marshaller) {
      try {
         return marshaller.objectToByteBuffer(key);
      } catch (Exception ignored) {
      }
      return null;
   }

   public static void assertKeysInSegment(Set<Entry<Object, Object>> entries, Set<Integer> segments,
                                   Marshaller marshaller, Function<byte[], Integer> segmentCalculator) {
      for (Entry<Object, Object> e : entries) {
         Integer key = (Integer) e.getKey();
         int segment = segmentCalculator.apply(toByteBuffer(key, marshaller));
         assertTrue(segments.contains(segment));

      }
   }

}

interface Function<T, U> {
   U apply(T t);
}

interface Condition<T> {
   boolean test(T t);
}
