package org.infinispan.persistence.migrator.jdbc;

import static org.testng.AssertJUnit.assertEquals;

import java.util.Properties;

import org.infinispan.commons.util.StringPropertyReplacer;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups="functional", testName="persistence.migrator.jdbc.JdbcUpgradeToolTest")
public class JdbcUpgradeToolTest {
   @BeforeClass
   public void setup() {
      String buildDirectory = System.getProperty("build.directory");
      String testDbDir = buildDirectory != null ? buildDirectory + "/../test-writer/target/jdbc-migrator52x" : System.getProperty("java.io.tmpdir") + "/jdbc-migrator52x";
      System.setProperty("test.dbdir", testDbDir);
      System.out.println("Using databases from " + testDbDir);
   }
   
   public void testMixedUpgrade() throws Exception {
      testJdbcUpgrade("/jdbcmixed.properties", 125);
   }

   public void testStringUpgrade() throws Exception {
      testJdbcUpgrade("/jdbcstring.properties", 26);
   }
   
   public void testBinaryUpgrade() throws Exception {
      testJdbcUpgrade("/jdbcbinary.properties", 100);
   }
   
   private void testJdbcUpgrade(String propertyFileName, long expectedEntryCount) throws Exception {
      Properties props = new Properties();
      props.load(this.getClass().getResourceAsStream(propertyFileName));
      for(String key : props.stringPropertyNames()) {
         String value = props.getProperty(key);
         props.put(key, StringPropertyReplacer.replaceProperties(value));
      }
      JdbcUpgradeTool upgrader = new JdbcUpgradeTool(props);
      long migrated = upgrader.run();
      assertEquals(expectedEntryCount, migrated);
   }
}
