package org.infinispan.cache.impl;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DefaultDataContainer;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.jmx.annotations.DisplayType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.Units;

/**
 * CacheConfigurationMBeanImpl.
 *
 * @author Tristan Tarrant
 * @since 8.1
 */
@MBean(objectName = "Configuration", description = "Runtime cache configuration attributes")
public class CacheConfigurationMBean {

   private Cache<?, ?> cache;
   private Configuration configuration;

   @Inject
   public void injectDependencies(Cache<?, ?> cache, Configuration configuration) {
      this.cache = cache;
      this.configuration = configuration;
   }

   @ManagedAttribute(description = "Gets the eviction size for the cache",
         displayName = "Gets the eviction size for the cache",
         units = Units.NONE,
         displayType = DisplayType.DETAIL, writable = true)
   public int getEvictionSize() {
      return configuration.eviction().maxEntries();
   }

   public void setEvictionSize(int newSize) {
      DefaultDataContainer dataContainer = (DefaultDataContainer) cache.getAdvancedCache().getDataContainer();
      dataContainer.resize(newSize);
      configuration.eviction().maxEntries(newSize);
   }
}
