package org.infinispan.configuration.global;

/**
 *
 * GlobalStateConfiguration.
 *
 * @author Tristan Tarrant
 * @since 8.1
 */
public class GlobalStateConfiguration {

   private final boolean enabled;
   private final String persistentLocation;

   GlobalStateConfiguration(boolean enabled, String persistentLocation) {
      this.enabled = enabled;
      this.persistentLocation = persistentLocation;
   }

   public boolean enabled() {
      return enabled;
   }

   /**
    * Returns the filesystem path where persistent state data which needs to survive container
    * restarts should be stored. Defaults to the user.dir system property which usually is where the
    * application was started.
    */
   public String persistentLocation() {
      return persistentLocation;  //todo [anistor] use SecurityActions.getSystemProperty("user.dir") as default
   }

   @Override
   public String toString() {
      return "GlobalStateConfiguration [" +
            "enabled=" + enabled +
            ", persistentLocation='" + persistentLocation + '\'' +
            ']';
   }
}
