package org.infinispan.eviction;

import java.util.Map;

import net.jcip.annotations.ThreadSafe;

import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;

/**
 * Central component that deals with eviction of cache entries.
 * <p />
 * Typically, {@link #processEviction()} is called periodically by the eviction thread (which can be configured using
 * {@link org.infinispan.config.FluentConfiguration.ExpirationConfig#wakeUpInterval(Long)} and {@link org.infinispan.config.GlobalConfiguration#setEvictionScheduledExecutorFactoryClass(String)}).
 * <p />
 * If the eviction thread is disabled - by setting {@link org.infinispan.config.FluentConfiguration.ExpirationConfig#wakeUpInterval(Long)} to <tt>0</tt> -
 * then this method could be called directly, perhaps by any other maintenance thread that runs periodically in the application.
 * <p />
 * Note that this method is a no-op if the eviction strategy configured is {@link org.infinispan.eviction.EvictionStrategy#NONE}.
 * <p />
 * @author Manik Surtani
 * @since 4.0
 * @private
 */
@ThreadSafe
@Scope(Scopes.NAMED_CACHE)
public interface EvictionManager {

   /**
    * @deprecated This falls back to calling {@link ExpirationManager#processExpiration()}
    * @see ExpirationManager
    */
   void processEviction();

   /**
    * @deprecated This falls back to calling {@link ExpirationManager#isEnabled()}
    * @see ExpirationManager
    * @return whether expiration is enabled or not
    */
   boolean isEnabled();

   void onEntryEviction(Map<Object, InternalCacheEntry> evicted);
}
