package org.infinispan.all.embeddedquery.testdomain;

import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.exception.ErrorContext;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.infinispan.Cache;
import org.infinispan.factories.ComponentRegistry;
import org.junit.Assert;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.atomic.AtomicReference;

public class StaticTestingErrorHandler implements ErrorHandler {

   private final AtomicReference faulty = new AtomicReference();

   @Override
   public void handle(ErrorContext context) {
      faulty.compareAndSet(null, new ThrowableWrapper(context.getOperationAtFault().toString(), context.getThrowable()));
   }

   @Override
   public void handleException(String errorMsg, Throwable exception) {
      faulty.compareAndSet(null, new ThrowableWrapper(errorMsg, exception));
   }

   private Object getAndReset() {
      return faulty.getAndSet(null);
   }

   public static void assertAllGood(Cache cache) {
      ComponentRegistry cr = cache.getAdvancedCache().getComponentRegistry();
      SearchFactoryImplementor searchFactoryIntegrator = (SearchFactoryImplementor) cr.getComponent(SearchFactoryIntegrator.class);
      ErrorHandler errorHandler = searchFactoryIntegrator.getErrorHandler();
      Assert.assertNotNull(errorHandler);
      Assert.assertTrue(errorHandler instanceof StaticTestingErrorHandler);
      StaticTestingErrorHandler instance = (StaticTestingErrorHandler) errorHandler;
      Object fault = instance.getAndReset();
      if (fault!=null) {
         Assert.fail(fault.toString());
      }
   }

   public static void assertAllGood(Cache... caches) {
      for (Cache cache : caches) {
         assertAllGood(cache);
      }
   }

   public static class ThrowableWrapper {

      private final String errorMsg;
      private final Throwable exception;

      public ThrowableWrapper(String errorMsg, Throwable exception) {
         this.errorMsg = errorMsg;
         this.exception = exception;
      }

      @Override
      public String toString() {
         StringWriter w = new StringWriter();
         w.append(String.valueOf(errorMsg));
         if (exception != null) {
            w.append(' ');
            exception.printStackTrace(new PrintWriter(w));
         }
         return w.toString();
      }

   }

}
