/*
 * Copyright 2015 Red Hat, Inc..
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.infinispan.blueprint;

import java.io.IOException;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.sampledomain.marshallers.GenderMarshaller;
import org.infinispan.protostream.sampledomain.marshallers.UserMarshaller;
import org.infinispan.query.remote.client.MarshallerRegistration;
import org.infinispan.query.remote.client.ProtobufMetadataManagerConstants;

/**
 * @author mgencur
 */
public class RemoteCacheManagerFactory {
    
    private final ConfigurationBuilder clientBuilder;
    
    public RemoteCacheManagerFactory(String hostname, int port) {
        clientBuilder = new ConfigurationBuilder().addServer()
                .host(hostname).port(port)
                .marshaller(new ProtoStreamMarshaller());
    }
    
    public RemoteCacheManager newRemoteCacheManager() throws IOException {
        RemoteCacheManager manager = new RemoteCacheManager(clientBuilder.build());

        RemoteCache<String, String> metadataCache = manager
                .getCache(ProtobufMetadataManagerConstants.PROTOBUF_METADATA_CACHE_NAME);
        metadataCache
                .put("sample_bank_account/bank.proto",
                        Util.read(InfinispanRemoteQueryProducerBlueprintIT.class
                                .getResourceAsStream("/sample_bank_account/bank.proto")));
        MarshallerRegistration.registerMarshallers(ProtoStreamMarshaller
                .getSerializationContext(manager));

        SerializationContext serCtx = ProtoStreamMarshaller
                .getSerializationContext(manager);
        serCtx.registerProtoFiles(FileDescriptorSource
                .fromResources("/sample_bank_account/bank.proto"));
        serCtx.registerMarshaller(new UserMarshaller());
        serCtx.registerMarshaller(new GenderMarshaller());
        
        return manager;
    }
}
