import org.ovirt.engine.ui.sdk.ext.colors as ColorsConverter

import datetime
import re
import time
import sys
sys.path.append('..')
#############################################################################
logFile = "RedHat.RhevM.SDK_" + str(datetime.date.today()) + ".log"
#############################################################################
def writeLog(line, log_file='', color=''):

    line = time.strftime("%d/%m/%Y %H:%M:%S") + ' | ' + line
    
    old_line = line
    if color != '':
        line = ColorsConverter.set_color(line, color)
    elif (re.search("error", line, re.IGNORECASE)):
        line = ColorsConverter.set_color(line, 'red')
    elif (re.search("warning", line, re.IGNORECASE)):
        line = ColorsConverter.set_color(line, 'cyan')
    print line

    line = old_line
    if(log_file != ''):
        try:
            log_fp = open(log_file, 'a+')
            line = '\n' + line
            log_fp.write(line)
            log_fp.close()
        except:
            print "ERROR: error writing to file '" + log_file + "'!"
            return False

    return True
#############################################################################
def writeInfo(text):
    writeLog("[INFO]::" + text, logFile, "white")
#############################################################################
def writeError(text):
    writeLog("[ERROR]::" + text, logFile, "red")
#############################################################################
def writeWarning(text):
    writeLog("[WARNING]::" + text, logFile, "cyan")
#############################################################################
