﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using System.Text;


namespace VdcCommon.BusinessEntities
{
	public partial class GetAllServerCpuListParameters : VdcQueryParametersBase
	{
        public GetAllServerCpuListParameters() { }
		public GetAllServerCpuListParameters(Version version)
		{
			this.Version = version;
		}
	}

	
	public partial class GetAvailableClustersByServerCpuParameters : GetAllServerCpuListParameters
	{
        public GetAvailableClustersByServerCpuParameters() { }
		public GetAvailableClustersByServerCpuParameters(string cpuName, Version version)
			: base(version)
		{
			CpuName = cpuName;
		}
	}

    
    public partial class RegisterQueryParameters : VdcQueryParametersBase
    {
        public RegisterQueryParameters() { }

        public RegisterQueryParameters(Guid queryID, VdcQueryType queryType, VdcQueryParametersBase queryParams)
        {
            QueryID = queryID;
            QueryType = queryType;
            QueryParams = queryParams;
        }

        public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
            return RegisterableQueryReturnDataType.UNDEFINED;
        }
    }

    
    public partial class UnregisterQueryParameters : VdcQueryParametersBase
    {
        public UnregisterQueryParameters() { }

        public UnregisterQueryParameters(Guid queryID)
        {
            QueryID = queryID;
        }

        public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
            return RegisterableQueryReturnDataType.UNDEFINED;
        }
    }

    
    public partial class GetSystemStatisticsQueryParameters : VdcQueryParametersBase
    {
        //public int Max { get; protected set; }
        public GetSystemStatisticsQueryParameters() { }

        public GetSystemStatisticsQueryParameters(int max)
        {
            Max = max;
        }

        public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
            return RegisterableQueryReturnDataType.UNDEFINED;
        }
    }
}
