using VdcCommon.BusinessEntities;

namespace SearchBackend
{
    class StoragePoolFieldAutoCompleter : BaseConditionFieldAutoCompleter
    {
        public StoragePoolFieldAutoCompleter()
        {
            //Building the basic vervs Dict
            mVerbs.Add("NAME", "NAME");
            mVerbs.Add("DESCRIPTION", "DESCRIPTION");
            mVerbs.Add("TYPE","TYPE");
            mVerbs.Add("STATUS","STATUS");
            
            //Building the autoCompletion Dict
            buildCompletions();
            //Building the types dict
            TypeDictionary.Add("NAME", typeof(string));
            TypeDictionary.Add("DESCRIPTION", typeof(string));
            TypeDictionary.Add("TYPE", typeof(StorageType));
            TypeDictionary.Add("STATUS",typeof(StoragePoolStatus));
            
            //building the ColumnName Dict
            mColumnNameDict.Add("NAME", "name");
            mColumnNameDict.Add("DESCRIPTION", "description");
            mColumnNameDict.Add("TYPE", "storage_pool_type");
            mColumnNameDict.Add("STATUS","status");
            
            //Building the validation dict
            buildBasicValidationTable();
        }

        public override IAutoCompleter getFieldRelationshipAutoCompleter(string fieldName)
        {
			 IAutoCompleter retval;
			 switch (fieldName)
			 {
				 default:
					 retval = new StringConditionRelationAutoCompleter();
					 break;
			 }
            
            return retval;
        }

        public override IConditionValueAutoCompleter getFieldValueAutoCompleter(string fieldName)
        {
            IConditionValueAutoCompleter retval = null;
            switch (fieldName)
            {
                case "STATUS":
                    retval = new EnumValueAutoCompleter(typeof(StoragePoolStatus));
                    break;
                case "TYPE":
                    retval = new EnumValueAutoCompleter(typeof(StorageType));
                    break;
                default:
                    break;
            }
            return retval;
        }

    }
    
}
