using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.ComponentModel;
using org.ovirt.engine.ui.uicompat;
using VdcCommon.BusinessEntities;
using VdcFrontend;
using VdcCommon.Interfaces;

namespace org.ovirt.engine.ui.uicommon.models.vms
{
	public class VmGeneralModel : EntityModel
	{
		#region Events

		public static EventDefinition UpdateCompleteEventDefinition;
		public Event UpdateCompleteEvent { get; private set; }

		#endregion

		#region Properties

		private string name;
		public string Name
		{
			get { return name; }
			set
			{
				if (name != value)
				{
					name = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Name"));
				}
			}
		}

		private string description;
		public string Description
		{
			get { return description; }
			set
			{
				if (description != value)
				{
					description = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Description"));
				}
			}
		}

		private string template;
		public string Template
		{
			get { return template; }
			set
			{
				if (template != value)
				{
					template = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Template"));
				}
			}
		}

		private string definedMemory;
		public string DefinedMemory
		{
			get { return definedMemory; }
			set
			{
				if (definedMemory != value)
				{
					definedMemory = value;
					OnPropertyChanged(new PropertyChangedEventArgs("DefinedMemory"));
				}
			}
		}

		private string minAllocatedMemory;
		public string MinAllocatedMemory
		{
			get { return minAllocatedMemory; }
			set
			{
				if (minAllocatedMemory != value)
				{
					minAllocatedMemory = value;
					OnPropertyChanged(new PropertyChangedEventArgs("MinAllocatedMemory"));
				}
			}
		}

		private string os;
		public string OS
		{
			get { return os; }
			set
			{
				if (os != value)
				{
					os = value;
					OnPropertyChanged(new PropertyChangedEventArgs("OS"));
				}
			}
		}

		private string defaultDisplayType;
		public string DefaultDisplayType
		{
			get { return defaultDisplayType; }
			set
			{
				if (defaultDisplayType != value)
				{
					defaultDisplayType = value;
					OnPropertyChanged(new PropertyChangedEventArgs("DefaultDisplayType"));
				}
			}
		}

		private string origin;
		public string Origin
		{
			get { return origin; }
			set
			{
				if (origin != value)
				{
					origin = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Origin"));
				}
			}
		}

		private int monitorCount;
		public int MonitorCount
		{
			get { return monitorCount; }
			set
			{
				if (monitorCount != value)
				{
					monitorCount = value;
					OnPropertyChanged(new PropertyChangedEventArgs("MonitorCount"));
				}
			}
		}

		private bool hasMonitorCount;
		public bool HasMonitorCount
		{
			get { return hasMonitorCount; }
			set
			{
				if (hasMonitorCount != value)
				{
					hasMonitorCount = value;
					OnPropertyChanged(new PropertyChangedEventArgs("HasMonitorCount"));
				}
			}
		}

		private bool hasDomain;
		public bool HasDomain
		{
			get { return hasDomain; }
			set
			{
				if (hasDomain != value)
				{
					hasDomain = value;
					OnPropertyChanged(new PropertyChangedEventArgs("HasDomain"));
				}
			}
		}

		private bool hasStorageDomain;
		public bool HasStorageDomain
		{
			get { return hasStorageDomain; }
			set
			{
				if (hasStorageDomain != value)
				{
					hasStorageDomain = value;
					OnPropertyChanged(new PropertyChangedEventArgs("HasStorageDomain"));
				}
			}
		}

		private bool hasTimeZone;
		public bool HasTimeZone
		{
			get { return hasTimeZone; }
			set
			{
				if (hasTimeZone != value)
				{
					hasTimeZone = value;
					OnPropertyChanged(new PropertyChangedEventArgs("HasTimeZone"));
				}
			}
		}

		private string usbPolicy;
		public string UsbPolicy
		{
			get { return usbPolicy; }
			set
			{
				if (usbPolicy != value)
				{
					usbPolicy = value;
					OnPropertyChanged(new PropertyChangedEventArgs("UsbPolicy"));
				}
			}
		}

		private bool hasUsbPolicy;
		public bool HasUsbPolicy
		{
			get { return hasUsbPolicy; }
			set
			{
				if (hasUsbPolicy != value)
				{
					hasUsbPolicy = value;
					OnPropertyChanged(new PropertyChangedEventArgs("HasUsbPolicy"));
				}
			}
		}

		private string cpuInfo;
		public string CpuInfo
		{
			get { return cpuInfo; }
			set
			{
				if (cpuInfo != value)
				{
					cpuInfo = value;
					OnPropertyChanged(new PropertyChangedEventArgs("CpuInfo"));
				}
			}
		}

		private bool hasHighlyAvailable;
		public bool HasHighlyAvailable
		{
			get { return hasHighlyAvailable; }
			set
			{
				if (hasHighlyAvailable != value)
				{
					hasHighlyAvailable = value;
					OnPropertyChanged(new PropertyChangedEventArgs("HasHighlyAvailable"));
				}
			}
		}

		private bool isHighlyAvailable;
		public bool IsHighlyAvailable
		{
			get { return isHighlyAvailable; }
			set
			{
				if (isHighlyAvailable != value)
				{
					isHighlyAvailable = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsHighlyAvailable"));
				}
			}
		}

		private bool hasPriority;
		public bool HasPriority
		{
			get { return hasPriority; }
			set
			{
				if (hasPriority != value)
				{
					hasPriority = value;
					OnPropertyChanged(new PropertyChangedEventArgs("HasPriority"));
				}
			}
		}

		private string priority;
		public string Priority
		{
			get { return priority; }
			set
			{
				if (priority != value)
				{
					priority = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Priority"));
				}
			}
		}

		private bool hasAlert;
		public bool HasAlert
		{
			get { return hasAlert; }
			set
			{
				if (hasAlert != value)
				{
					hasAlert = value;
					OnPropertyChanged(new PropertyChangedEventArgs("HasAlert"));
				}
			}
		}

		private string alert;
		public string Alert
		{
			get { return alert; }
			set
			{
				if (alert != value)
				{
					alert = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Alert"));
				}
			}
		}

		private string domain;
		public string Domain
		{
			get { return domain; }
			set
			{
				if (domain != value)
				{
					domain = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Domain"));
				}
			}
		}

		private string storageDomain;
		public string StorageDomain
		{
			get { return storageDomain; }
			set
			{
				if (storageDomain != value)
				{
					storageDomain = value;
					OnPropertyChanged(new PropertyChangedEventArgs("StorageDomain"));
				}
			}
		}

		private string timeZone;
		public string TimeZone
		{
			get { return timeZone; }
			set
			{
				if (timeZone != value)
				{
					timeZone = value;
					OnPropertyChanged(new PropertyChangedEventArgs("TimeZone"));
				}
			}
		}

		private bool hasDefaultHost;
		public bool HasDefaultHost
		{
			get { return hasDefaultHost; }
			set
			{
				if (hasDefaultHost != value)
				{
					hasDefaultHost = value;
					OnPropertyChanged(new PropertyChangedEventArgs("HasDefaultHost"));
				}
			}
		}

		private string defaultHost;
		public string DefaultHost
		{
			get { return defaultHost; }
			set
			{
				if (defaultHost != value)
				{
					defaultHost = value;
					OnPropertyChanged(new PropertyChangedEventArgs("DefaultHost"));
				}
			}
		}

		private bool hasCustomProperties;
		public bool HasCustomProperties
		{
			get { return hasCustomProperties; }
			set
			{
				if (hasCustomProperties != value)
				{
					hasCustomProperties = value;
					OnPropertyChanged(new PropertyChangedEventArgs("HasCustomProperties"));
				}
			}
		}

		private string customProperties;
		public string CustomProperties
		{
			get { return customProperties; }
			set
			{
				if (customProperties != value)
				{
					customProperties = value;
					OnPropertyChanged(new PropertyChangedEventArgs("CustomProperties"));
				}
			}
		}

		#endregion

		static VmGeneralModel()
		{
			UpdateCompleteEventDefinition = new EventDefinition("UpdateComplete", typeof(VmGeneralModel));
		}

		public VmGeneralModel()
		{
			UpdateCompleteEvent = new Event(UpdateCompleteEventDefinition);

			Title = "General";
		}

		protected override void OnEntityChanged()
		{
			base.OnEntityChanged();

			if (Entity != null)
			{
				UpdateProperties();
			}
		}

		protected override void EntityPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.EntityPropertyChanged(sender, e);

			UpdateProperties();
		}

		private void UpdateProperties()
		{
			VM vm = (VM)Entity;

			Name = vm.vm_name;
			Description = vm.vm_description;
			Template = vm.vmt_name;
			DefinedMemory = vm.vm_mem_size_mb + " MB";
			MinAllocatedMemory = vm.MinAllocatedMem + " MB";

			Translator translator = EnumTranslator.Create<VmOsType>();
			OS = translator[vm.vm_os];

			translator = EnumTranslator.Create<DisplayType>();
			DefaultDisplayType = translator[vm.default_display_type];

			translator = EnumTranslator.Create<OriginType>();
			Origin = translator[vm.origin];

			HasHighlyAvailable = vm.vm_type == VmType.Server;
			IsHighlyAvailable = vm.auto_startup;

			HasPriority = vm.vm_type == VmType.Server;
			Priority = PriorityToString(vm.priority);

			HasMonitorCount = vm.vm_type == VmType.Desktop;
			MonitorCount = vm.num_of_monitors;

			HasUsbPolicy = true;
			translator = EnumTranslator.Create<UsbPolicy>();
			UsbPolicy = translator[vm.usb_policy];

			CpuInfo = vm.num_of_cpus + " " + "(" + vm.num_of_sockets + " Socket(s), " + vm.cpu_per_socket + " Core(s) per Socket)";
			
			HasDomain = DataProvider.IsWindowsOsType(vm.vm_os);
			Domain = vm.vm_domain;

			HasTimeZone = DataProvider.IsWindowsOsType(vm.vm_os);
			TimeZone = vm.time_zone;

			HasCustomProperties = vm.CustomProperties != String.Empty;
			CustomProperties = HasCustomProperties ? "Configured" : "Not-Configured";
			
			HasAlert = vm.VmPauseStatus != VmPauseStatus.NONE && vm.VmPauseStatus != VmPauseStatus.NOERR;
			if (HasAlert)
			{
				translator = EnumTranslator.Create<VmPauseStatus>();
				Alert = translator[vm.VmPauseStatus];
			}
			else
			{
				Alert = null;
			}

			HasDefaultHost = vm.dedicated_vm_for_vds != null;
			if (HasDefaultHost)
			{
				Frontend.RunQuery(VdcQueryType.Search, new SearchParameters("Host: cluster = " + vm.vds_group_name + " sortby name", SearchType.VDS), new AsyncQuery(this,
					(target, returnValue) =>
					{
						VmGeneralModel model = (VmGeneralModel)target;

						VM localVm = (VM)model.Entity;
						if (localVm == null)
						{
							return;
						}

						List<VDS> hosts = (List<VDS>)((VdcQueryReturnValue)returnValue).ReturnValue;
						foreach (VDS host in hosts)
						{
							if (localVm.dedicated_vm_for_vds != null && host.vds_id.Equals(localVm.dedicated_vm_for_vds))
							{
								model.DefaultHost = host.vds_name;
								break;
							}
						}

						model.UpdateStorageDomain();
					})
				);
			}
			else
			{
				DefaultHost = "Any Host in Cluster";

				UpdateStorageDomain();
			}
		}

		public void UpdateStorageDomain()
		{
			AsyncQuery _asyncQuery = new AsyncQuery();
			_asyncQuery.Model = this;
			/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object ReturnValue)
			{
				VmGeneralModel vmGeneralModel = (VmGeneralModel)model;
				IEnumerable disks = (IEnumerable)((VdcQueryReturnValue)ReturnValue).ReturnValue;
				IEnumerator disksIterator = disks.GetEnumerator();
				if (disksIterator.MoveNext())
				{
					vmGeneralModel.HasStorageDomain = true;

					AsyncQuery _asyncQuery1 = new AsyncQuery();
					_asyncQuery1.Model = vmGeneralModel;
					/*START_DELEGATE*/_asyncQuery1.asyncCallback = delegate(Object model1, Object ReturnValue1)
					{
						VmGeneralModel vmGeneralModel1 = (VmGeneralModel)model1;
						storage_domains storage = (storage_domains)((VdcQueryReturnValue)ReturnValue1).ReturnValue;
						vmGeneralModel1.StorageDomain = storage.storage_name;

						vmGeneralModel1.UpdateCompleteEvent.raise(this, EventArgs.Empty);
					};//END_DELEGATE

					DiskImage firstDisk = (DiskImage)disksIterator.Current;
					Frontend.RunQuery(VdcQueryType.GetStorageDomainById, new StorageDomainQueryParametersBase(firstDisk.storage_id.Value), _asyncQuery1);
				}
				else
				{
					vmGeneralModel.HasStorageDomain = false;

					vmGeneralModel.UpdateCompleteEvent.raise(this, EventArgs.Empty);
				}
			};//END_DELEGATE

			VM vm = (VM)Entity;
			Frontend.RunQuery(VdcQueryType.GetAllDisksByVmId, new GetAllDisksByVmIdParameters(vm.vm_guid), _asyncQuery);
		}

		//TODO: Find a better place for this code. It must be something common,
		//allowing using of converters' code available in UICommon.
		public string PriorityToString(int value)
		{
			int highPriority = DataProvider.GetMaxVmPriority();
			int roundedPriority = DataProvider.RoundPriority(value);

			if (roundedPriority == 1)
			{
				return "Low";
			}
			else if (roundedPriority == DataProvider.GetMaxVmPriority() / 2)
			{
				return "Medium";
			}
			else if (roundedPriority == DataProvider.GetMaxVmPriority())
			{
				return "High";
			}
			else
			{
				return "Unknown";
			}
		}
	}
}
