﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using org.ovirt.engine.ui.uicompat;
using log4net;
using log4net.Appender;
using log4net.Core;
using log4net.Repository;
using log4net.Repository.Hierarchy;
using VdcUtils;
using ILogger = org.ovirt.engine.ui.uicommon.ILogger;

namespace UI.WPFClient
{
	/// <summary>
	/// Log4NetLogger: Implementation for UILogger for WPF only.
	/// This class requires the log4net DLL to be referenced within the UICommon project.
	/// NOTE: *** No usage of log4net.dll should be used outside of the 'compat' folder -
	/// translation to java won't succeed otherwise ***
	/// </summary>
	public class Log4NetLogger : QLogger, ILogger
	{
		private string logLevel;
		public string LogLevel
		{
			get { return logLevel; }
			set
			{
				if (logLevel == value) return;

				Info("Setting log level to: '" + value + "'");

				ILoggerRepository[] repositories = LogManager.GetAllRepositories();

				//Configure all loggers to be at the specified 'level':
				foreach (ILoggerRepository repository in repositories)
				{
					repository.Threshold = repository.LevelMap[value];
					Hierarchy hier = (Hierarchy)repository;
					log4net.Core.ILogger[] loggers = hier.GetCurrentLoggers();
					foreach (log4net.Core.ILogger logger in loggers)
					{
						((Logger)logger).Level = hier.LevelMap[value];
					}
				}

				//Configure the root logger.
				Hierarchy h = (Hierarchy)LogManager.GetRepository();
				Logger rootLogger = h.Root;
				rootLogger.Level = h.LevelMap[value];

				logLevel = value;
			}
		}
	}


	public class DomainSpecificFileAppender : RollingFileAppender
	{
		public override string File
		{
			get
			{
				return base.File;
			}
			set
			{
				base.File = Path.Combine(Path.Combine(Path.GetTempPath(), App.Host), value);
			}
		}
	}
}
