﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

namespace VdcCommon.BusinessEntities
{
    
    public partial class GetVmPoolByIdParametersBase : VdcQueryParametersBase
	{
        public GetVmPoolByIdParametersBase() { }

        public GetVmPoolByIdParametersBase(Guid poolId)
		{
			PoolId = poolId;
		}
	}

	
    public partial class GetVmPoolByIdParameters : GetVmPoolByIdParametersBase
	{
        public GetVmPoolByIdParameters() { }

        public GetVmPoolByIdParameters(Guid poolId) 
			: base (poolId)
		{
		}

        public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
            return RegisterableQueryReturnDataType.IQUERYABLE;
        }
	}

	
    public partial class GetVmPoolsMapByVmPoolIdParameters : GetVmPoolByIdParametersBase
	{
        public GetVmPoolsMapByVmPoolIdParameters() { }

        public GetVmPoolsMapByVmPoolIdParameters(Guid poolId)
			: base(poolId)
		{
		}

        public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
            return RegisterableQueryReturnDataType.UNDEFINED;
        }
	}

	
    public partial class HasFreeVmsInPoolParameters : GetVmPoolByIdParametersBase
	{
        public HasFreeVmsInPoolParameters() { }

        public HasFreeVmsInPoolParameters(Guid poolId)
			: base(poolId)
		{
		}

        public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
            return RegisterableQueryReturnDataType.UNDEFINED;
        }
	}
	

    public partial class GetAllVmPoolsAttachedToUserParameters : VdcQueryParametersBase
	{
        public GetAllVmPoolsAttachedToUserParameters() { }

		public GetAllVmPoolsAttachedToUserParameters(guid userId)
		{
            UserId = userId;
		}
	}

	
    public partial class IsVmPoolWithSameNameExistsParameters : VdcQueryParametersBase
	{
        public IsVmPoolWithSameNameExistsParameters() { }

		public IsVmPoolWithSameNameExistsParameters(string vmPoolName)
		{
			VmPoolName = vmPoolName;
		}

        public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
            return RegisterableQueryReturnDataType.UNDEFINED;
        }
	}
	
}
