﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using org.ovirt.engine.ui.uicommon.models;
using org.ovirt.engine.ui.uicommon.models.userportal;
using VdcCommon.BusinessEntities;

namespace org.ovirt.engine.ui.uicommon.models.userportal
{
	public abstract class IUserPortalListModel : ListWithDetailsModel
	{
		#region Properties

		private bool canConnectAutomatically;
		public bool CanConnectAutomatically
		{
			get { return canConnectAutomatically; }
			set
			{
				if (canConnectAutomatically != value)
				{
					canConnectAutomatically = value;
					OnPropertyChanged(new PropertyChangedEventArgs("CanConnectAutomatically"));
				}
			}
		}

		#endregion

		public abstract void OnVmAndPoolLoad();

		protected Dictionary<Guid, vm_pools> poolMap;

		public vm_pools ResolveVmPoolById(Guid id)
		{
			return poolMap[id];
		}

		// Return a list of VMs with status 'UP'
		public List<UserPortalItemModel> GetStatusUpVms(IEnumerable items)
		{
			return GetUpVms(items, true);
		}

		// Return a list of up VMs
		public List<UserPortalItemModel> GetUpVms(IEnumerable items)
		{
			return GetUpVms(items, false);
		}

		private List<UserPortalItemModel> GetUpVms(IEnumerable items, bool onlyVmStatusUp)
		{
			List<UserPortalItemModel> upVms = new List<UserPortalItemModel>();
			if (items != null)
			{
				foreach (object item in items)
				{
					UserPortalItemModel userPortalItemModel = (UserPortalItemModel)item;
					VM vm = userPortalItemModel.Entity as VM;
					if (vm == null)
					{
						continue;
					}
					if ((onlyVmStatusUp && vm.status == VMStatus.Up) ||
						(!onlyVmStatusUp && userPortalItemModel.DefaultConsole.IsVmUp()))
					{
						upVms.Add(userPortalItemModel);
					}
				}
			}
			return upVms;
		}
	}
}
