using System;
using System.Text.RegularExpressions;

namespace org.ovirt.engine.ui.uicommon.validation
{
	public class RegexValidation : IValidation
	{
		#region Constants

		//public const string NoSpacesRegex = @"^[^\s]+$";
		//public const string NoSpacesMessage = "This field can't contain spaces.";
		//public const string AtLeastOneCharRegex = @"[a-zA-Z]+";
		//public const string AtLeastOneCharMsg = "This field must contain at least one alphabetic character.";
		//public const string MemSizeRegex = @"^\d+\s*(m|mb|g|gb){0,1}\s*$";
		//public const string IpAddressRegex = @"^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$";
		//public const string IpAddressMessage = "This field must contain an IP address in format xxx.xxx.xxx.xxx";
		//public const string EmailRegex = @"^[\w-]+(?:\.[\w-]+)*@(?:[\w-]+\.)+[a-zA-Z]{2,7}$";
		//public const string EmailMessage = "Invalid E-Mail address";
		//public const string MacRegex = @"^([\dabcdef]{2}:?){6}$";
		//public const string MacMessage = "Invalid MAC address";

		#endregion

		#region Properties

		public string Expression { get; set; }
		public string Message { get; set; }
        public bool IsNegate { get; set; }
		//public bool IgnoreCase { get; set; }

		#endregion

		public ValidationResult Validate(object value)
		{
			ValidationResult result = new ValidationResult();
            
			//if (IgnoreCase)
			//{
			//    options = RegexOptions.IgnoreCase;
			//}

			if (value != null
				&& value is String
				&& !String.IsNullOrEmpty((string)value)
				&& (IsNegate ? Regex.IsMatch(value.ToString(), Expression, RegexOptions.None) : !Regex.IsMatch(value.ToString(), Expression, RegexOptions.None)))
			{
				result.Success = false;
				result.Reasons.Add(Message);
			}
            
            return result;
		}
	}
}