print 'Recreating Primary Keys...'
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_action_version_map' AND TABLE_NAME='action_version_map')
BEGIN
ALTER TABLE action_version_map ADD CONSTRAINT PK_action_version_map PRIMARY KEY(action_type)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='pk_ad_group_id' AND TABLE_NAME='ad_groups')
BEGIN
ALTER TABLE ad_groups ADD CONSTRAINT pk_ad_group_id PRIMARY KEY( id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_async_tasks' AND TABLE_NAME='async_tasks')
BEGIN
ALTER TABLE async_tasks ADD CONSTRAINT PK_async_tasks PRIMARY KEY( task_id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_audit_log' AND TABLE_NAME='audit_log')
BEGIN
ALTER TABLE audit_log ADD CONSTRAINT PK_audit_log PRIMARY KEY( audit_log_id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_bookmarks' AND TABLE_NAME='bookmarks')
BEGIN
ALTER TABLE bookmarks ADD CONSTRAINT PK_bookmarks PRIMARY KEY( bookmark_Id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_custom_actions' AND TABLE_NAME='custom_actions')
BEGIN
ALTER TABLE custom_actions ADD CONSTRAINT PK_custom_actions PRIMARY KEY( action_name,tab)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_disk_image_dynamic' AND TABLE_NAME='disk_image_dynamic')
BEGIN
ALTER TABLE disk_image_dynamic ADD CONSTRAINT PK_disk_image_dynamic PRIMARY KEY( image_id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_EVENT_MAP' AND TABLE_NAME='event_map')
BEGIN
ALTER TABLE event_map ADD CONSTRAINT PK_EVENT_MAP PRIMARY KEY( event_up_name)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_EVENT_NOTIFICATION_METHODS' AND TABLE_NAME='event_notification_methods')
BEGIN
ALTER TABLE event_notification_methods ADD CONSTRAINT PK_EVENT_NOTIFICATION_METHODS PRIMARY KEY( method_id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_EVENT_SUBSCRIBER' AND TABLE_NAME='event_subscriber')
BEGIN
ALTER TABLE event_subscriber ADD CONSTRAINT PK_EVENT_SUBSCRIBER PRIMARY KEY( event_up_name,method_id,subscriber_id,tag_name)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_image_group_storage_domain_map' AND TABLE_NAME='image_group_storage_domain_map')
BEGIN
ALTER TABLE image_group_storage_domain_map ADD CONSTRAINT PK_image_group_storage_domain_map PRIMARY KEY( image_group_id,storage_domain_id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_image_templates' AND TABLE_NAME='image_templates')
BEGIN
ALTER TABLE image_templates ADD CONSTRAINT PK_image_templates PRIMARY KEY( it_guid)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='pk_image_vm_map' AND TABLE_NAME='image_vm_map')
BEGIN
ALTER TABLE image_vm_map ADD CONSTRAINT pk_image_vm_map PRIMARY KEY( image_id,vm_id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_image_vm_pool_map' AND TABLE_NAME='image_vm_pool_map')
BEGIN
ALTER TABLE image_vm_pool_map ADD CONSTRAINT PK_image_vm_pool_map PRIMARY KEY( image_guid)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_images' AND TABLE_NAME='images')
BEGIN
ALTER TABLE images ADD CONSTRAINT PK_images PRIMARY KEY( image_guid)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_vm_interface_statistics' AND TABLE_NAME='interface_statistics')
BEGIN
ALTER TABLE interface_statistics ADD CONSTRAINT PK_vm_interface_statistics PRIMARY KEY( id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_LUN_storage_server_connection_map' AND TABLE_NAME='LUN_storage_server_connection_map')
BEGIN
ALTER TABLE LUN_storage_server_connection_map ADD CONSTRAINT PK_LUN_storage_server_connection_map PRIMARY KEY( LUN_id,storage_server_connection)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_LUNs' AND TABLE_NAME='LUNs')
BEGIN
ALTER TABLE LUNs ADD CONSTRAINT PK_LUNs PRIMARY KEY( LUN_id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_network' AND TABLE_NAME='network')
BEGIN
ALTER TABLE network ADD CONSTRAINT PK_network PRIMARY KEY( id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_network_cluster' AND TABLE_NAME='network_cluster')
BEGIN
ALTER TABLE network_cluster ADD CONSTRAINT PK_network_cluster PRIMARY KEY( cluster_id,network_id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='pk_permissions_id' AND TABLE_NAME='permissions')
BEGIN
ALTER TABLE permissions ADD CONSTRAINT pk_permissions_id PRIMARY KEY( id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME like 'PK__rhevm_license_us%' AND TABLE_NAME='rhevm_license_usage')
BEGIN
ALTER TABLE rhevm_license_usage ADD CONSTRAINT PK__rhevm_license_us PRIMARY KEY( date)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='pk_roles_id' AND TABLE_NAME='roles')
BEGIN
ALTER TABLE roles ADD CONSTRAINT pk_roles_id PRIMARY KEY( id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='pk_roles_actions' AND TABLE_NAME='roles_actions')
BEGIN
ALTER TABLE roles_actions ADD CONSTRAINT pk_roles_actions PRIMARY KEY( action_id,role_id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='pk_roles_relations' AND TABLE_NAME='roles_relations')
BEGIN
ALTER TABLE roles_relations ADD CONSTRAINT pk_roles_relations PRIMARY KEY( role_container_id,role_id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_stateless_vm_image_map' AND TABLE_NAME='stateless_vm_image_map')
BEGIN
ALTER TABLE stateless_vm_image_map ADD CONSTRAINT PK_stateless_vm_image_map PRIMARY KEY( image_guid)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_storage_domain_dynamic' AND TABLE_NAME='storage_domain_dynamic')
BEGIN
ALTER TABLE storage_domain_dynamic ADD CONSTRAINT PK_storage_domain_dynamic PRIMARY KEY( id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='pk_storage' AND TABLE_NAME='storage_domain_static')
BEGIN
ALTER TABLE storage_domain_static ADD CONSTRAINT pk_storage PRIMARY KEY( id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='pk_storage_pool' AND TABLE_NAME='storage_pool')
BEGIN
ALTER TABLE storage_pool ADD CONSTRAINT pk_storage_pool PRIMARY KEY( id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_storage_domain_pool_map' AND TABLE_NAME='storage_pool_iso_map')
BEGIN
ALTER TABLE storage_pool_iso_map ADD CONSTRAINT PK_storage_domain_pool_map PRIMARY KEY( storage_id,storage_pool_id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_storage_server' AND TABLE_NAME='storage_server_connections')
BEGIN
ALTER TABLE storage_server_connections ADD CONSTRAINT PK_storage_server PRIMARY KEY( id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='pk_tags_id' AND TABLE_NAME='tags')
BEGIN
ALTER TABLE tags ADD CONSTRAINT pk_tags_id PRIMARY KEY( tag_id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='pk_tags_permissions_map' AND TABLE_NAME='tags_permissions_map')
BEGIN
ALTER TABLE tags_permissions_map ADD CONSTRAINT pk_tags_permissions_map PRIMARY KEY( permission_id,tag_id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='pk_tags_user_group_map' AND TABLE_NAME='tags_user_group_map')
BEGIN
ALTER TABLE tags_user_group_map ADD CONSTRAINT pk_tags_user_group_map PRIMARY KEY( group_id,tag_id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='pk_tags_user_map' AND TABLE_NAME='tags_user_map')
BEGIN
ALTER TABLE tags_user_map ADD CONSTRAINT pk_tags_user_map PRIMARY KEY( tag_id,user_id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='pk_tags_vds_map' AND TABLE_NAME='tags_vds_map')
BEGIN
ALTER TABLE tags_vds_map ADD CONSTRAINT pk_tags_vds_map PRIMARY KEY( tag_id,vds_id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='pk_tags_vm_map' AND TABLE_NAME='tags_vm_map')
BEGIN
ALTER TABLE tags_vm_map ADD CONSTRAINT pk_tags_vm_map PRIMARY KEY( tag_id,vm_id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='pk_tags_vm_pool_map' AND TABLE_NAME='tags_vm_pool_map')
BEGIN
ALTER TABLE tags_vm_pool_map ADD CONSTRAINT pk_tags_vm_pool_map PRIMARY KEY( tag_id,vm_pool_id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='pk_time_user_vm_pool_map' AND TABLE_NAME='time_lease_vm_pool_map')
BEGIN
ALTER TABLE time_lease_vm_pool_map ADD CONSTRAINT pk_time_user_vm_pool_map PRIMARY KEY( id,vm_pool_id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='pk_user_sessions' AND TABLE_NAME='user_sessions')
BEGIN
ALTER TABLE user_sessions ADD CONSTRAINT pk_user_sessions PRIMARY KEY( session_id,user_id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_users' AND TABLE_NAME='users')
BEGIN
ALTER TABLE users ADD CONSTRAINT PK_users PRIMARY KEY( user_id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='pk_vdc_db_log' AND TABLE_NAME='vdc_db_log')
BEGIN
ALTER TABLE vdc_db_log ADD CONSTRAINT pk_vdc_db_log PRIMARY KEY( error_id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_vdc_options' AND TABLE_NAME='vdc_options')
BEGIN
ALTER TABLE vdc_options ADD CONSTRAINT PK_vdc_options PRIMARY KEY( option_id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_vds_dynamic' AND TABLE_NAME='vds_dynamic')
BEGIN
ALTER TABLE vds_dynamic ADD CONSTRAINT PK_vds_dynamic PRIMARY KEY( vds_id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_vds_groups' AND TABLE_NAME='vds_groups')
BEGIN
ALTER TABLE vds_groups ADD CONSTRAINT PK_vds_groups PRIMARY KEY( vds_group_id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_vds_interface' AND TABLE_NAME='vds_interface')
BEGIN
ALTER TABLE vds_interface ADD CONSTRAINT PK_vds_interface PRIMARY KEY( id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_vds_spm_id_map' AND TABLE_NAME='vds_spm_id_map')
BEGIN
ALTER TABLE vds_spm_id_map ADD CONSTRAINT PK_vds_spm_id_map PRIMARY KEY( storage_pool_id,vds_spm_id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_vds_static' AND TABLE_NAME='vds_static')
BEGIN
ALTER TABLE vds_static ADD CONSTRAINT PK_vds_static PRIMARY KEY( vds_id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_vds_statistics' AND TABLE_NAME='vds_statistics')
BEGIN
ALTER TABLE vds_statistics ADD CONSTRAINT PK_vds_statistics PRIMARY KEY( vds_id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_vds_tools_version_map' AND TABLE_NAME='vds_tools_version_map')
BEGIN
ALTER TABLE vds_tools_version_map ADD CONSTRAINT PK_vds_tools_version_map PRIMARY KEY( cluster_version,storage_domain_id,tools_version)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_vm_dynamic' AND TABLE_NAME='vm_dynamic')
BEGIN
ALTER TABLE vm_dynamic ADD CONSTRAINT PK_vm_dynamic PRIMARY KEY( vm_guid)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_vm_interface' AND TABLE_NAME='vm_interface')
BEGIN
ALTER TABLE vm_interface ADD CONSTRAINT PK_vm_interface PRIMARY KEY( id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_vm_pool_map' AND TABLE_NAME='vm_pool_map')
BEGIN
ALTER TABLE vm_pool_map ADD CONSTRAINT PK_vm_pool_map PRIMARY KEY( vm_guid)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_vm_pools' AND TABLE_NAME='vm_pools')
BEGIN
ALTER TABLE vm_pools ADD CONSTRAINT PK_vm_pools PRIMARY KEY( vm_pool_id)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_vm_static' AND TABLE_NAME='vm_static')
BEGIN
ALTER TABLE vm_static ADD CONSTRAINT PK_vm_static PRIMARY KEY( vm_guid)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_vm_statistics' AND TABLE_NAME='vm_statistics')
BEGIN
ALTER TABLE vm_statistics ADD CONSTRAINT PK_vm_statistics PRIMARY KEY( vm_guid)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_vm_template_image_map' AND TABLE_NAME='vm_template_image_map')
BEGIN
ALTER TABLE vm_template_image_map ADD CONSTRAINT PK_vm_template_image_map PRIMARY KEY( it_guid,vmt_guid)
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='PK_vm_templates' AND TABLE_NAME='vm_templates')
BEGIN
ALTER TABLE vm_templates ADD CONSTRAINT PK_vm_templates PRIMARY KEY( vmt_guid)
END
go
print 'Recreating Foreign Keys...'
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='FK_disk_image_dynamic_images' AND TABLE_NAME='disk_image_dynamic')
BEGIN
ALTER TABLE [dbo].[disk_image_dynamic] ADD CONSTRAINT [FK_disk_image_dynamic_images]
   FOREIGN KEY ([image_id]) REFERENCES [dbo].[images] ([image_guid])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='FK_EVENT_NOTIFICATION_HIST_audit_log' AND TABLE_NAME='event_notification_hist')
BEGIN
ALTER TABLE [dbo].[event_notification_hist] ADD CONSTRAINT [FK_EVENT_NOTIFICATION_HIST_audit_log]
   FOREIGN KEY ([audit_log_id]) REFERENCES [dbo].[audit_log] ([audit_log_id])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='FK_EVENT_NOTIFICATION_users' AND TABLE_NAME='event_notification_hist')
BEGIN
ALTER TABLE [dbo].[event_notification_hist] ADD CONSTRAINT [FK_EVENT_NOTIFICATION_users]
   FOREIGN KEY ([subscriber_id]) REFERENCES [dbo].[users] ([user_id])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='FK_EVENT_SUBSCRIBER_EVENT_MAP' AND TABLE_NAME='event_subscriber')
BEGIN
ALTER TABLE [dbo].[event_subscriber] ADD CONSTRAINT [FK_EVENT_SUBSCRIBER_EVENT_MAP]
   FOREIGN KEY ([event_up_name]) REFERENCES [dbo].[event_map] ([event_up_name])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='FK_EVENT_SUBSCRIBER_EVENT_NOTIFICATION_METHODS' AND TABLE_NAME='event_subscriber')
BEGIN
ALTER TABLE [dbo].[event_subscriber] ADD CONSTRAINT [FK_EVENT_SUBSCRIBER_EVENT_NOTIFICATION_METHODS]
   FOREIGN KEY ([method_id]) REFERENCES [dbo].[event_notification_methods] ([method_id])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='FK_EVENT_SUBSCRIBER_users' AND TABLE_NAME='event_subscriber')
BEGIN
ALTER TABLE [dbo].[event_subscriber] ADD CONSTRAINT [FK_EVENT_SUBSCRIBER_users]
   FOREIGN KEY ([subscriber_id]) REFERENCES [dbo].[users] ([user_id])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='FK_image_group_storage_domain_map_storage_domain_static' AND TABLE_NAME='image_group_storage_domain_map')
BEGIN
ALTER TABLE [dbo].[image_group_storage_domain_map] ADD CONSTRAINT [FK_image_group_storage_domain_map_storage_domain_static]
   FOREIGN KEY ([storage_domain_id]) REFERENCES [dbo].[storage_domain_static] ([id])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='FK_image_vm_map_vm_static' AND TABLE_NAME='image_vm_map')
BEGIN
ALTER TABLE [dbo].[image_vm_map] ADD CONSTRAINT [FK_image_vm_map_vm_static]
   FOREIGN KEY ([vm_id]) REFERENCES [dbo].[vm_static] ([vm_guid])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='vm_pool_map_image' AND TABLE_NAME='image_vm_pool_map')
BEGIN
ALTER TABLE [dbo].[image_vm_pool_map] ADD CONSTRAINT [vm_pool_map_image]
   FOREIGN KEY ([vm_guid]) REFERENCES [dbo].[vm_pool_map] ([vm_guid])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='Fk_images_storage_id' AND TABLE_NAME='images')
BEGIN
ALTER TABLE [dbo].[images] ADD CONSTRAINT [Fk_images_storage_id]
   FOREIGN KEY ([storage_id]) REFERENCES [dbo].[storage_domain_static] ([id])
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='image_templates_images' AND TABLE_NAME='images')
BEGIN
ALTER TABLE [dbo].[images] ADD CONSTRAINT [image_templates_images]
   FOREIGN KEY ([it_guid]) REFERENCES [dbo].[image_templates] ([it_guid])
END
go

IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='FK_interface_statistics_vds_static' AND TABLE_NAME='interface_statistics')
BEGIN
ALTER TABLE [dbo].[interface_statistics] ADD CONSTRAINT [FK_interface_statistics_vds_static]
   FOREIGN KEY ([vds_id]) REFERENCES [dbo].[vds_static] ([vds_id])
     ON DELETE CASCADE
END
go

IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='FK_interface_statistics_vm_static' AND TABLE_NAME='interface_statistics')
BEGIN
ALTER TABLE [dbo].[interface_statistics] ADD CONSTRAINT [FK_interface_statistics_vm_static]
   FOREIGN KEY ([vm_id]) REFERENCES [dbo].[vm_static] ([vm_guid])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='FK_LUN_storage_server_connection_map_LUNs' AND TABLE_NAME='LUN_storage_server_connection_map')
BEGIN
ALTER TABLE [dbo].[LUN_storage_server_connection_map] ADD CONSTRAINT [FK_LUN_storage_server_connection_map_LUNs]
   FOREIGN KEY ([LUN_id]) REFERENCES [dbo].[LUNs] ([LUN_id])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='FK_LUN_storage_server_connection_map_storage_server_connections' AND TABLE_NAME='LUN_storage_server_connection_map')
BEGIN
ALTER TABLE [dbo].[LUN_storage_server_connection_map] ADD CONSTRAINT [FK_LUN_storage_server_connection_map_storage_server_connections]
   FOREIGN KEY ([storage_server_connection]) REFERENCES [dbo].[storage_server_connections] ([id])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='FK_network_storage_pool' AND TABLE_NAME='network')
BEGIN
ALTER TABLE [dbo].[network] ADD CONSTRAINT [FK_network_storage_pool]
   FOREIGN KEY ([storage_pool_id]) REFERENCES [dbo].[storage_pool] ([id])ON DELETE SET NULL
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='FK_network_cluster_network' AND TABLE_NAME='network_cluster')
BEGIN
ALTER TABLE [dbo].[network_cluster] ADD CONSTRAINT [FK_network_cluster_network]
   FOREIGN KEY ([network_id]) REFERENCES [dbo].[network] ([id])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='FK_network_cluster_vds_groups' AND TABLE_NAME='network_cluster')
BEGIN
ALTER TABLE [dbo].[network_cluster] ADD CONSTRAINT [FK_network_cluster_vds_groups]
   FOREIGN KEY ([cluster_id]) REFERENCES [dbo].[vds_groups] ([vds_group_id])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='fk_roles_actions_action_id' AND TABLE_NAME='roles_actions')
BEGIN
ALTER TABLE [dbo].[roles_actions] ADD CONSTRAINT [fk_roles_actions_action_id]
   FOREIGN KEY ([role_id]) REFERENCES [dbo].[roles] ([id])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='fk_roles_relations_container_id' AND TABLE_NAME='roles_relations')
BEGIN
ALTER TABLE [dbo].[roles_relations] ADD CONSTRAINT [fk_roles_relations_container_id]
   FOREIGN KEY ([role_container_id]) REFERENCES [dbo].[roles] ([id])
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='fk_roles_relations_role_id' AND TABLE_NAME='roles_relations')
BEGIN
ALTER TABLE [dbo].[roles_relations] ADD CONSTRAINT [fk_roles_relations_role_id]
   FOREIGN KEY ([role_id]) REFERENCES [dbo].[roles] ([id])
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='FK_stateless_vm_static' AND TABLE_NAME='stateless_vm_image_map')
BEGIN
ALTER TABLE [dbo].[stateless_vm_image_map] ADD CONSTRAINT [FK_stateless_vm_static]
   FOREIGN KEY ([vm_guid]) REFERENCES [dbo].[vm_static] ([vm_guid])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='FK_storage_domain_dynamic_storage_domain_static' AND TABLE_NAME='storage_domain_dynamic')
BEGIN
ALTER TABLE [dbo].[storage_domain_dynamic] ADD CONSTRAINT [FK_storage_domain_dynamic_storage_domain_static]
   FOREIGN KEY ([id]) REFERENCES [dbo].[storage_domain_static] ([id])
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='FK_storage_domain_pool_map_storage_domain_static' AND TABLE_NAME='storage_pool_iso_map')
BEGIN
ALTER TABLE [dbo].[storage_pool_iso_map] ADD CONSTRAINT [FK_storage_domain_pool_map_storage_domain_static]
   FOREIGN KEY ([storage_id]) REFERENCES [dbo].[storage_domain_static] ([id])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='FK_storage_domain_pool_map_storage_pool' AND TABLE_NAME='storage_pool_iso_map')
BEGIN
ALTER TABLE [dbo].[storage_pool_iso_map] ADD CONSTRAINT [FK_storage_domain_pool_map_storage_pool]
   FOREIGN KEY ([storage_pool_id]) REFERENCES [dbo].[storage_pool] ([id])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='fk_roles_relations_permission_id' AND TABLE_NAME='tags_permissions_map')
BEGIN
ALTER TABLE [dbo].[tags_permissions_map] ADD CONSTRAINT [fk_roles_relations_permission_id]
   FOREIGN KEY ([permission_id]) REFERENCES [dbo].[permissions] ([id])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='fk_tags_permissions_tag_id' AND TABLE_NAME='tags_permissions_map')
BEGIN
ALTER TABLE [dbo].[tags_permissions_map] ADD CONSTRAINT [fk_tags_permissions_tag_id]
   FOREIGN KEY ([tag_id]) REFERENCES [dbo].[tags] ([tag_id])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='tags_user_group_map_tag' AND TABLE_NAME='tags_user_group_map')
BEGIN
ALTER TABLE [dbo].[tags_user_group_map] ADD CONSTRAINT [tags_user_group_map_tag]
   FOREIGN KEY ([tag_id]) REFERENCES [dbo].[tags] ([tag_id])
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='tags_user_map_user_group' AND TABLE_NAME='tags_user_group_map')
BEGIN
ALTER TABLE [dbo].[tags_user_group_map] ADD CONSTRAINT [tags_user_map_user_group]
   FOREIGN KEY ([group_id]) REFERENCES [dbo].[ad_groups] ([id])
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='tags_user_map_tag' AND TABLE_NAME='tags_user_map')
BEGIN
ALTER TABLE [dbo].[tags_user_map] ADD CONSTRAINT [tags_user_map_tag]
   FOREIGN KEY ([tag_id]) REFERENCES [dbo].[tags] ([tag_id])
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='tags_user_map_user' AND TABLE_NAME='tags_user_map')
BEGIN
ALTER TABLE [dbo].[tags_user_map] ADD CONSTRAINT [tags_user_map_user]
   FOREIGN KEY ([user_id]) REFERENCES [dbo].[users] ([user_id])
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='tags_vds_map_tag' AND TABLE_NAME='tags_vds_map')
BEGIN
ALTER TABLE [dbo].[tags_vds_map] ADD CONSTRAINT [tags_vds_map_tag]
   FOREIGN KEY ([tag_id]) REFERENCES [dbo].[tags] ([tag_id])
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='tags_vds_map_vds' AND TABLE_NAME='tags_vds_map')
BEGIN
ALTER TABLE [dbo].[tags_vds_map] ADD CONSTRAINT [tags_vds_map_vds]
   FOREIGN KEY ([vds_id]) REFERENCES [dbo].[vds_static] ([vds_id])
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='tags_vm_map_tag' AND TABLE_NAME='tags_vm_map')
BEGIN
ALTER TABLE [dbo].[tags_vm_map] ADD CONSTRAINT [tags_vm_map_tag]
   FOREIGN KEY ([tag_id]) REFERENCES [dbo].[tags] ([tag_id])
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='tags_vm_map_vm' AND TABLE_NAME='tags_vm_map')
BEGIN
ALTER TABLE [dbo].[tags_vm_map] ADD CONSTRAINT [tags_vm_map_vm]
   FOREIGN KEY ([vm_id]) REFERENCES [dbo].[vm_static] ([vm_guid])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='fk_tags_vm_pool_map_tag' AND TABLE_NAME='tags_vm_pool_map')
BEGIN
ALTER TABLE [dbo].[tags_vm_pool_map] ADD CONSTRAINT [fk_tags_vm_pool_map_tag]
   FOREIGN KEY ([tag_id]) REFERENCES [dbo].[tags] ([tag_id])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='fk_tags_vm_pool_map_vm_pool' AND TABLE_NAME='tags_vm_pool_map')
BEGIN
ALTER TABLE [dbo].[tags_vm_pool_map] ADD CONSTRAINT [fk_tags_vm_pool_map_vm_pool]
   FOREIGN KEY ([vm_pool_id]) REFERENCES [dbo].[vm_pools] ([vm_pool_id])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='fk_users' AND TABLE_NAME='user_sessions')
BEGIN
ALTER TABLE [dbo].[user_sessions] ADD CONSTRAINT [fk_users]
   FOREIGN KEY ([user_id]) REFERENCES [dbo].[users] ([user_id])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='vds_static_vds_dynamic' AND TABLE_NAME='vds_dynamic')
BEGIN
ALTER TABLE [dbo].[vds_dynamic] ADD CONSTRAINT [vds_static_vds_dynamic]
   FOREIGN KEY ([vds_id]) REFERENCES [dbo].[vds_static] ([vds_id]) 
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='Fk_vds_groups_storage_pool_id' AND TABLE_NAME='vds_groups')
BEGIN
ALTER TABLE [dbo].[vds_groups] ADD CONSTRAINT [Fk_vds_groups_storage_pool_id]
   FOREIGN KEY ([storage_pool_id]) REFERENCES [dbo].[storage_pool] ([id]) ON DELETE SET NULL
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='FK_vds_interface_vds_interface' AND TABLE_NAME='vds_interface')
BEGIN
ALTER TABLE [dbo].[vds_interface] ADD CONSTRAINT [FK_vds_interface_vds_interface]
   FOREIGN KEY ([vds_id]) REFERENCES [dbo].[vds_static] ([vds_id])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='FK_vds_spm_id_map_storage_pool' AND TABLE_NAME='vds_spm_id_map')
BEGIN
ALTER TABLE [dbo].[vds_spm_id_map] ADD CONSTRAINT [FK_vds_spm_id_map_storage_pool]
   FOREIGN KEY ([storage_pool_id]) REFERENCES [dbo].[storage_pool] ([id])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='FK_vds_spm_id_map_vds_id' AND TABLE_NAME='vds_spm_id_map')
BEGIN
ALTER TABLE [dbo].[vds_spm_id_map] ADD CONSTRAINT [FK_vds_spm_id_map_vds_id]
   FOREIGN KEY ([vds_id]) REFERENCES [dbo].[vds_static] ([vds_id])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='vds_groups_vds_static' AND TABLE_NAME='vds_static')
BEGIN
ALTER TABLE [dbo].[vds_static] ADD CONSTRAINT [vds_groups_vds_static]
   FOREIGN KEY ([vds_group_id]) REFERENCES [dbo].[vds_groups] ([vds_group_id])
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='vds_static_vds_statistics' AND TABLE_NAME='vds_statistics')
BEGIN
ALTER TABLE [dbo].[vds_statistics] ADD CONSTRAINT [vds_static_vds_statistics]
   FOREIGN KEY ([vds_id]) REFERENCES [dbo].[vds_static] ([vds_id])
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='FK_vds_tools_version_map_storage_domain_static' AND TABLE_NAME='vds_tools_version_map')
BEGIN
ALTER TABLE [dbo].[vds_tools_version_map] ADD CONSTRAINT [FK_vds_tools_version_map_storage_domain_static]
   FOREIGN KEY ([storage_domain_id]) REFERENCES [dbo].[storage_domain_static] ([id])
     ON DELETE CASCADE	
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='vds_static_vm_dynamic_m' AND TABLE_NAME='vm_dynamic')
BEGIN
ALTER TABLE [dbo].[vm_dynamic] ADD CONSTRAINT [vds_static_vm_dynamic_m]
   FOREIGN KEY ([migrating_to_vds]) REFERENCES [dbo].[vds_static] ([vds_id])
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='vds_static_vm_dynamic_r' AND TABLE_NAME='vm_dynamic')
BEGIN
ALTER TABLE [dbo].[vm_dynamic] ADD CONSTRAINT [vds_static_vm_dynamic_r]
   FOREIGN KEY ([run_on_vds]) REFERENCES [dbo].[vds_static] ([vds_id])
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='vm_static_vm_dynamic' AND TABLE_NAME='vm_dynamic')
BEGIN
ALTER TABLE [dbo].[vm_dynamic] ADD CONSTRAINT [vm_static_vm_dynamic]
   FOREIGN KEY ([vm_guid]) REFERENCES [dbo].[vm_static] ([vm_guid])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='FK_vm_interface_vm_static' AND TABLE_NAME='vm_interface')
BEGIN
ALTER TABLE [dbo].[vm_interface] ADD CONSTRAINT [FK_vm_interface_vm_static]
   FOREIGN KEY ([vm_guid]) REFERENCES [dbo].[vm_static] ([vm_guid])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='vm_guid_pools' AND TABLE_NAME='vm_pool_map')
BEGIN
ALTER TABLE [dbo].[vm_pool_map] ADD CONSTRAINT [vm_guid_pools]
   FOREIGN KEY ([vm_guid]) REFERENCES [dbo].[vm_static] ([vm_guid])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='vm_pools_vm' AND TABLE_NAME='vm_pool_map')
BEGIN
ALTER TABLE [dbo].[vm_pool_map] ADD CONSTRAINT [vm_pools_vm]
   FOREIGN KEY ([vm_pool_id]) REFERENCES [dbo].[vm_pools] ([vm_pool_id])
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='FK_vds_groups_vm_pools' AND TABLE_NAME='vm_pools')
BEGIN
ALTER TABLE [dbo].[vm_pools] ADD CONSTRAINT [FK_vds_groups_vm_pools]
   FOREIGN KEY ([vds_group_id]) REFERENCES [dbo].[vds_groups] ([vds_group_id])
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='FK_vds_static_vm_static' AND TABLE_NAME='vm_static')
BEGIN
ALTER TABLE [dbo].[vm_static] ADD CONSTRAINT [FK_vds_static_vm_static]
   FOREIGN KEY ([dedicated_vm_for_vds]) REFERENCES [dbo].[vds_static] ([vds_id])
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='vds_groups_vm_static' AND TABLE_NAME='vm_static')
BEGIN
ALTER TABLE [dbo].[vm_static] ADD CONSTRAINT [vds_groups_vm_static]
   FOREIGN KEY ([vds_group_id]) REFERENCES [dbo].[vds_groups] ([vds_group_id])
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='vm_templates_vm_static' AND TABLE_NAME='vm_static')
BEGIN
ALTER TABLE [dbo].[vm_static] ADD CONSTRAINT [vm_templates_vm_static]
   FOREIGN KEY ([vmt_guid]) REFERENCES [dbo].[vm_templates] ([vmt_guid])
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='vm_static_vm_statistics' AND TABLE_NAME='vm_statistics')
BEGIN
ALTER TABLE [dbo].[vm_statistics] ADD CONSTRAINT [vm_static_vm_statistics]
   FOREIGN KEY ([vm_guid]) REFERENCES [dbo].[vm_static] ([vm_guid])
     ON DELETE CASCADE
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='image_templates_vm_template_image_map' AND TABLE_NAME='vm_template_image_map')
BEGIN
ALTER TABLE [dbo].[vm_template_image_map] ADD CONSTRAINT [image_templates_vm_template_image_map]
   FOREIGN KEY ([it_guid]) REFERENCES [dbo].[image_templates] ([it_guid])
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='vm_templates_vm_template_image_map' AND TABLE_NAME='vm_template_image_map')
BEGIN
ALTER TABLE [dbo].[vm_template_image_map] ADD CONSTRAINT [vm_templates_vm_template_image_map]
   FOREIGN KEY ([vmt_guid]) REFERENCES [dbo].[vm_templates] ([vmt_guid])
END
go
IF not EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_SCHEMA='dbo' AND CONSTRAINT_NAME='vds_groups_vm_templates' AND TABLE_NAME='vm_templates')
BEGIN
ALTER TABLE [dbo].[vm_templates] ADD CONSTRAINT [vds_groups_vm_templates]
   FOREIGN KEY ([vds_group_id]) REFERENCES [dbo].[vds_groups] ([vds_group_id])
END
go
print 'Recreating Indexes...'
IF INDEXPROPERTY ( OBJECT_ID('vm_interface') , 'IDX_vm_interface_vm_vmt_guid' , 'IndexID' ) IS NULL
BEGIN
CREATE    INDEX [IDX_VM_INTERFACE_VM_VMT_GUID]      ON [VM_INTERFACE]  (VM_GUID,VMT_GUID)
END
go
IF INDEXPROPERTY ( OBJECT_ID('vds_interface') , 'IDX_vds_interface_vds_id' , 'IndexID' ) IS NULL
BEGIN
CREATE    INDEX [IDX_VDS_INTERFACE_VDS_ID]          ON [VDS_INTERFACE] (VDS_ID)
END
go
IF INDEXPROPERTY ( OBJECT_ID('vm_static') , 'IDX_vm_static_vm_name' , 'IndexID' ) IS NULL
BEGIN
CREATE    INDEX [IDX_VM_STATIC_VM_NAME]             ON [VM_STATIC]     (VM_NAME)
END
go
IF INDEXPROPERTY ( OBJECT_ID('audit_log') , 'IDX_audit_log_log_time' , 'IndexID' ) IS NULL
BEGIN
CREATE    INDEX [IDX_AUDIT_LOG_LOG_TIME]            ON [AUDIT_LOG]     (LOG_TIME)
END
go
IF INDEXPROPERTY ( OBJECT_ID('audit_log') , 'IDX_audit_log_user_name' , 'IndexID' ) IS NULL
BEGIN
CREATE    INDEX [IDX_AUDIT_LOG_USER_NAME]           ON [AUDIT_LOG]     (USER_NAME)
END
go
IF INDEXPROPERTY ( OBJECT_ID('audit_log') , 'IDX_audit_log_vm_name' , 'IndexID' ) IS NULL
BEGIN
CREATE    INDEX [IDX_AUDIT_LOG_VM_NAME]             ON [AUDIT_LOG]     (VM_NAME)
END
go
IF INDEXPROPERTY ( OBJECT_ID('audit_log') , 'IDX_audit_log_vm_template_name' , 'IndexID' ) IS NULL
BEGIN
CREATE    INDEX [IDX_AUDIT_LOG_VM_TEMPLATE_NAME]    ON [AUDIT_LOG]     (VM_TEMPLATE_NAME)
END
go
IF INDEXPROPERTY ( OBJECT_ID('audit_log') , 'IDX_audit_log_vds_name' , 'IndexID' ) IS NULL
BEGIN
CREATE    INDEX [IDX_AUDIT_LOG_VDS_NAME]            ON [AUDIT_LOG]     (VDS_NAME)
END
go
IF INDEXPROPERTY ( OBJECT_ID('audit_log') , 'IDX_audit_log_storage_pool_name' , 'IndexID' ) IS NULL
BEGIN
CREATE    INDEX [IDX_AUDIT_LOG_STORAGE_POOL_NAME]   ON [AUDIT_LOG]     (STORAGE_POOL_NAME)
END
go
IF INDEXPROPERTY ( OBJECT_ID('audit_log') , 'IDX_audit_log_storage_domain_name' , 'IndexID' ) IS NULL
BEGIN
CREATE    INDEX [IDX_AUDIT_LOG_STORAGE_DOMAIN_NAME] ON [AUDIT_LOG]     (STORAGE_DOMAIN_NAME)
END
go
IF INDEXPROPERTY ( OBJECT_ID('vm_dynamic') , 'IDX_vm_dynamic_run_on_vds' , 'IndexID' ) IS NULL
BEGIN
CREATE    INDEX [IDX_VM_DYNAMIC_RUN_ON_VDS]         ON [VM_DYNAMIC]    (RUN_ON_VDS)
END
go
IF INDEXPROPERTY ( OBJECT_ID('vdc_options') , 'IX_vdc_options' , 'IndexID' ) IS NULL
BEGIN
CREATE    INDEX [IX_VDC_OPTIONS]                    ON [VDC_OPTIONS]   (OPTION_NAME)
END
go
