PRINT 'Processing user_sp.sql'

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetTimeLeasedUsersVmsByGroupIdAndPoolId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetTimeLeasedUsersVmsByGroupIdAndPoolId] AS RETURN')
END


GO
ALTER PROCEDURE [dbo].[GetTimeLeasedUsersVmsByGroupIdAndPoolId] 
 @groupId uniqueidentifier,  
 @vm_pool_id uniqueidentifier  
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
        select * from tags_vm_map
        inner join vm_pool_map on vm_pool_map.vm_guid = tags_vm_map.vm_id
        inner join tags_permissions_map on tags_permissions_map.tag_id = tags_vm_map.tag_id
        inner join [permissions] on [permissions].id = tags_permissions_map.permission_id 
        where dbo.[permissions].ad_element_id
		in 
		(select users.user_id from users 
				where (dbo.users.groups LIKE '%' + 
				(select ad_groups.name from ad_groups where ad_groups.id = @groupId)
				  +'%'))
		and 
		vm_pool_map.vm_pool_id = @vm_pool_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END
GO
----------------------------------------------------------------
-- [dbo].[users] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'InsertUser')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[InsertUser] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[InsertUser]
    @department nvarchar(255) = NULL,
	@desktop_device nvarchar(255) = NULL,
	@domain nvarchar(255),
	@email nvarchar(255) = NULL,
	@groups nvarchar(max),
	@name nvarchar(255) = NULL,
	@note nvarchar(255) = NULL,
	@role nvarchar(255) = NULL,
	@status int,
	@surname nvarchar(255) = NULL,
	@user_icon_path nvarchar(255) = NULL,
	@user_id uniqueidentifier,
    @session_count int,
	@username nvarchar(255)
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[users] ([department], [desktop_device], [domain], [email], [groups], [name], [note], [role], [status], [surname], [user_icon_path], [user_id], [session_count], [username])
	VALUES (@department, @desktop_device, @domain, @email, @groups, @name, @note, @role, @status, @surname, @user_icon_path, @user_id, @session_count, @username)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'UpdateUser')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[UpdateUser] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[UpdateUser]
    @department nvarchar(255) = NULL,
	@desktop_device nvarchar(255) = NULL,
	@domain nvarchar(255),
	@email nvarchar(255) = NULL,
	@groups nvarchar(max),
	@name nvarchar(255) = NULL,
	@note nvarchar(255) = NULL,
	@role nvarchar(255) = NULL,
	@status int,
	@surname nvarchar(255) = NULL,
	@user_icon_path nvarchar(255) = NULL,
	@user_id uniqueidentifier,
    @session_count int,
	@username nvarchar(255),
	@last_admin_check_status Bit
	
AS
BEGIN

	--The [dbo].[users] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[users] 
	SET [department] = @department, [desktop_device] = @desktop_device, [domain] = @domain, [email] = @email, [groups] = @groups, [name] = @name, [note] = @note, [role] = @role, [status] = @status, [surname] = @surname, [user_icon_path] = @user_icon_path, [username] = @username, [session_count] = @session_count, [last_admin_check_status] = @last_admin_check_status
	WHERE [user_id]=@user_id

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Update statement affected 0 rows.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'DeleteUser')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[DeleteUser] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[DeleteUser]
	 @user_id uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
			declare @val uniqueidentifier
			-- Get (and keep) a shared lock with "right to upgrade to exclusive"
			-- in order to force locking parent before children 
			SELECT @val = [user_id]
			FROM [dbo].[users] WITH (UPDLOCK)
			WHERE [user_id]=@user_id

			DELETE FROM [dbo].[tags_user_map]
			WHERE [user_id] = @user_id

			DELETE FROM [dbo].[users]
			WHERE [user_id]=@user_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromUsers')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromUsers] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromUsers]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[users].[department] AS 'department',
		[users].[desktop_device] AS 'desktop_device',
		[users].[domain] AS 'domain',
		[users].[email] AS 'email',
		[users].[groups] AS 'groups',
		[users].[name] AS 'name',
		[users].[note] AS 'note',
		[users].[role] AS 'role',
		[users].[status] AS 'status',
		[users].[surname] AS 'surname',
		[users].[user_icon_path] AS 'user_icon_path',
		[users].[user_id] AS 'user_id',
		[users].[session_count] as 'session_count',
		[users].[username] AS 'username',
		[users].[last_admin_check_status] AS 'last_admin_check_status',
		null as 'vm_pool_id',
		null as 'vm_pool_name',
		null as 'from',
		null as 'to'
	FROM [dbo].[users] [users]
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetUserByUserId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetUserByUserId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetUserByUserId] 
	@user_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[users].[department] AS 'department',
		[users].[desktop_device] AS 'desktop_device',
		[users].[domain] AS 'domain',
		[users].[email] AS 'email',
		[users].[groups] AS 'groups',
		[users].[name] AS 'name',
		[users].[note] AS 'note',
		[users].[role] AS 'role',
		[users].[status] AS 'status',
		[users].[surname] AS 'surname',
		[users].[user_icon_path] AS 'user_icon_path',
		[users].[user_id] AS 'user_id',
		[users].[session_count] as 'session_count',
		[users].[username] AS 'username',
		[users].[last_admin_check_status] AS 'last_admin_check_status',
		null as 'vm_pool_id',
		null as 'vm_pool_name',
		null as 'from',
		null as 'to'
		FROM [dbo].[users] [users]
		WHERE [user_id]=@user_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetUserByUserName')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetUserByUserName] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetUserByUserName] 
	@username varchar(255)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[users].[department] AS 'department',
		[users].[desktop_device] AS 'desktop_device',
		[users].[domain] AS 'domain',
		[users].[email] AS 'email',
		[users].[groups] AS 'groups',
		[users].[name] AS 'name',
		[users].[note] AS 'note',
		[users].[role] AS 'role',
		[users].[status] AS 'status',
		[users].[surname] AS 'surname',
		[users].[user_icon_path] AS 'user_icon_path',
		[users].[user_id] AS 'user_id',
		[users].[session_count] as 'session_count',
		[users].[username] AS 'username',
		[users].[last_admin_check_status] AS 'last_admin_check_status',
		null as 'vm_pool_id',
		null as 'vm_pool_name',
		null as 'from',
		null as 'to'
		FROM [dbo].[users] [users]
		WHERE [username]=@username
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetUsersByVmGuid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetUsersByVmGuid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetUsersByVmGuid] 
	@vm_guid uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
        SELECT
		[users].[department] AS 'department',
		[users].[desktop_device] AS 'desktop_device',
		[users].[domain] AS 'domain',
		[users].[email] AS 'email',
		[users].[groups] AS 'groups',
		[users].[name] AS 'name',
		[users].[note] AS 'note',
		[users].[role] AS 'role',
		[users].[status] AS 'status',
		[users].[surname] AS 'surname',
		[users].[user_icon_path] AS 'user_icon_path',
		[users].[user_id] AS 'user_id',
		[users].[session_count] as 'session_count',
		[users].[username] AS 'username',
		[users].[last_admin_check_status] AS 'last_admin_check_status',
		null as 'vm_pool_id',
		null as 'vm_pool_name',
		null as 'from',
		null as 'to'
		FROM [dbo].[users] [users]
        inner join [permissions] 
		on users.[user_id] = [permissions].ad_element_id
        WHERE permissions.object_type_id = 2 
		and	permissions.object_id = @vm_guid
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO


----------------------------------------------------------------
-- [dbo].[user_sessions] Table
----------------------------------------------------------------
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Insertuser_sessions')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Insertuser_sessions] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Insertuser_sessions]
    @browser nchar(10) = NULL,
	@client_type nchar(10) = NULL,
	@login_time datetime = NULL,
	@os nchar(10) = NULL,
	@session_id nchar(32),
	@user_id uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
		
		if (not exists (select [session_id] from [dbo].[user_sessions] 
             where [session_id] = @session_id and [user_id] = @user_id))
		BEGIN
				INSERT INTO [dbo].[user_sessions] ([browser], [client_type], [login_time], [os], [session_id], [user_id])
				VALUES (@browser, @client_type, @login_time, @os, @session_id, @user_id)
				
				UPDATE [dbo].[users] 
				SET [session_count] = [session_count] + 1
				WHERE
					[user_id] = @user_id
		END
			    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deleteuser_sessions')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deleteuser_sessions] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deleteuser_sessions]
	 @session_id nchar(32),
	@user_id uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
			DELETE FROM [dbo].[user_sessions]
			WHERE [session_id]=@session_id AND [user_id]=@user_id
			
			if (@@rowcount > 0)
			BEGIN
				declare @counter int
				select @counter = [session_count]
				from [dbo].[users] 
				WHERE
					[user_id]=@user_id
					
				if (@counter > 0)
				BEGIN			
					UPDATE [dbo].[users] 
					SET [session_count] = [session_count] - 1
					WHERE
						[user_id]=@user_id
				END
			END
	END TRY
	
	BEGIN CATCH
		EXEC RethrowError;

	END CATCH
    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deleteuser_sessionsByuser_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deleteuser_sessionsByuser_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deleteuser_sessionsByuser_id]
	 @user_id uniqueidentifier
	
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
			DELETE FROM [dbo].[user_sessions]
			WHERE [user_id]=@user_id
			
			UPDATE [dbo].[users] 
			SET [session_count] = 0
			WHERE
				[user_id]=@user_id
	END TRY
	
	BEGIN CATCH
		EXEC RethrowError;

	END CATCH
    
    SET NOCOUNT OFF
END

GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromuser_sessions')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromuser_sessions] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromuser_sessions]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[user_sessions].[browser] AS 'browser',
		[user_sessions].[client_type] AS 'client_type',
		[user_sessions].[login_time] AS 'login_time',
		[user_sessions].[os] AS 'os',
		[user_sessions].[session_id] AS 'session_id',
		[user_sessions].[user_id] AS 'user_id'
	FROM [dbo].[user_sessions] [user_sessions]
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getuser_sessionsBysession_idAndByuser_id')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getuser_sessionsBysession_idAndByuser_id] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getuser_sessionsBysession_idAndByuser_id] 
	@session_id nchar(32),
	@user_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[user_sessions].[browser] AS 'browser',
		[user_sessions].[client_type] AS 'client_type',
		[user_sessions].[login_time] AS 'login_time',
		[user_sessions].[os] AS 'os',
		[user_sessions].[session_id] AS 'session_id',
		[user_sessions].[user_id] AS 'user_id'
		FROM [dbo].[user_sessions] [user_sessions]
		WHERE [session_id]=@session_id AND [user_id]=@user_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'DeleteAlluser_sessions')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[DeleteAlluser_sessions] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[DeleteAlluser_sessions]
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
			TRUNCATE TABLE [dbo].[user_sessions]

			UPDATE [dbo].[users] 
			SET [session_count] = 0
			WHERE
				[session_count] > 0
			
	END TRY
	
	BEGIN CATCH
		EXEC RethrowError;

	END CATCH
    
    SET NOCOUNT OFF
END

GO



IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' and NAME = 'UpdateLastAdminCheckStatus')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[UpdateLastAdminCheckStatus] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[UpdateLastAdminCheckStatus]
	@userIds nvarchar(max)
AS
BEGIN
	SET NOCOUNT ON	
	-- get users and its groups
	-- get their permission based on ad_element_id.
	-- if one permissions role's type is ADMIN(1) then set the user last_admin_check_status to 1
declare @id uniqueidentifier
declare @tempId nvarchar(max)
declare myCursor cursor for select id from fnSplitter(@userIds)

OPEN myCursor
FETCH next from myCursor into @tempId
WHILE @@FETCH_STATUS = 0   
BEGIN
	set @id = CAST (@tempId AS uniqueidentifier)
	DECLARE @result int
	SELECT @result = count(*) from users where user_id in (
			select ad_element_id as user_id from permissions,roles 
			where permissions.role_id = roles.id
			and ad_element_id in(
				(select id from ad_groups,users where users.user_id = @id 
				and ad_groups.name in (select id from fnSplitter(users.groups))
				union 
				select @id))
			and (roles.role_type = 1 or permissions.role_id = '00000000-0000-0000-0000-000000000001')
	)  
	update users set last_admin_check_status = 
	case
		when @result = 0 then 0
		else 1
	end
	where user_id = @id
FETCH next from myCursor into @tempId
END
CLOSE myCursor  
DEALLOCATE myCursor  

END

GO