using System;
using System.Collections.Generic;
using System.ServiceModel;
using VdcCommon.Errors;
using VdcCommon.Interfaces;
using VdcCommon.Users;
using VdcCommon.VdcAction;
using VdcCommon.VdcQueries;
using VdcCommon.BusinessEntities;
using VdcUtils;
using VdcCommon.AsyncTasks;

namespace VdcCommon.Interfaces
{
    public class BaseHandler : IObjectDescriptorContainer
    {
		/// <summary>
		/// Returns a boolean indication regarding whether it is allowed to update 
		/// a specified field of a specified object in a specified status.
		/// Example for overriding this function:
		/// 
		/// public override bool CanUpdateField(object obj, string fieldName, Enum status)
		/// {
		///	   VDS vds = obj as VDS;
		///    VDSStatus vdsStatus = (VDSStatus)status;
		///    switch (vdsStatus)
		///    {
		///		  case VDSStatus.Maintenance:
		///			...
		///         ...
		///         ...
		///       default:
		///			return base.CanUpdateField(....)
		///		}
		///	}
		/// </summary>
		/// <param name="obj">The object to update field in.</param>
		/// <param name="fieldName">The field to update.</param>
		/// <param name="status">The status to consider.</param>
		/// <returns>True if fieldName is allowed for update, false otherwise.</returns>
        public virtual bool CanUpdateField(object obj,string fieldName, Enum status)
        {
            return true;
        }
    }
    [ServiceContract]
    public interface IImagesHandler
    {
        [OperationContract(IsInitiating = false)]
        [FaultContract(typeof(VdcFault))]
        void MigrateIrsSnapshotsToVdc();
    }
    [ServiceContract]
    public interface IUserHandler
    {
        [OperationContract(IsInitiating = true)]
        [FaultContract(typeof(VdcFault))]
		VdcReturnValueBase Login(LoginUserParameters parameters);
        [OperationContract(IsInitiating = false,IsTerminating = true)]
        [FaultContract(typeof(VdcFault))]
        VdcReturnValueBase Logoff(LogoutUserParameters parameters);
    }
    [ServiceContract]
	public interface ITagsHandler
	{
        //[OperationContract(IsInitiating = false)]
        //[FaultContract(typeof(VdcFault))]
        //void MoveTag(int tagId, int newParent);
		tags GetTagByTagName(string tagName);
		string GetTagIdAndChildrenIds(int tagId);
        string GetTagIdsAndChildrenIdsByRegExp(string tagNameRegExp);
	}
    [ServiceContract(SessionMode = SessionMode.Required
        //JWS ,CallbackContract = typeof(IBackendCallBack)
    )]
    [ServiceKnownType(typeof(VdcUser))]
    [ServiceKnownType(typeof(VM))]
    [ServiceKnownType(typeof(AuditLog))]
    [ServiceKnownType(typeof(VDS))]
    [ServiceKnownType(typeof(VmTemplate))]
    [ServiceKnownType(typeof(AdUser))]
    [ServiceKnownType(typeof(ad_groups))]
    [ServiceKnownType(typeof(DbUser))]
    [ServiceKnownType(typeof(vm_pools))]
    [ServiceKnownType(typeof(VDSGroup))]
    [ServiceKnownType(typeof(storage_pool))]
    [ServiceKnownType(typeof(storage_domains))]
    [ServiceKnownType(typeof(ListIVdcQueryableUpdatedData))]
    [ServiceKnownType(typeof(network))]
    [ServiceKnownType(typeof(Interface))]
    [ServiceKnownType(typeof(DiskImage))]
    [ServiceKnownType(typeof(event_subscriber))]
    [ServiceKnownType(typeof(bookmarks))]
    [ServiceKnownType(typeof(custom_actions))]
    [ServiceKnownType(typeof(roles))]
    public interface IBackend : IUserHandler, ISession
    {
        [OperationContract(IsInitiating = false)]
        [FaultContract(typeof(VdcFault))]
        void Initialize();
        [OperationContract(IsInitiating = false)]
        [FaultContract(typeof(VdcFault))]
        VdcReturnValueBase RunAction(VdcActionType actionType, VdcActionParametersBase parameters);
        [FaultContract(typeof(VdcFault))]
        VdcReturnValueBase EndAction(VdcActionType actionType, VdcActionParametersBase parameters);

        [OperationContract(IsInitiating = false)]
        [FaultContract(typeof (VdcFault))]
        VdcQueryReturnValue RunQuery(VdcQueryType actionType, VdcQueryParametersBase parameters);
        [OperationContract(IsInitiating = false,IsOneWay = true)]
        void RunAsyncQuery(VdcQueryType actionType, VdcQueryParametersBase parameters);
        [OperationContract(IsInitiating = false)]
        [FaultContract(typeof(VdcFault))]
        List<VdcReturnValueBase> RunMultipleActions(VdcActionType actionType,
                                                    List<VdcActionParametersBase> parameters);

        [OperationContract(IsInitiating = false)]
        [FaultContract(typeof(VdcFault))]
        List<KeyValuePair<Guid, List<ListIVdcQueryableUpdatedData>>> GetAsyncQueryResults();
    }
    [ServiceContract(SessionMode = SessionMode.Required
        //JWS, CallbackContract = typeof(IBackendCallBack)
    )]
    [ServiceKnownType(typeof(VdcUser))]
    public interface IUserBackend : ISession
    {
        [OperationContract]
        VdcReturnValueBase RunUserAction(VdcActionType actionType, VdcActionParametersBase parameters);
        [OperationContract]
        VdcQueryReturnValue RunUserQuery(VdcQueryType actionType, VdcQueryParametersBase parameters);
        [OperationContract]
        List<VdcReturnValueBase> RunUserMultipleActions(VdcActionType actionType,
                                                    List<VdcActionParametersBase> parameters);
    }
    [ServiceContract(SessionMode = SessionMode.Required
       //JWS, CallbackContract = typeof(IBackendCallBack)
   )]
    [ServiceKnownType(typeof(VdcUser))]
    public interface IAutoBackend : IUserHandler, ISession
    {
        [OperationContract(IsInitiating = false)]
        VdcReturnValueBase RunAutoAction(VdcActionType actionType, VdcActionParametersBase parameters);
        [OperationContract(IsInitiating = false)]
        VdcQueryReturnValue RunAutoQuery(VdcQueryType actionType, VdcQueryParametersBase parameters);
    }
    
    [ServiceContract]
    public interface IPublicServices
    {
		[OperationContract]
		[FaultContract(typeof(VdcFault))]
		VdcQueryReturnValue RunPublicQuery(VdcQueryType queryType, VdcQueryParametersBase parameters);
	}
}
