using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using org.ovirt.engine.ui.uicommon.dataprovider;
using org.ovirt.engine.ui.uicompat;
using org.ovirt.engine.ui.uicommon.validation;
using VdcCommon.BusinessEntities;
using System.Collections;
using VdcFrontend;

namespace org.ovirt.engine.ui.uicommon.models.vms
{
	public class VmModel : Model
	{
		#region Properties

		public virtual bool IsNew { get; set; }

		public VmType VmType { get; set; }


		bool isWindowsOS;
		public bool IsWindowsOS
		{
			get { return isWindowsOS; }
			set
			{
				if (isWindowsOS != value)
				{
					isWindowsOS = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsWindowsOS"));
				}
			}
		}


		bool isLinux_Unassign_UnknownOS;
		public bool IsLinux_Unassign_UnknownOS
		{
			get { return isLinux_Unassign_UnknownOS; }
			set
			{
				if (isLinux_Unassign_UnknownOS != value)
				{
					isLinux_Unassign_UnknownOS = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsLinux_Unassign_UnknownOS"));
				}
			}
		}

		bool isBlankTemplate;
		public bool IsBlankTemplate
		{
			get { return isBlankTemplate; }
			set
			{
				if (isBlankTemplate != value)
				{
					isBlankTemplate = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsBlankTemplate"));
				}
			}
		}

		private string cpuNotification;
		public string CPUNotification
		{
			get { return cpuNotification; }
			set
			{
				if (cpuNotification != value)
				{
					cpuNotification = value;
					OnPropertyChanged(new PropertyChangedEventArgs("CPUNotification"));
				}
			}
		}
		public bool isCPUsAmountValid;
		public bool IsCPUsAmountValid
		{
			get { return isCPUsAmountValid; }
			set
			{
				if (isCPUsAmountValid != value)
				{
					isCPUsAmountValid = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsCPUsAmountValid"));
				}
			}
		}

		bool isGeneralTabValid;
		public bool IsGeneralTabValid
		{
			get { return isGeneralTabValid; }
			set
			{
				if (isGeneralTabValid != value)
				{
					isGeneralTabValid = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsGeneralTabValid"));
				}
			}
		}

		bool isFirstRunTabValid;
		public bool IsFirstRunTabValid
		{
			get { return isFirstRunTabValid; }
			set
			{
				if (isFirstRunTabValid != value)
				{
					isFirstRunTabValid = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsFirstRunTabValid"));
				}
			}
		}

		bool isDisplayTabValid;
		public bool IsDisplayTabValid
		{
			get { return isDisplayTabValid; }
			set
			{
				if (isDisplayTabValid != value)
				{
					isDisplayTabValid = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsDisplayTabValid"));
				}
			}
		}

		bool isAllocationTabValid;
		public bool IsAllocationTabValid
		{
			get { return isAllocationTabValid; }
			set
			{
				if (isAllocationTabValid != value)
				{
					isAllocationTabValid = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsAllocationTabValid"));
				}
			}
		}

		bool isHostTabValid;
		public bool IsHostTabValid
		{
			get { return isHostTabValid; }
			set
			{
				if (isHostTabValid != value)
				{
					isHostTabValid = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsHostTabValid"));
				}
			}
		}

		bool isBootSequenceTabValid;
		public bool IsBootSequenceTabValid
		{
			get { return isBootSequenceTabValid; }
			set
			{
				if (isBootSequenceTabValid != value)
				{
					isBootSequenceTabValid = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsBootSequenceTabValid"));
				}
			}
		}

		bool isCustomPropertiesTabValid;
		public bool IsCustomPropertiesTabValid
		{
			get { return isCustomPropertiesTabValid; }
			set
			{
				if (isCustomPropertiesTabValid != value)
				{
					isCustomPropertiesTabValid = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsCustomPropertiesTabValid"));
				}
			}
		}

		public ListModel DataCenter { get; private set; }
		public ListModel StorageDomain { get; private set; }
		public ListModel Template { get; private set; }
		public EntityModel Name { get; private set; }
		public ListModel OSType { get; private set; }
		public ListModel NumOfMonitors { get; private set; }
		public EntityModel Description { get; private set; }
		public ListModel Domain { get; private set; }
		public EntityModel MemSize { get; private set; }
		public EntityModel MinAllocatedMemory { get; private set; }
		public ListModel Cluster { get; private set; }
		public ListModel UsbPolicy { get; private set; }
		public ListModel TimeZone { get; private set; }

		public RangeEntityModel NumOfSockets { get; private set; }
		public RangeEntityModel TotalCPUCores { get; private set; }

		public ListModel DefaultHost { get; private set; }
		public EntityModel IsStateless { get; private set; }
		public ListModel DisplayProtocol { get; private set; }
		public ListModel Provisioning { get; private set; }
		public ListModel Priority { get; private set; }
		public EntityModel IsHighlyAvailable { get; private set; }
		public ListModel FirstBootDevice { get; private set; }
		public ListModel SecondBootDevice { get; private set; }
		public ListModel CdImage { get; private set; }

		public EntityModel Initrd_path { get; private set; }
		public EntityModel Kernel_path { get; private set; }
		public EntityModel Kernel_parameters { get; private set; }

		public EntityModel CustomProperties { get; private set; }
		public List<string> CustomPropertiesKeysList { get; set; }

		public EntityModel IsAutoAssign { get; set; }
		public EntityModel RunVMOnSpecificHost { get; set; }
		public EntityModel DontMigrateVM { get; set; }

		public EntityModel IsTemplatePublic { get; private set; }

		private IList<DiskModel> disks;
		public IList<DiskModel> Disks
		{
			get { return disks; }
			set
			{
				if (disks != value)
				{
					disks = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Disks"));
				}
			}
		}

		private bool isDisksAvailable;
		public bool IsDisksAvailable
		{
			get { return isDisksAvailable; }
			set
			{
				if (isDisksAvailable != value)
				{
					isDisksAvailable = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsDisksAvailable"));
				}
			}
		}

		private bool isCustomPropertiesAvailable;
		public bool IsCustomPropertiesAvailable
		{
			get { return isCustomPropertiesAvailable; }
			set
			{
				if (isCustomPropertiesAvailable != value)
				{
					isCustomPropertiesAvailable = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsCustomPropertiesAvailable"));

					if (value == false)
					{
						CustomProperties.Entity = String.Empty;
					}
				}
			}
		}

		private bool isHostAvailable;
		public bool IsHostAvailable
		{
			get { return isHostAvailable; }
			set
			{
				if (isHostAvailable != value)
				{
					isHostAvailable = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsHostAvailable"));
				}
			}
		}

		#endregion

		private int _minMemSize = 1;
		private int _maxMemSize32 = 262144;
		private int _maxMemSize64 = 262144;

		#region Const

		public const int WINDOWS_VM_NAME_MAX_LIMIT = 15;
		public const int NON_WINDOWS_VM_NAME_MAX_LIMIT = 64;

		#endregion Const

		public VmModel()
		{
			DataCenter = new ListModel();
			//DataCenter.ValueChanged += DataCenter_ValueChanged;
			DataCenter.SelectedItemChangedEvent.addListener(this);

			StorageDomain = new ListModel();

			Template = new ListModel();
			//Template.ValueChanged += Template_ValueChanged;
			Template.SelectedItemChangedEvent.addListener(this);

			Name = new EntityModel();
			NumOfMonitors = new ListModel();
			Description = new EntityModel();
			MemSize = new EntityModel { Entity = 256 };
			MemSize.EntityChangedEvent.addListener(this);
			MinAllocatedMemory = new EntityModel { Entity = 256 };

			Cluster = new ListModel();
			//Cluster.ValueChanged += Cluster_ValueChanged;
			Cluster.SelectedItemChangedEvent.addListener(this);

			UsbPolicy = new ListModel { Items = DataProvider.GetUsbPolicyList() };
			TimeZone = new ListModel { Items = DataProvider.GetTimeZoneList().entrySet() };
			Domain = new ListModel();
			UpdateDomain();

			NumOfSockets = new RangeEntityModel();
			//NumOfSockets.ValueChanged += NumOfSockets_ValueChanged;
			NumOfSockets.EntityChangedEvent.addListener(this);

			TotalCPUCores = new RangeEntityModel();

			DefaultHost = new ListModel();
			//DefaultHost.ValueChanged += DefaultHost_ValueChanged;
			DefaultHost.SelectedItemChangedEvent.addListener(this);

			IsAutoAssign = new EntityModel();
			IsAutoAssign.Entity = true;
			IsAutoAssign.EntityChangedEvent.addListener(this);

			IsStateless = new EntityModel { Entity = false };
			CdImage = new ListModel();
			CdImage.IsChangable = false;
			IsHighlyAvailable = new EntityModel { Entity = false };

			RunVMOnSpecificHost = new EntityModel { Entity = false };
			RunVMOnSpecificHost.IsChangable = false;
			RunVMOnSpecificHost.EntityChangedEvent.addListener(this);
			DontMigrateVM = new EntityModel { Entity = false };

			IsTemplatePublic = new EntityModel { Entity = true };

			Kernel_parameters = new EntityModel();
			Kernel_path = new EntityModel();
			Initrd_path = new EntityModel();

			CustomProperties = new EntityModel();

			OSType = new ListModel { Items = DataProvider.GetOSList() };
			OSType.SelectedItemChangedEvent.addListener(this);
			OSType.SelectedItem = VmOsType.Unassigned;



			//Display protocols.
			DisplayProtocol = new ListModel();

			List<EntityModel> displayProtocolOptions = new List<EntityModel>();

			EntityModel spiceProtocol = new EntityModel();
			spiceProtocol.Title = "Spice";
			spiceProtocol.Entity = DisplayType.qxl;

			EntityModel vncProtocol = new EntityModel();
			vncProtocol.Title = "VNC";
			vncProtocol.Entity = DisplayType.vnc;

			displayProtocolOptions.Add(spiceProtocol);
			displayProtocolOptions.Add(vncProtocol);
			DisplayProtocol.Items = displayProtocolOptions;

			//DisplayProtocol.ValueChanged += DisplayProtocol_ValueChanged;
			DisplayProtocol.SelectedItemChangedEvent.addListener(this);
			if (VmType == VmType.Desktop)
			{
				DisplayProtocol.SelectedItem = spiceProtocol;
			}

			//Boot devices.
			EntityModel hardDiskOption = new EntityModel { Title = "Hard Disk", Entity = BootSequence.C };

			FirstBootDevice = new ListModel();
			//FirstBootDevice.ValueChanged += FirstBootDevice_ValueChanged;
			FirstBootDevice.SelectedItemChangedEvent.addListener(this);

			SecondBootDevice = new ListModel();


			List<EntityModel> firstBootDeviceItems = new List<EntityModel>();
			firstBootDeviceItems.Add(hardDiskOption);
			firstBootDeviceItems.Add(
				new EntityModel
				{
					Title = "CD-ROM",
					Entity = BootSequence.D
				});
			firstBootDeviceItems.Add(
				new EntityModel
				{
					Title = "Network (PXE)",
					Entity = BootSequence.N
				});
			FirstBootDevice.Items = firstBootDeviceItems;
			FirstBootDevice.SelectedItem = hardDiskOption;


			//Provisioning
			List<EntityModel> provisioningItems = new List<EntityModel>();
			provisioningItems.Add(
				new EntityModel
				{
					Title = "Thin",
					Entity = false
				});
			provisioningItems.Add(
				new EntityModel
				{
					Title = "Clone",
					Entity = true
				});
			Provisioning =
				new ListModel
				{
					Items = provisioningItems,
					SelectedItem = false
				};

			IsGeneralTabValid = IsFirstRunTabValid = IsDisplayTabValid = IsAllocationTabValid = IsBootSequenceTabValid = IsCustomPropertiesTabValid = IsHostTabValid = true;
			//Provisioning.ValueChanged += Provisioning_ValueChanged;
			Provisioning.SelectedItemChangedEvent.addListener(this);


			//Priority
			int maxPriority = DataProvider.GetMaxVmPriority();
			EntityModel lowOption = new EntityModel() { Title = "Low", Entity = 1 };

			List<EntityModel> priorityItems = new List<EntityModel>();
			priorityItems.Add(lowOption);
			priorityItems.Add(
				new EntityModel
				{
					Title = "Medium",
					Entity = maxPriority / 2
				});
			priorityItems.Add(
				new EntityModel
				{
					Title = "High",
					Entity = maxPriority
				});

			Priority =
				new ListModel
				{
					Items = priorityItems,
					SelectedItem = lowOption
				};


			//Populate a list of data centers.
			//DataCenter.Options = DataProvider.GetStoragePoolList().Where(a => a.status == StoragePoolStatus.Up);
			List<storage_pool> list = new List<storage_pool>();
			foreach (storage_pool a in DataProvider.GetDataCenterList())
			{
				if (a.status == StoragePoolStatus.Up)
				{
					list.Add(a);
				}
			}
			DataCenter.Items = list;


			_minMemSize = DataProvider.GetMinimalVmMemSize();

			SetGUIByVMType();
		}

		public override void eventRaised(Event ev, object sender, EventArgs args)
		{
			base.eventRaised(ev, sender, args);

			if (ev.Equals(EntityModel.EntityChangedEventDefinition))
			{
				if (sender == NumOfSockets)
				{
					NumOfSockets_EntityChanged();
				}
				else if (sender == IsAutoAssign)
				{
					if ((bool)IsAutoAssign.Entity == true)
					{
						RunVMOnSpecificHost.Entity = false;
						RunVMOnSpecificHost.IsChangable = false;
					}
					else
					{
						RunVMOnSpecificHost.IsChangable = true;
					}
				}
				else if (sender == RunVMOnSpecificHost)
				{
					if ((bool)RunVMOnSpecificHost.Entity == true)
					{
						DontMigrateVM.Entity = true;
						DontMigrateVM.IsChangable = false;
					}
					else
					{
						//DontMigrateVM.Entity = false;
						DontMigrateVM.IsChangable = true;
					}
				}
				else if (sender == MemSize)
				{
					UpdateMinAllocatedMemory(true);
				}
			}

			if (ev.Equals(ListModel.SelectedItemChangedEventDefinition))
			{
				if (sender == DataCenter)
				{
					DataCenter_SelectedItemChanged();
				}
				else if (sender == Template)
				{
					Template_SelectedItemChanged();
				}
				else if (sender == Cluster)
				{
					Cluster_SelectedItemChanged();
				}
				else if (sender == DefaultHost)
				{
					DefaultHost_SelectedItemChanged();
				}
				else if (sender == OSType)
				{
					OSType_SelectedItemChanged();
				}
				else if (sender == DisplayProtocol)
				{
					DisplayProtocol_SelectedItemChanged();
				}
				else if (sender == FirstBootDevice)
				{
					FirstBootDevice_SelectedItemChanged();
				}
				else if (sender == Provisioning)
				{
					Provisioning_SelectedItemChanged();
				}
			}
		}

		void DefaultHost_SelectedItemChanged()
		{
			UpdateCDImages();
		}

		void NumOfSockets_EntityChanged()
		{
			UpdateTotalCpus();
		}

		private void UpdateDomain()
		{
			AsyncDataProvider.GetDomainList(new AsyncQuery(this,
				(target, returnValue) =>
				{
					VmModel vmModel = (VmModel)target;
					IList<string> domains = (IList<string>)returnValue;

					// Get last selected domain
					string oldDomain = (string)vmModel.Domain.SelectedItem;

					if (oldDomain != null && !oldDomain.Equals(String.Empty) && !domains.Contains(oldDomain))
					{
						domains.Insert(0, oldDomain);
					}

					vmModel.Domain.Items = domains;
					vmModel.Domain.SelectedItem = oldDomain ?? Linq.FirstOrDefault(domains);
				}), true
			);
		}

		private void UpdateNumOfSockets()
		{
			VDSGroup cluster = (VDSGroup)Cluster.SelectedItem;
			if (cluster == null)
			{
				return;
			}

			string version = cluster.compatibility_version.ToString();

			int maxNumOfSockets = DataProvider.GetMaxNumOfVmSockets(version);

			NumOfSockets.Min = 1;
			NumOfSockets.Interval = 1;
			NumOfSockets.Max = maxNumOfSockets;
		}

		private void UpdateMinAllocatedMemory(bool forceUpdate)
		{
			VDSGroup cluster = (VDSGroup)Cluster.SelectedItem;
			if (cluster == null)
			{
				return;
			}

			double overCommitFactor = 100.0 / cluster.max_vds_memory_over_commit;
			if (IsNew || forceUpdate)
			{
				MinAllocatedMemory.Entity = (int) ((int) MemSize.Entity*overCommitFactor);
			}
		}

		private void UpdateTotalCpus()
		{
			VDSGroup cluster = (VDSGroup)Cluster.SelectedItem;
			if (cluster == null)
			{
				return;
			}

			string version = cluster.compatibility_version.ToString();

			int maxCpus = DataProvider.GetMaxNumOfVmCpus(version);
			int maxCpusPerSocket = DataProvider.GetMaxNumOfCPUsPerSocket(version);
			int numOfSockets = Convert.ToInt32(NumOfSockets.Entity.ToString());


			int totalCPUCores = TotalCPUCores.Entity != null
				? Convert.ToInt32(TotalCPUCores.Entity.ToString())
				: 0;

			int realMaxCpus = maxCpus < numOfSockets * maxCpusPerSocket ? maxCpus : numOfSockets * maxCpusPerSocket;
			TotalCPUCores.Min = numOfSockets;
			TotalCPUCores.Max = realMaxCpus - (realMaxCpus % numOfSockets);
			TotalCPUCores.Interval = numOfSockets;
			//update value if needed
			//if the slider in the range but not on tick update it to lowest tick
			if ((totalCPUCores % numOfSockets != 0) && totalCPUCores < TotalCPUCores.Max && totalCPUCores > TotalCPUCores.Min)
			{
				TotalCPUCores.Entity = totalCPUCores - (totalCPUCores % numOfSockets);
			}
			//if the value is lower than range update it to min
			else if (totalCPUCores < TotalCPUCores.Min)
			{
				TotalCPUCores.Entity = Convert.ToInt32(TotalCPUCores.Min.ToString());
			}
			//if the value is higher than range update it to max
			else if (totalCPUCores > TotalCPUCores.Max)
			{
				TotalCPUCores.Entity = Convert.ToInt32(TotalCPUCores.Max.ToString());
			}
		}


		void Provisioning_SelectedItemChanged()
		{
			UpdateIsDisksAvailable();
			UpdateStorageDomains();
		}

		void DataCenter_SelectedItemChanged()
		{
			storage_pool dataCenter = DataCenter.SelectedItem as storage_pool;

			List<VDSGroup> clusters = dataCenter != null
							? DataProvider.GetClusterList(dataCenter.Id)
							: DataProvider.GetClusterList();

			Cluster.Items = clusters;
			//Cluster.Value = clusters.FirstOrDefault();
			Cluster.SelectedItem = Linq.FirstOrDefault(clusters);

			if (dataCenter != null)
			{
				FillTemplateList(dataCenter.Id);
			}
			UpdateCDImages();

			VmTemplate template = Template.SelectedItem as VmTemplate;
			if (template == null)
			{
				IsBlankTemplate = true;
				List<VmTemplate> listTemplates = (List<VmTemplate>)Template.Items;
				if(listTemplates.Count > 0)
					Template.SelectedItem = listTemplates[0];
			}

			if(dataCenter.storage_pool_type == StorageType.LOCALFS)
			{
				IsHostAvailable = false;
			}
			else
			{
				IsHostAvailable = true;
			}
		}

		private void Template_SelectedItemChanged()
		{
			VmTemplate template = Template.SelectedItem as VmTemplate;

			UpdateStorageDomains();

			if (template == null)
			{
				return;
			}

			IsBlankTemplate = template.Id.Equals(Guid.Empty);

			OSType.SelectedItem = template.os;
			NumOfSockets.Entity = template.num_of_sockets;
			TotalCPUCores.Entity = template.num_of_cpus;

			NumOfMonitors.SelectedItem = template.num_of_monitors;
			Domain.SelectedItem = template.domain;
			MemSize.Entity = template.mem_size_mb;
			UsbPolicy.SelectedItem = template.usb_policy;
			BootSequence = template.default_boot_sequence;
			IsHighlyAvailable.Entity = template.auto_startup;
			IsStateless.Entity = template.is_stateless;

			UpdateMinAllocatedMemory(true);

			CdImage.IsChangable = !String.IsNullOrEmpty(template.iso_path);
			if (CdImage.IsChangable) CdImage.SelectedItem = template.iso_path;

			TimeZone.SelectedItem = String.IsNullOrEmpty(template.time_zone)
				? Linq.FirstOrDefault((IEnumerable<KeyValuePair<string, string>>)TimeZone.Items, new Linq.TimeZonePredicate(DataProvider.GetDefaultTimeZone()))
				: Linq.FirstOrDefault((IEnumerable<KeyValuePair<string, string>>)TimeZone.Items, new Linq.TimeZonePredicate(template.time_zone));

			//IEnumerable<VDSGroup> clusters = Cluster.Options.Cast<VDSGroup>();
			if(Cluster.Items == null)
				return;
			List<VDSGroup> clusters = Linq.Cast<VDSGroup>(Cluster.Items);
			//VDSGroup clusterToSelect = clusters.FirstOrDefault(a => a.ID == template.vds_group_id);
			VDSGroup clusterToSelect = null;
			foreach (VDSGroup a in clusters)
			{
				if (a.ID.Equals(template.vds_group_id))
				{
					clusterToSelect = a;
					break;
				}
			}

			if (clusterToSelect == null)
			{
				//clusterToSelect = clusters.FirstOrDefault();
				clusterToSelect = Linq.FirstOrDefault(clusters);
			}

			Cluster.SelectedItem = clusterToSelect;

			// BZ#549348 (SPICE should be the default protocol for new Desktop).
			// Because of this bug, the Display Protocol is read only in case of
			// new Server or in case the template has the SPICE protocol as the
			// default display type:
			if (VmType == VmType.Server || template.default_display_type == DisplayType.qxl)
			{
				//DisplayProtocol.Value = DisplayProtocol.Options
				//    .Cast<EntityModel>()
				//    .FirstOrDefault(a => (DisplayType)a.Entity == template.default_display_type);
				EntityModel displayProtocol = null;
				bool isFirst = true;
				foreach (object item in DisplayProtocol.Items)
				{
					EntityModel a = (EntityModel)item;
					if (isFirst)
					{
						displayProtocol = a;
						isFirst = false;
					}
					DisplayType dt = (DisplayType)a.Entity;
					if (dt == template.default_display_type)
					{
						displayProtocol = a;
						break;
					}
				}
				DisplayProtocol.SelectedItem = displayProtocol;
			}
			//by default, take kernel params from template
			if (IsNew)
			{
				Kernel_path.Entity = template.kernel_url;
				Kernel_parameters.Entity = template.kernel_params;
				Initrd_path.Entity = template.initrd_url;
			}
			if (!template.Id.Equals(Guid.Empty))
			{
				IsBlankTemplate = false;
				Provisioning.IsChangable = true;
				//Retrieve disks.
				if (IsNew)
				{
					//Disks = DataProvider.GetTemplateDiskList(template.vmt_guid)
					//    .OrderBy(a => a.internal_drive_mapping)
					//    .Select(a =>
					//        new DiskModel()
					//        {
					//            IsNew = true,
					//            Name = a.internal_drive_mapping,
					//            Size = { Entity = a.SizeInGigabytes },
					//            VolumeType = { SelectedItem = a.volume_type }
					//        }
					//    )
					//    .ToList();

					List<DiskImage> diskList = DataProvider.GetTemplateDiskList(template.Id);
					diskList.Sort(new Linq.DiskByInternalDriveMappingComparer());

					List<DiskModel> list = new List<DiskModel>();
					foreach (DiskImage a in diskList)
					{
						DiskModel model = new DiskModel();
						model.IsNew = true;
						model.Name = a.internal_drive_mapping;
						model.Size =
							new EntityModel
							{
								Entity = a.SizeInGigabytes
							};
						model.VolumeType =
							new ListModel
							{
								Items = DataProvider.GetVolumeTypeList(),
								SelectedItem = a.volume_type
							};
						list.Add(model);
					}

					Disks = list;
				}
				UpdateIsDisksAvailable();
			}
			else
			{
				IsBlankTemplate = true;
				IsDisksAvailable = false;
				Provisioning.IsChangable = false;
				Disks = null;
			}

			//Set priority
			int priority = DataProvider.RoundPriority(template.priority);
			//Priority.SelectedItem = Priority.Items
			//    .Cast<EntityModel>()
			//    .FirstOrDefault(a => (int)a.Entity == priority);

			object prioritySelectedItem = null;
			foreach (object item in Priority.Items)
			{
				EntityModel a = (EntityModel)item;
				if ((int)a.Entity == priority)
				{
					prioritySelectedItem = a;
					break;
				}
			}
			Priority.SelectedItem = prioritySelectedItem;
		}

		private void Cluster_SelectedItemChanged()
		{
			VDSGroup cluster = (VDSGroup)Cluster.SelectedItem;

			List<VDS> hosts = cluster != null
								? DataProvider.GetHostListByCluster(cluster.name)
								: new List<VDS>();
			DefaultHost.Items = hosts;
			DefaultHost.SelectedItem = Linq.FirstOrDefault(hosts);

			if (cluster != null)
			{
				_maxMemSize32 = DataProvider.GetMaximalVmMemSize32OS();
				_maxMemSize64 = DataProvider.GetMaximalVmMemSize64OS();

				IsCustomPropertiesAvailable = DataProvider.IsSupportCustomProperties(cluster.compatibility_version.ToString());
			}

			//int numOfSockets = cluster != null
			//                    ? DataProvider.GetNumOfVmSockets(cluster.compatibility_version.ToString())
			//                    : 1;

			//NumOfSockets.Entity = NumOfSockets.Min = NumOfSockets.Interval = 1;
			//NumOfSockets.Max = numOfSockets;
			UpdateNumOfSockets();
			UpdateMinAllocatedMemory(false);
			//UpdateTotalCpus();
		}

		void OSType_SelectedItemChanged()
		{
			IsWindowsOS = DataProvider.IsWindowsOsType((VmOsType)OSType.SelectedItem);
			IsLinux_Unassign_UnknownOS = DataProvider.IsLinuxOsType((VmOsType)OSType.SelectedItem) ||
										 ((VmOsType)OSType.SelectedItem) == VmOsType.Unassigned ||
										 ((VmOsType)OSType.SelectedItem) == VmOsType.Other;

			Initrd_path.IsChangable = IsLinux_Unassign_UnknownOS;
			Initrd_path.IsAvailable = IsLinux_Unassign_UnknownOS;

			Kernel_path.IsChangable = IsLinux_Unassign_UnknownOS;
			Kernel_path.IsAvailable = IsLinux_Unassign_UnknownOS;

			Kernel_parameters.IsChangable = IsLinux_Unassign_UnknownOS;
			Kernel_parameters.IsAvailable = IsLinux_Unassign_UnknownOS;

			Domain.IsChangable = IsWindowsOS;
			Domain.IsAvailable = IsWindowsOS;

			TimeZone.IsChangable = IsWindowsOS;
			TimeZone.IsAvailable = IsWindowsOS;

			DefineNumOfMonitorsAvailabilityAccoringToSelectedOs();
		}

		void DisplayProtocol_SelectedItemChanged()
		{
			EntityModel entityModel = (EntityModel)DisplayProtocol.SelectedItem;
			DisplayType type = (DisplayType)entityModel.Entity;

			if (type == DisplayType.vnc)
			{
				UsbPolicy.SelectedItem = VdcCommon.BusinessEntities.UsbPolicy.Disabled;
				NumOfMonitors.SelectedItem = 1;
			}

			UsbPolicy.IsChangable = type == DisplayType.qxl;
			NumOfMonitors.IsChangable = type == DisplayType.qxl;
		}

		void FirstBootDevice_SelectedItemChanged()
		{
			EntityModel entityModel = (EntityModel)FirstBootDevice.SelectedItem;
			BootSequence firstDevice = (BootSequence)entityModel.Entity;

			//var list = FirstBootDevice.Items
			//    .Cast<EntityModel>()
			//    .Where(a => (BootSequence)a.Entity != firstDevice)
			//    .ToList();
			List<EntityModel> list = new List<EntityModel>();
			foreach (object item in FirstBootDevice.Items)
			{
				EntityModel a = (EntityModel)item;
				if ((BootSequence)a.Entity != firstDevice)
				{
					list.Add(a);
				}
			}

			EntityModel noneOption = new EntityModel { Title = "[None]" };

			list.Insert(0, noneOption);

			SecondBootDevice.Items = list;
			SecondBootDevice.SelectedItem = noneOption;
		}

		private void UpdateIsDisksAvailable()
		{
			IsDisksAvailable = IsNew && (bool)Provisioning.SelectedItem && (Disks != null);
		}

		void DefineNumOfMonitorsAvailabilityAccoringToSelectedOs()
		{
			if (VmType == VmType.Desktop)
			{
				if (DataProvider.IsLinuxOsType((VmOsType)OSType.SelectedItem))
				{
					NumOfMonitors.SelectedItem = 1;
					NumOfMonitors.IsAvailable = false;
					NumOfMonitors.IsChangable = false;
				}
				else if (!NumOfMonitors.IsAvailable)
				{
					NumOfMonitors.IsAvailable = true;
					NumOfMonitors.IsChangable = true;
				}
			}
		}

		virtual protected void FillTemplateList(Guid DataCenterId)
		{
			List<VmTemplate> templates = DataProvider.GetTemplateList(DataCenterId);

			VmTemplate oldTemplate = (VmTemplate)Template.SelectedItem;
			Template.Items = templates;

			// If there was no selected template or the old selected template doesn't
			// exist in the new list of available templates - re-select a template.
			// Otherwise, leave the template selected value as is.
			bool all = false;
			if (oldTemplate != null)
			{
				foreach (VmTemplate a in templates)
				{
					if (a.Id.Equals(oldTemplate.Id))
					{
						all = true;
						break;
					}
				}
			}

			if (oldTemplate == null || all)
			//|| templates.All(a => a.vmt_guid != oldTemplateValue.vmt_guid))
			{
				//Template.SelectedItem = templates.FirstOrDefault(a => a.vmt_guid == Guid.Empty);
				foreach (VmTemplate a in templates)
				{
					if (a.Id.Equals(Guid.Empty))
					{
						Template.SelectedItem = a;
						break;
					}
				}
			}
		}

		private void SetGUIByVMType()
		{
			IEnumerable<int> numOfMonitors;

			if (VmType == VmType.Desktop)
			{
				numOfMonitors = DataProvider.GetNumOfMonitorList();
				//numOfCPUs = DataProvider.GetNumOfCPUList().Where(a => a <= 4);
				UsbPolicy.SelectedItem = VdcCommon.BusinessEntities.UsbPolicy.Enabled;
			}
			else
			{
				numOfMonitors = new List<int> { 1 };
			}

			NumOfMonitors.Items = numOfMonitors;
			NumOfMonitors.SelectedItem = Linq.FirstOrDefault(numOfMonitors);

			//DisplayProtocol.SelectedItem = DisplayProtocol.Items
			//    .Cast<EntityModel>()
			//    .First(a => (DisplayType)a.Entity == (VmType == VmType.Desktop ? DisplayType.qxl : DisplayType.vnc));
			foreach (object item in DisplayProtocol.Items)
			{
				EntityModel a = (EntityModel)item;
				if ((DisplayType)a.Entity == (VmType == VmType.Desktop ? DisplayType.qxl : DisplayType.vnc))
				{
					DisplayProtocol.SelectedItem = a;
					break;
				}
			}
		}

		private void UpdateCDImages()
		{
			storage_pool dataCenter = DataCenter.SelectedItem as storage_pool;
			if (dataCenter != null)
			{
				Guid? vds_id = null;
                if ((bool)IsAutoAssign.Entity == false && (DefaultHost.SelectedItem != null))
                {
                    vds_id = ((VDS)DefaultHost.SelectedItem).vds_id;
                    vds_id = vds_id == Guid.Empty ? null : vds_id;
                }

				List<string> images = DataProvider.GetIrsImageList(dataCenter.Id, false);
				CdImage.Items = images;

				if (CdImage.IsChangable && CdImage.SelectedItem == null)
				{
					CdImage.SelectedItem = Linq.FirstOrDefault(images);
				}
			}
		}

		private void UpdateStorageDomains()
		{
			VmTemplate template = Template.SelectedItem as VmTemplate;

			if (template != null && !template.Id.Equals(Guid.Empty))
			{
				storage_pool dataCenter = (storage_pool)DataCenter.SelectedItem;

				//var storageDomains = !(bool)Provisioning.SelectedItem
				//    ? DataProvider.GetStorageDomainListByTemplate(template.vmt_guid)
				//    : DataProvider.GetStorageDomainList(dataCenter.id)
				//        .Where(a => a.storage_domain_type == StorageDomainType.Data || a.storage_domain_type == StorageDomainType.Master);
				List<storage_domains> storageDomains;
				if ((bool)Provisioning.SelectedItem == false)
				{
					storageDomains = DataProvider.GetStorageDomainListByTemplate(template.Id);
				}
				else
				{
					storageDomains = new List<storage_domains>();
					foreach (storage_domains a in DataProvider.GetStorageDomainList(dataCenter.Id))
					{
						if (a.storage_domain_type == StorageDomainType.Data || a.storage_domain_type == StorageDomainType.Master)
						{
							storageDomains.Add(a);
						}
					}
				}

				// filter only the Active storage domains (Active regarding the relevant storage pool).
				//storageDomains = storageDomains.Where(a => a.status.HasValue && a.status.Value == StorageDomainStatus.Active);
				List<storage_domains> list = new List<storage_domains>();
				foreach (storage_domains a in storageDomains)
				{
					if (a.status.HasValue && a.status.Value == StorageDomainStatus.Active)
					{
						list.Add(a);
					}
				}

				StorageDomain.Items = list;
				StorageDomain.SelectedItem = Linq.FirstOrDefault(list);
				StorageDomain.IsChangable = true;
			}
			else
			{
				StorageDomain.Items = new List<storage_domains>();
				StorageDomain.SelectedItem = null;
				StorageDomain.IsChangable = false;
			}
		}

		internal virtual bool Validate()
		{
			VmOsType os = (VmOsType)OSType.SelectedItem;
			string nameExpr = string.Format(@"^[0-9a-zA-Z-_]{{1,{0}}}$", WINDOWS_VM_NAME_MAX_LIMIT);
			string nameMsg = string.Format(
					"Name must contain only alphanumeric characters. Maximum length: {0}.",
					WINDOWS_VM_NAME_MAX_LIMIT);

			if (!DataProvider.IsWindowsOsType(os))
			{
				nameExpr = string.Format(@"^[-\w]{{1,{0}}}$", NON_WINDOWS_VM_NAME_MAX_LIMIT);
				nameMsg = string.Format(
					"Name cannot contain blanks or special characters. Maximum length: {0}.",
					NON_WINDOWS_VM_NAME_MAX_LIMIT);
			}

			Name.ValidateEntity(new IValidation[] { new NotEmptyValidation(), new RegexValidation { Expression = nameExpr, Message = nameMsg } });

			DataCenter.IsValid = true;
			//In case of Edit the only scenario in which it will be null - editing of Blank template
			if (IsNew)
			{
				DataCenter.ValidateSelectedItem(new IValidation[] { new NotEmptyValidation() });
			}

			Cluster.ValidateSelectedItem(new IValidation[] { new NotEmptyValidation() });

			MemSize.ValidateEntity(new IValidation[] { new ByteSizeValidation() });
			MinAllocatedMemory.ValidateEntity(new IValidation[] { new ByteSizeValidation() });

			VmTemplate template = (VmTemplate)Template.SelectedItem;
			storage_domains storageDomain = (storage_domains)StorageDomain.SelectedItem;

			Template.ValidateSelectedItem(new IValidation[] { new NotEmptyValidation() });

			StorageDomain.IsValid = true;
			if (template != null && !template.Id.Equals(Guid.Empty) && storageDomain == null)
			{
				StorageDomain.IsValid = false;
				StorageDomain.InvalidityReasons.Add("Storage Domain must be specified.");
			}

			VmOsType osType = (VmOsType)OSType.SelectedItem;
			bool is64OsType = (osType == VmOsType.Other || osType == VmOsType.OtherLinux || DataProvider.Is64bitOsType(osType));
			int maxMemSize = is64OsType ? _maxMemSize64 : _maxMemSize32;

			ValidateMemorySize(MemSize, maxMemSize, _minMemSize);

			// Minimum 'Physical Memory Guaranteed' is 1MB
			ValidateMemorySize(MinAllocatedMemory, (int)MemSize.Entity, 1);

			CdImage.IsValid = true;
			if (CdImage.IsChangable)
			{
				CdImage.ValidateSelectedItem(new IValidation[] { new NotEmptyValidation() });
			}

			Kernel_path.IsValid = true;
			Kernel_parameters.IsValid = true;
			Initrd_path.IsValid = true;
			if (Kernel_path.Entity == null)
			{
				Kernel_path.Entity = "";
			}
			if (Kernel_parameters.Entity == null)
			{
				Kernel_parameters.Entity = "";
			}
			if (Initrd_path.Entity == null)
			{
				Initrd_path.Entity = "";
			}

			if (this.isLinux_Unassign_UnknownOS && ((((string)Kernel_parameters.Entity).Length > 0 || ((string)Initrd_path.Entity).Length > 0) && ((string)Kernel_path.Entity).Length == 0))
			{
				int count = 0;
				string msg = "When ";
				if (((string)Kernel_parameters.Entity).Length > 0)
				{
					Kernel_parameters.IsValid = false;
                    msg += "a kernel parameter argument ";
					count++;
				}
				if (((string)Initrd_path.Entity).Length > 0)
				{
					Initrd_path.IsValid = false;
					if (count == 1)
					{
						msg += "or ";
					}
                    msg += "an initrd path ";
				}
			    msg += "is used, kernel path must be non-empty";

				Kernel_path.IsValid = false;
				Initrd_path.InvalidityReasons.Add(msg);
				Kernel_parameters.InvalidityReasons.Add(msg);
				Kernel_path.InvalidityReasons.Add(msg);
			}

			if (CustomProperties.Entity == null)
			{
				CustomProperties.Entity = String.Empty;
			}

			CustomProperties.ValidateEntity(new IValidation[] { new CustomPropertyValidation(CustomPropertiesKeysList) });


			IsGeneralTabValid =
				IsFirstRunTabValid =
				IsDisplayTabValid =
				IsAllocationTabValid =
				IsBootSequenceTabValid = true;


			IsGeneralTabValid =
				Name.IsValid
				&& Description.IsValid
				&& DataCenter.IsValid
				&& Template.IsValid
				&& Cluster.IsValid
				&& MemSize.IsValid
				&& MinAllocatedMemory.IsValid;

			IsFirstRunTabValid =
				Domain.IsValid
				&& TimeZone.IsValid;

			IsDisplayTabValid =
				UsbPolicy.IsValid
				&& NumOfMonitors.IsValid;


            if ((bool)IsAutoAssign.Entity == false)
            {
                DefaultHost.ValidateSelectedItem(new IValidation[] { new NotEmptyValidation() });
                IsHostTabValid = DefaultHost.IsValid;
            }
            else
            {
                DefaultHost.IsValid = true;
                IsHostTabValid = true;
            }



			IsAllocationTabValid =
				StorageDomain.IsValid
				&& MinAllocatedMemory.IsValid;;
			IsBootSequenceTabValid =
				CdImage.IsValid
				&& Kernel_path.IsValid;

			IsCustomPropertiesTabValid = CustomProperties.IsValid;

			return Name.IsValid
				   && Description.IsValid
				   && DataCenter.IsValid
				   && StorageDomain.IsValid
				   && Template.IsValid
				   && Cluster.IsValid
                   && DefaultHost.IsValid
				   && MemSize.IsValid
				   && MinAllocatedMemory.IsValid
				   && NumOfMonitors.IsValid
				   && Domain.IsValid
				   && UsbPolicy.IsValid
				   && TimeZone.IsValid
				   && OSType.IsValid
				   && CdImage.IsValid
				   && Kernel_path.IsValid
				   && CustomProperties.IsValid;
		}

		private void ValidateMemorySize(EntityModel memorySizeEntityModel, int maxMemSize, int minMemSize)
		{
			memorySizeEntityModel.IsValid = true;

			int memSize = (int)memorySizeEntityModel.Entity;

            if (memSize == 0)
            {
				memorySizeEntityModel.IsValid = false;
				memorySizeEntityModel.InvalidityReasons.Add(string.Format("Memory size is between {0} MB and {1} MB", minMemSize, maxMemSize));
            }
            else if (memSize > maxMemSize)
			{
				memorySizeEntityModel.IsValid = false;
				memorySizeEntityModel.InvalidityReasons.Add(string.Format("Maximum memory size is {0} MB.", maxMemSize));
			}
			else if (memSize < minMemSize)
			{
				memorySizeEntityModel.IsValid = false;
				memorySizeEntityModel.InvalidityReasons.Add(string.Format("Minimum memory size is {0} MB.", minMemSize));
			}
		}

		public BootSequence BootSequence
		{
			get
			{
				EntityModel firstSelectedItem = (EntityModel)FirstBootDevice.SelectedItem;
				EntityModel secondSelectedItem = (EntityModel)SecondBootDevice.SelectedItem;

				return (BootSequence)Enum.Parse(typeof(BootSequence), String.Format("{0}{1}", firstSelectedItem.Entity, secondSelectedItem.Entity));
			}
			set
			{
				//var items = value.ToString().Select(a => (BootSequence)Enum.Parse(typeof(BootSequence), a.ToString()));
				List<BootSequence> items = new List<BootSequence>();
				foreach (char a in value.ToString().ToCharArray())
				{
					items.Add((BootSequence)Enum.Parse(typeof(BootSequence), a.ToString()));
				}

				//FirstBootDevice.SelectedItem = FirstBootDevice.Items
				//    .Cast<EntityModel>()
				//    .FirstOrDefault(a => (BootSequence)a.Entity == items.First());
				object firstBootDevice = null;
				foreach (object item in FirstBootDevice.Items)
				{
					EntityModel a = (EntityModel)item;
					if ((BootSequence)a.Entity == Linq.FirstOrDefault(items))
					{
						firstBootDevice = a;
					}
				}
				FirstBootDevice.SelectedItem = firstBootDevice;

				//var secondDeviceOptions = SecondBootDevice.Items
				//    .Cast<EntityModel>()
				//    .ToList();

				List<EntityModel> secondDeviceOptions = Linq.Cast<EntityModel>(SecondBootDevice.Items);

				//SecondBootDevice.SelectedItem = items.Count() > 1
				//    ? secondDeviceOptions.Where(a => a.Entity != null).First(a => (BootSequence)a.Entity == items.Last())
				//    : secondDeviceOptions.First(a => a.Entity == null);

				if (items.Count > 1)
				{
					BootSequence last = items[items.Count - 1];
					foreach (EntityModel a in secondDeviceOptions)
					{
						if (a.Entity != null && (BootSequence)a.Entity == last)
						{
							SecondBootDevice.SelectedItem = a;
							break;
						}
					}
				}
				else
				{
					foreach (EntityModel a in secondDeviceOptions)
					{
						if (a.Entity == null)
						{
							SecondBootDevice.SelectedItem = a;
							break;
						}
					}
				}
			}
		}
	}
}
