using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using org.ovirt.engine.ui.uicommon;
using System.Collections;
using Microsoft.Practices.Unity;
using System.Windows.Media;

namespace UI.WPFClient
{
	public class WindowManager
	{
		private int lastZIndex;
		private WindowSurface backSurface;
		private Grid dragSurface;
		private readonly IList<WindowView> windows = new List<WindowView>();


		public void AddDragSurface(Grid obj)
		{
			dragSurface = obj;

			backSurface = new WindowSurface();
			dragSurface.Children.Add(backSurface);
		}

		public void AddWindow(WindowView window)
		{
			if (!DesignerProperties.GetIsInDesignMode(window))
			{
				window.Loaded += (sender, e) => Keyboard.Focus(window);

				backSurface.HasOpenedWindow = true;
				Panel.SetZIndex(backSurface, ++lastZIndex);

				windows.Add(window);
				dragSurface.Children.Add(window);
				window.HorizontalAlignment = HorizontalAlignment.Left;
				window.VerticalAlignment = VerticalAlignment.Top;
				window.Margin = new Thickness(dragSurface.ActualWidth / 2 - window.Width / 2, dragSurface.ActualHeight / 2 - window.Height / 2, 0, 0);
				Panel.SetZIndex(window, ++lastZIndex);
			}
			else
			{
				//Do something to make design time comfortable.
				window.Visibility = Visibility.Collapsed;
			}
		}

		public void RemoveWindow(WindowView window)
		{
			window.LostKeyboardFocus += (object sender, KeyboardFocusChangedEventArgs e) =>
			                            	{
			                            		if (windows.Count > 0)
			                            		{
			                            			Keyboard.Focus(windows[windows.Count - 1]);
			                            		}
			                            	};
			dragSurface.Children.Remove(window);
			windows.Remove(window);

			lastZIndex -= 2;
			Panel.SetZIndex(backSurface, lastZIndex - 1);

			if (windows.Count == 0)
			{
				backSurface.HasOpenedWindow = false;
			}
		}

		public void CloseAll()
		{
			for (int i = 0; i < windows.Count; i++)
			{
				RemoveWindow(windows[i]);
			}
		}
	}
}
