using System;
using VdcCommon.BusinessEntities;

namespace SearchBackend
{
    class VmConditionFieldAutoCompleter : BaseConditionFieldAutoCompleter
    {
        public VmConditionFieldAutoCompleter()
        {
            //Building the basic vervs Dict
            mVerbs.Add("NAME", "NAME");
            mVerbs.Add("STATUS", "STATUS");
            mVerbs.Add("IP", "IP");
            mVerbs.Add("UPTIME", "UPTIME");
            mVerbs.Add("DOMAIN", "DOMAIN");
            mVerbs.Add("OS", "OS");
            mVerbs.Add("CREATIONDATE", "CREATIONDATE");
            mVerbs.Add("ADDRESS", "ADDRESS");
            mVerbs.Add("CPU_USAGE", "CPU_USAGE");
            mVerbs.Add("MEM_USAGE", "MEM_USAGE");
            mVerbs.Add("NETWORK_USAGE", "NETWORK_USAGE");
            mVerbs.Add("MEMORY", "MEMORY");
            mVerbs.Add("APPS", "APPS");
            mVerbs.Add("CLUSTER", "CLUSTER");
            mVerbs.Add("POOL", "POOL");
            mVerbs.Add("LOGGEDINUSER", "LOGGEDINUSER");
			mVerbs.Add("TAG", "TAG");
            mVerbs.Add("DATACENTER", "DATACENTER");
            mVerbs.Add("TYPE", "TYPE");
            //Building the autoCompletion Dict
            buildCompletions();
            //Building the types dict
            TypeDictionary.Add("NAME", typeof(string));
            TypeDictionary.Add("STATUS",typeof(VMStatus));
            TypeDictionary.Add("IP",typeof(string));
            TypeDictionary.Add("UPTIME", typeof(TimeSpan));
            TypeDictionary.Add("DOMAIN", typeof(string));
            TypeDictionary.Add("OS", typeof(VmOsType));
            TypeDictionary.Add("CREATIONDATE", typeof(DateTime));
            TypeDictionary.Add("ADDRESS", typeof(string));
            TypeDictionary.Add("CPU_USAGE", typeof(int));
            TypeDictionary.Add("MEM_USAGE", typeof(int));
            TypeDictionary.Add("NETWORK_USAGE", typeof(int));
            TypeDictionary.Add("MEMORY", typeof(int));
            TypeDictionary.Add("APPS", typeof(string));
            TypeDictionary.Add("CLUSTER", typeof(string));
            TypeDictionary.Add("POOL", typeof(string));
            TypeDictionary.Add("LOGGEDINUSER", typeof(string));
			TypeDictionary.Add("TAG", typeof(string));
            TypeDictionary.Add("DATACENTER", typeof(string));
            TypeDictionary.Add("TYPE", typeof(VmType));
            //building the ColumnName Dict
            mColumnNameDict.Add("NAME", "vm_name");
            mColumnNameDict.Add("STATUS", "status");
            mColumnNameDict.Add("IP", "vm_ip");
            mColumnNameDict.Add("UPTIME", "elapsed_time");
            mColumnNameDict.Add("DOMAIN", "vm_domain");
            mColumnNameDict.Add("OS", "vm_os");
            mColumnNameDict.Add("CREATIONDATE", "vm_creation_date");
            mColumnNameDict.Add("ADDRESS", "vm_host");
            mColumnNameDict.Add("CPU_USAGE", "usage_cpu_percent");
            mColumnNameDict.Add("MEM_USAGE", "usage_mem_percent");
            mColumnNameDict.Add("NETWORK_USAGE", "usage_network_percent");
            mColumnNameDict.Add("MEMORY", "vm_mem_size_mb");
            mColumnNameDict.Add("APPS", "app_list");
            mColumnNameDict.Add("CLUSTER", "vds_group_name");
            mColumnNameDict.Add("POOL","vm_pool_name");
            //mColumnNameDict.Add("NOTE", "note");
            mColumnNameDict.Add("LOGGEDINUSER", "guest_cur_user_name");
			mColumnNameDict.Add("TAG", "tag_name");
            mColumnNameDict.Add("DATACENTER", "storage_pool_name");
            mColumnNameDict.Add("TYPE", "vm_type");
            ///
            mNotFreeTextSearchableFieldsList.Add("APPS");
            //Building the validation dict
            buildBasicValidationTable();
        }

        public override IAutoCompleter getFieldRelationshipAutoCompleter(string fieldName)
        {
            IAutoCompleter retval;
            switch(fieldName)
            {
                case "UPTIME": 
                case "CREATIONDATE":
                    retval = new BiggerOrSmallerRelationAutoCompleter();
                    break;
                case "CPU_USAGE":
                case "MEM_USAGE":
                case "MEMORY":
                case "NETWORK_USAGE":
                    retval = new NumericConditionRelationAutoCompleter();
                    break;
				case "TAG":
					retval = new StringOnlyEqualConditionRelationAutoCompleter();
					break;
                default:
                    retval = new StringConditionRelationAutoCompleter();
                    break;
            }
            return retval;
        }

        public override IConditionValueAutoCompleter getFieldValueAutoCompleter(string fieldName)
        {
            IConditionValueAutoCompleter retval = null;
            switch (fieldName)
            {
                case "OS":
                    retval = new EnumValueAutoCompleter(typeof(VmOsType));
                    break;
                case "STATUS":
                    retval = new EnumValueAutoCompleter(typeof(VMStatus));
                    break;
                case "TYPE":
                    retval = new EnumValueAutoCompleter(typeof(VmType));
                    break;
                default:
                    break;
            }
            return retval;
        }

        public override void formatValue(string fieldName, ref string relations, ref string value)
        {
            switch (fieldName)
            {
                case "APPS":
                    value = string.Format("N'%{0}%'", value.Trim('\'').Replace("N'",""));
                    if (relations == "=")
                    {
                        relations = "LIKE";
                    }
                    else if (relations == "!=")
                    {
                        relations = "NOT LIKE";
                    }
                    break;
                case "UPTIME":
                    value = value.Trim('\'');
                    TimeSpan ts = TimeSpan.Parse(value);
                    value = string.Format("'{0}'", ts.TotalSeconds);
                    break;
                case "CREATIONDATE":
                    DateTime tmp = DateTime.Parse(value.Trim('\''));
                    value = string.Format("'{0}'", tmp);
                    break;
                default:
					base.formatValue(fieldName, ref relations, ref value);
                    break;
            }
        }
    }
}
