﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.ComponentModel;
using System.Net;

namespace UI.WPFClient
{
	/// <summary>
	/// Interaction logic for IpUserControl.xaml
	/// </summary>
	public partial class IpUserControl : UserControl, INotifyPropertyChanged
	{
		static readonly DependencyProperty IPTextProperty = DependencyProperty.Register("IPText", typeof(string),
																				typeof(IpUserControl),
																				new PropertyMetadata(OnIPTextPropertyChanged));

		private void IPTextModified()
		{
			IPText = a0 + "." + a1 + "." + a2 + "." + a3;
			if (IPText == "...")
			{
				IPText = "";
			}
		}

		public string IPText
		{
			get { return (string)GetValue(IPTextProperty); }
			set { SetValue(IPTextProperty, value); }
		}

		public static void OnIPTextPropertyChanged(DependencyObject obj, DependencyPropertyChangedEventArgs args)
		{
			IpUserControl control = (IpUserControl)obj;
			if (control.IPText == null)
				return;
			string[] byteArr = control.IPText.Split('.');
			if (byteArr.Length == 0)
			{
				return;
			}
			if (byteArr.Length >= 1)
			{
				control.A0 = byteArr[0];
			}
			if (byteArr.Length >= 2)
			{
				control.A1 = byteArr[1];
			}
			if (byteArr.Length >= 3)
			{
				control.A2 = byteArr[2];
			}
			if (byteArr.Length >= 4)
			{
				control.A3 = byteArr[3];
			}
		}

		private string a0 { get; set; }
		public string A0
		{
			get { return a0; }
			set
			{
				if (a0 != value)
				{
					a0 = value;
					if (PropertyChanged != null)
						PropertyChanged(this, new PropertyChangedEventArgs("A0"));
					IPTextModified();
				}
			}
		}
		private string a1 { get; set; }
		public string A1
		{
			get { return a1; }
			set
			{
				if (a1 != value)
				{
					a1 = value;
					if (PropertyChanged != null)
						PropertyChanged(this, new PropertyChangedEventArgs("A1"));
					IPTextModified();
				}
			}
		}
		private string a2 { get; set; }
		public string A2
		{
			get { return a2; }
			set
			{
				if (a2 != value)
				{
					a2 = value;
					if (PropertyChanged != null)
						PropertyChanged(this, new PropertyChangedEventArgs("A2"));
					IPTextModified();
				}
			}
		}
		private string a3 { get; set; }
		public string A3
		{
			get { return a3; }
			set
			{
				if (a3 != value)
				{
					a3 = value;
					if (PropertyChanged != null)
						PropertyChanged(this, new PropertyChangedEventArgs("A3"));
					IPTextModified();
				}
			}
		}

		public IpUserControl()
		{
			InitializeComponent();
			A0 = A1 = A2 = A3 = "";
			tb3.OnBackSpace += new IPTextBoxDelegate(tb3_OnBackSpace);
			tb2.OnBackSpace += new IPTextBoxDelegate(tb2_OnBackSpace);
			tb1.OnBackSpace += new IPTextBoxDelegate(tb1_OnBackSpace);
			tb0.OnTab += new IPTextBoxDelegate(tb0_OnTab);
			tb1.OnTab += new IPTextBoxDelegate(tb1_OnTab);
			tb2.OnTab += new IPTextBoxDelegate(tb2_OnTab);
			initCopyPasteCommands();
		}

		#region Focus
		void onHome()
		{
			tb0.Focus();
		}

		void onEnd()
		{
			tb3.Focus();
		}

		void tb2_OnTab()
		{
			tb3.Focus();
		}

		void tb1_OnTab()
		{
			tb2.Focus();
		}

		void tb0_OnTab()
		{
			tb1.Focus();
		}

		void tb1_OnBackSpace()
		{
			tb0.Focus();
		}

		void tb2_OnBackSpace()
		{
			tb1.Focus();
		}

		void tb3_OnBackSpace()
		{
			tb2.Focus();
		} 
		#endregion

		#region INotifyPropertyChanged Members

		public event PropertyChangedEventHandler PropertyChanged;

		#endregion

		#region CopyPaste
		public RoutedCommand CopyIPCommand { get; set; }
		public RoutedCommand PasteIPCommand { get; set; }

		private void initCopyPasteCommands()
		{
			CopyIPCommand = new RoutedCommand("CopyIp", typeof(IpUserControl));
			PasteIPCommand = new RoutedCommand("PasteIp", typeof(IpUserControl));
			this.CommandBindings.Add(new CommandBinding(CopyIPCommand, copy_Executed, copy_CanExecute));
			this.CommandBindings.Add(new CommandBinding(PasteIPCommand, paste_Executed, paste_CanExecute));
		}
		private void copy_CanExecute(object sender, CanExecuteRoutedEventArgs e)
		{
			IPAddress temp = null;
			if(this.IPText == null)
			{
				e.CanExecute = false;
				return;
			}
			if (IPAddress.TryParse(this.IPText, out temp))
			{
				e.CanExecute = true;
			}
			else
			{
				e.CanExecute = false;
			}
		}
		private void copy_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			Clipboard.SetDataObject(this.IPText);
		}
		private void paste_CanExecute(object sender, CanExecuteRoutedEventArgs e)
		{
			IPAddress temp;
			object o = Clipboard.GetDataObject().GetData(typeof(String));
			if (o == null)
			{
				e.CanExecute = false;
				return;
			}
			string ip = o.ToString();

			if (IPAddress.TryParse(ip, out temp))
			{
				List<char> list = new List<char>();
				list.Add('.');
				if (ip.ToString().Split('.').Length == 4)
				{
					e.CanExecute = true;
				}
				else
				{
					e.CanExecute = false;
				}
			}
			else
			{
				e.CanExecute = false;
			}
		}
		private void paste_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			string ip = (string)Clipboard.GetDataObject().GetData(typeof(String));

			IPAddress temp;
			if (IPAddress.TryParse(ip, out temp))
			{
				this.IPText = ip;
			}
		} 
		#endregion
	}
}