using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using Microsoft.Practices.Unity;
using org.ovirt.engine.ui.uicommon;
using org.ovirt.engine.ui.uicommon.models.users;

namespace UI.WPFClient
{
	public partial class UserVmListView
	{
		private WindowView view;

		public new UserVmListModel Model
		{
			get { return base.Model as UserVmListModel; }
			set { base.Model = value; }
		}

		public UserVmListView()
		{
			InitializeComponent();
		}

		protected override void ModelPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.ModelPropertyChanged(sender, e);

			if (e.PropertyName != "Window") return;

			if (Model.Window != null)
			{
				if (Model.LastExecutedCommand == Model.AttachCommand)
				{
					view = TypeResolver.Instance.Resolve<FindDesktopView>();
				}
				else if (Model.LastExecutedCommand == Model.DetachCommand)
				{
					view = TypeResolver.Instance.Resolve<ConfirmationView>();
				}
				else
				{
					throw new NotImplementedException();
				}

				view.Model = Model.Window;
				WindowManager.AddWindow(view);
			}
			else
			{
				WindowManager.RemoveWindow(view);
				view = null;
			}
		}
	}
}
