package org.ovirt.engine.core.bll;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import org.junit.Before;
import org.junit.Test;
import org.ovirt.engine.core.common.businessentities.DiskImage;
import org.ovirt.engine.core.common.businessentities.ImageStatus;
import org.ovirt.engine.core.dal.VdcBllMessages;


/** A test case for {@link ImagesHandler} */
public class ImagesHandlerTest {

    /** The prefix to use for all tests */
    private static final String prefix = "PREFIX";

    /** The disk to use for testing */
    private DiskImage disk;
    private DiskImage disk2;

    @Before
    public void setUp() {
        disk = new DiskImage();
        disk2 = new DiskImage();
    }

    @Test
    public void testGetSuggestedDiskAliasNullDisk() {
        assertEquals("null disk does not give the default name",
                prefix + ImagesHandler.DISK + ImagesHandler.DefaultDriveName,
                ImagesHandler.getSuggestedDiskAlias(null, prefix, 1));
    }

    @Test
    public void testGetSuggestedDiskAliasNullAliasDisk() {
        disk.setDiskAlias(null);
        assertEquals("disk with null alias does not give the default name",
                prefix + ImagesHandler.DISK + ImagesHandler.DefaultDriveName,
                ImagesHandler.getSuggestedDiskAlias(disk, prefix, 1));
    }

    @Test
    public void testGetSuggestedDiskAliasNotNullAliasDisk() {
        disk.setDiskAlias("someAlias");
        assertEquals("a new alias was generated instead of returning the pre-defined one",
                disk.getDiskAlias(),
                ImagesHandler.getSuggestedDiskAlias(disk, prefix, 1));
    }

    @Test
    public void testGetDiskAliasWithDefaultNullAlias() {
        assertEquals("default", ImagesHandler.getDiskAliasWithDefault(disk, "default"));
    }

    @Test
    public void testGetDiskAliasWithDefaultNotNullAlias() {
        disk.setDiskAlias("alias");
        assertEquals("alias", ImagesHandler.getDiskAliasWithDefault(disk, "default"));
    }

    @Test
    public void testCheckImagesIllegalWithIllegalDisk() {
        disk.setimageStatus(ImageStatus.ILLEGAL);
        List<DiskImage> images = Arrays.asList(disk, disk2);
        List<String> messages = new LinkedList<String>();
        assertFalse(ImagesHandler.checkImagesIllegal(messages, images));
        assertTrue(messages.contains(VdcBllMessages.ACTION_TYPE_FAILED_DISKS_ILLEGAL.toString()));
    }

    @Test
    public void testCheckImagesIllegalWithoutIllegalDisk() {
        List<DiskImage> images = Arrays.asList(disk, disk2);
        List<String> messages = new LinkedList<String>();
        assertTrue(ImagesHandler.checkImagesIllegal(messages, images));
        assertTrue(messages.isEmpty());
    }
}
