﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using org.ovirt.engine.ui.uicompat;
using VdcCommon.BusinessEntities;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.Xml.Serialization;

namespace VdcCommon.BusinessEntities
{
	
	public enum RegisterableQueryReturnDataType
	{
		[EnumMember]
		UNDEFINED,
		[EnumMember]
		IQUERYABLE,
		[EnumMember]
		LIST_IQUERYABLE,
		[EnumMember]
		SEARCH
	}

	public static class RegisterableQueryTypes
	{
		public static RegisterableQueryReturnDataType GetReturnedDataTypeByQueryType(
			VdcQueryType queryType,
			VdcQueryParametersBase queryParams)
		{
			if (queryType == VdcQueryType.Search)
			{
				return RegisterableQueryReturnDataType.SEARCH;
			}

			return queryParams.GetReturnedDataTypeByVdcQueryType(queryType);
		}
	}

	public partial class IRegisterQueryUpdatedData : IProvidePropertyChangedEvent
	{
		public static EventDefinition PropertyChangedEventDefinition;
		[XmlIgnore]
		public Event PropertyChangedEvent { get; set; }

		static IRegisterQueryUpdatedData()
		{
			PropertyChangedEventDefinition = new EventDefinition("PropertyChanged", typeof(IProvidePropertyChangedEvent));
		}

		public IRegisterQueryUpdatedData()
		{
			PropertyChangedEvent = new Event(PropertyChangedEventDefinition);
		}
	}
}
