﻿using System;
using System.Runtime.Serialization;
using VdcCommon.BusinessEntities;


namespace VdcCommon.BusinessEntities
{
    #region IsVdsWithSameNameExistParameters

    public partial class IsVdsWithSameNameExistParameters : VdcQueryParametersBase
    {
        public IsVdsWithSameNameExistParameters() { }

        public IsVdsWithSameNameExistParameters(string vdsName)
        {
            VdsName = vdsName;
        }

        public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
            return RegisterableQueryReturnDataType.UNDEFINED;
        }
    }
    #endregion IsVdsWithSameNameExistParameters

    #region IsVdsWithSameHostExistParameters

    public partial class IsVdsWithSameHostExistParameters : VdcQueryParametersBase
    {
        public IsVdsWithSameHostExistParameters() { }

        public IsVdsWithSameHostExistParameters(string hostName)
        {
            HostName = hostName;
        }

        public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
            return RegisterableQueryReturnDataType.UNDEFINED;
        }
    }
    #endregion IsVdsWithSameHostExistParameters

    #region IsVdsWithSameIpExistsParameters

    public partial class IsVdsWithSameIpExistsParameters : VdcQueryParametersBase
    {
        public IsVdsWithSameIpExistsParameters() { }

        public IsVdsWithSameIpExistsParameters(string ipAddress)
        {
            IpAddress = ipAddress;
        }

        public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
            return RegisterableQueryReturnDataType.UNDEFINED;
        }
    }
    #endregion IsVdsWithSameIpExistsParameters

    #region GetVdsByVdsIdParameters

	public partial class GetAllChildVlanInterfacesQueryParameters : VdcQueryParametersBase
	{
		public GetAllChildVlanInterfacesQueryParameters() { }

		public GetAllChildVlanInterfacesQueryParameters(Guid vdsId, NetworkInterface iface)
		{
			this.VdsId = vdsId;
			this.Interface = iface;
		}

	}

    public partial class GetVdsByVdsIdParameters : VdcQueryParametersBase
    {
        public GetVdsByVdsIdParameters() { }

        public GetVdsByVdsIdParameters(Guid vdsId)
        {
            VdsId = vdsId;
        }

        public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
            switch (queryType)
            {
                case VdcQueryType.GetVdsInterfacesByVdsId:
                    return RegisterableQueryReturnDataType.LIST_IQUERYABLE;
                default:
                    return RegisterableQueryReturnDataType.IQUERYABLE;
            }
        }
    }

    public partial class VdsIdParametersBase : VdcQueryParametersBase
    {
        public VdsIdParametersBase() { }

        public VdsIdParametersBase(Guid vdsId)
        {
            VdsId = vdsId;
        }

    }
    #endregion GetVdsByVdsIdParameters

    #region GetVdsByHostParameters

    public partial class GetVdsByHostParameters : VdcQueryParametersBase
    {
        public GetVdsByHostParameters() { }

        public GetVdsByHostParameters(string hostname)
        {
            this.HostName = hostname;
        }

    }
    #endregion GetVdsByHostParameters

    #region GetVdsByNameParameters

    public partial class GetVdsByNameParameters : VdcQueryParametersBase
    {
        public GetVdsByNameParameters() { }

        public GetVdsByNameParameters(string name)
        {
            Name = name;
        }

    }
    #endregion GetVdsByNameParameters

    #region GetVdsGroupByIdParameters

    public partial class GetVdsGroupByIdParameters : VdcQueryParametersBase
    {
        public GetVdsGroupByIdParameters() { }

        public GetVdsGroupByIdParameters(Guid vdsId)
        {
            VdsId = vdsId;
        }

        public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
            return RegisterableQueryReturnDataType.IQUERYABLE;
        }
    }
    #endregion GetVdsGroupByIdParameters

    #region GetVdsGroupByIdParameters

    public partial class GetVdsGroupByVdsGroupIdParameters : VdcQueryParametersBase
    {
        public GetVdsGroupByVdsGroupIdParameters() { }

        public GetVdsGroupByVdsGroupIdParameters(Guid vdsGroupId)
        {
            VdsGroupId = vdsGroupId;
        }

        public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
            return RegisterableQueryReturnDataType.IQUERYABLE;
        }
    }
    #endregion GetVdsGroupByIdParameters


    #region GetVdsGroupByNameParameters

    public partial class GetVdsGroupByNameParameters : VdcQueryParametersBase
    {
        public GetVdsGroupByNameParameters() { }

        public GetVdsGroupByNameParameters(string name)
        {
            Name = name;
        }

        public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
            return RegisterableQueryReturnDataType.IQUERYABLE;
        }
    }
    #endregion GetVdsGroupByNameParameters

    #region IsVdsGroupWithSameNameExistParameters

    public partial class IsVdsGroupWithSameNameExistParameters : VdcQueryParametersBase
    {
        public IsVdsGroupWithSameNameExistParameters() { }

        public IsVdsGroupWithSameNameExistParameters(string name)
        {
            Name = name;
        }

        public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
            return RegisterableQueryReturnDataType.UNDEFINED;
        }
    }
    #endregion IsVdsGroupWithSameNameExistParameters

	#region IsStoragePoolWithSameNameExistParameters
	
	public partial class IsStoragePoolWithSameNameExistParameters : VdcQueryParametersBase
	{
		public IsStoragePoolWithSameNameExistParameters() { }

		public IsStoragePoolWithSameNameExistParameters(string name)
		{
			StoragePoolName = name;
		}
	}

	#endregion

	#region GetPowerClientByClientInfoParameters

	public partial class GetPowerClientByClientInfoParameters : VdcQueryParametersBase
    {
        public GetPowerClientByClientInfoParameters() { }

        public GetPowerClientByClientInfoParameters(string clientIp)
        {
            ClientIp = clientIp;
        }

        public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
            return RegisterableQueryReturnDataType.IQUERYABLE;
        }
    }
    #endregion GetPowerClientByClientInfoParameters

    #region AddPowerClientarameters

    public partial class AddPowerClientParameters : VdcQueryParametersBase
    {
        public AddPowerClientParameters() { }

        public AddPowerClientParameters(AddVdsActionParameters addVdsParams)
        {
            AddVdsParams = addVdsParams;
        }
    }
    #endregion AddPowerClientarameters


    #region GetNewVdsFenceStatusParameters

    public partial class GetNewVdsFenceStatusParameters
    {
        public GetNewVdsFenceStatusParameters()
        {
            StoragePoolId = Guid.Empty;
        }

        public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
            return RegisterableQueryReturnDataType.IQUERYABLE;
        }
    }
    #endregion GetNetworkConfigStatusByVdsIdParameters
}
