﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using org.ovirt.engine.ui.uicommon.dataprovider;
using org.ovirt.engine.ui.uicommon.models.configure;
using org.ovirt.engine.ui.uicommon.models.vms;
using org.ovirt.engine.ui.uicompat;
using VdcCommon;
using VdcCommon.BusinessEntities;
using VdcFrontend;

namespace org.ovirt.engine.ui.uicommon.models.userportal
{
	public class VmItemBehavior : ItemBehavior
	{
		public VmItemBehavior(UserPortalItemModel item)
			: base(item)
		{
		}

		public override void OnEntityChanged()
		{
			UpdateProperties();
			UpdateActionAvailability();
		}

		public override void EntityPropertyChanged(PropertyChangedEventArgs e)
		{
			UpdateProperties();
			if (e.PropertyName == "status")
			{
				UpdateActionAvailability();
			}
		}

		public override void ExecuteCommand(UICommand command)
		{
			if (command == Item.RunCommand)
			{
				Run();
			}
			else if (command == Item.PauseCommand)
			{
				Pause();
			}
			else if (command == Item.StopCommand)
			{
				Stop();
			}
			else if (command == Item.ShutdownCommand)
			{
				Shutdown();
			}
			else if (command == Item.RetrieveCdImagesCommand)
			{
				RetrieveCdImages();
			}
			else if (command == Item.ReturnVmCommand)
			{
				ReturnVm();
			}
		}

		public override void eventRaised(Event ev, object sender, EventArgs args)
		{
			if (ev.Equals(ChangeCDModel.ExecutedEventDefinition))
			{
				ChangeCD(sender, args);
			}
		}

		private void ChangeCD(object sender, EventArgs args)
		{
			VM entity = (VM)Item.Entity;
			ChangeCDModel model = (ChangeCDModel)sender;

			//TODO: Patch!
			string imageName = model.Title;
			if (imageName == "No CDs")
			{
				return;
			}

			Frontend.RunAction(VdcActionType.ChangeDisk, new ChangeDiskCommandParameters(entity.vm_guid, imageName == ConsoleModel.EjectLabel ? String.Empty : imageName));
		}

		private void ReturnVm()
		{
			VM entity = (VM)Item.Entity;

			Frontend.RunAction(VdcActionType.ShutdownVm,
				new ShutdownVmParameters(entity.vm_guid, false),
				result =>
				{
				},
				null
			);
		}

		private void RetrieveCdImages()
		{
			VM entity = (VM)Item.Entity;

			Item.CdImages.Clear();

			AsyncQuery _asyncQuery0 = new AsyncQuery();
			_asyncQuery0.Model = this;

			/*START_DELEGATE*/_asyncQuery0.asyncCallback = delegate(Object model0, Object result0)
				{
					if (result0 != null)
					{
						storage_domains isoDomain = (storage_domains)result0;
						VmItemBehavior thisVmItemBehavior = (VmItemBehavior)model0;

						AsyncQuery _asyncQuery = new AsyncQuery();
						_asyncQuery.Model = thisVmItemBehavior;

						/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object result)
							{
								VmItemBehavior vmItemBehavior = (VmItemBehavior)model;
								List<string> list = (List<string>)result;
								if (list.Count > 0)
								{
									list.Add(ConsoleModel.EjectLabel);
									foreach (string iso in list)
									{
										ChangeCDModel changeCDModel = new ChangeCDModel { Title = iso };
										changeCDModel.ExecutedEvent.addListener(Item);
										UserPortalItemModel userPortalItemModel = vmItemBehavior.Item;
										userPortalItemModel.CdImages.Add(changeCDModel);
									}
								}
								else
								{
									UserPortalItemModel userPortalItemModel = vmItemBehavior.Item;
									userPortalItemModel.CdImages.Add(new ChangeCDModel { Title = "No CDs" });
								}
							};//END_DELEGATE
						AsyncDataProvider.GetIrsImageList(_asyncQuery, isoDomain.id, false);

					}
				};//END_DELEGATE

			AsyncDataProvider.GetIsoDomainByDataCenterId(_asyncQuery0, entity.storage_pool_id);
		}

		private void Shutdown()
		{
			VM entity = (VM)Item.Entity;
			Frontend.RunAction(VdcActionType.ShutdownVm, new ShutdownVmParameters(entity.vm_guid, true));
		}

		private void Stop()
		{
			VM entity = (VM)Item.Entity;
			Frontend.RunAction(VdcActionType.StopVm, new StopVmParameters(entity.vm_guid, StopVmTypeEnum.NORMAL));
		}

		private void Pause()
		{
			VM entity = (VM)Item.Entity;
			Frontend.RunAction(VdcActionType.HibernateVm, new HibernateVmParameters(entity.vm_guid));
		}

		private void Run()
		{
			VM entity = (VM)Item.Entity;
			//use sysprep iff the vm is not initialized and vm has Win OS 
			bool reinitialize = !entity.is_initialized && DataProvider.IsWindowsOsType(entity.vm_os);
			Frontend.RunAction(VdcActionType.RunVm, new RunVmParams(entity.vm_guid) { Reinitialize = reinitialize});
		}

		private void UpdateProperties()
		{
			VM entity = (VM)Item.Entity;

			Item.Name = entity.vm_name;
			Item.Description = entity.vm_description;
			Item.Status = entity.status;
			Item.IsPool = false;
			Item.IsServer = entity.vm_type == VmType.Server;
			Item.OsType = entity.vm_os;
			Item.IsFromPool = entity.VmPoolId != null;


			//Assign PoolType.
			if (entity.VmPoolId != null)
			{
				vm_pools pool = Item.ResolutionService.ResolveVmPoolById(entity.VmPoolId.Value);

				//Throw exception. Will help finding bugs in development phase.
				if (pool == null)
				{
					throw new NotImplementedException();
				}

				Item.PoolType = pool.vm_pool_type;
			}


			if (Item.DefaultConsole == null)
			{
				Item.DefaultConsole = new SpiceConsoleModel();
			}
			Item.DefaultConsole.Entity = entity;

			//Support RDP console for windows VMs.
			if (DataProvider.IsWindowsOsType(entity.vm_os))
			{
				if (Item.AdditionalConsole == null)
				{
					Item.AdditionalConsole = new RdpConsoleModel();
				}
				Item.AdditionalConsole.Entity = entity;
				Item.HasAdditionalConsole = true;
			}
			else
			{
				Item.AdditionalConsole = null;
				Item.HasAdditionalConsole = false;
			}
		}

		private void UpdateActionAvailability()
		{
			VM entity = (VM)Item.Entity;


			Item.TakeVmCommand.IsAvailable = false;

			List<VM> entities = new List<VM>();
			entities.Add(entity);

			Item.RunCommand.IsExecutionAllowed = VdcActionUtils.CanExecute(entities, typeof(VM), VdcActionType.RunVm);
			Item.PauseCommand.IsExecutionAllowed = VdcActionUtils.CanExecute(entities, typeof(VM), VdcActionType.HibernateVm);
			Item.ShutdownCommand.IsExecutionAllowed = VdcActionUtils.CanExecute(entities, typeof(VM), VdcActionType.ShutdownVm);
			Item.StopCommand.IsExecutionAllowed = VdcActionUtils.CanExecute(entities, typeof(VM), VdcActionType.StopVm);


			//Check whether a VM is from the manual pool.
			if (entity.VmPoolId != null)
			{
				AsyncDataProvider.GetPoolById(new AsyncQuery(this,
					(target, returnValue) =>
					{
						VmItemBehavior behavior = (VmItemBehavior)target;

						vm_pools pool = (vm_pools)returnValue;
						bool isManualPool = pool.vm_pool_type == VmPoolType.Manual;
						behavior.UpdateCommandsAccordingToPoolType(isManualPool);
					})
					, entity.VmPoolId.Value
				);
			}
			else
			{
				UpdateCommandsAccordingToPoolType(true);
			}
		}

		public void UpdateCommandsAccordingToPoolType(bool isManualPool)
		{
			Item.ReturnVmCommand.IsAvailable = !isManualPool;
			Item.RunCommand.IsAvailable = isManualPool;
		}
	}
}