'''
Created on Oct 30, 2010

@author: mpastern@redhat.com
'''

from org.ovirt.engine.ui.sdk.internals.parameter import Parameter

class ParametersContainer(object):
    '''
    This class used as method's parameters store
    '''
    __parameters = []
    
    def __init__(self):
        self.__parameters = []
        
    def append(self,parameter):       
        self.__parameters.append(\
                     self.__makeCandidateUnique(parameter))
    
    def getParameterByUniqueName(self,name):
        parameters=[]
        for parameter in self.__parameters:
            if(parameter.get_unique_name() == name):
                parameters.append(parameter)
        return parameters
    
    def __makeCandidateUnique(self,parameter):
        isExist = False
        for stored_param in self.__parameters:
            if(stored_param.get_unique_name() == \
                                parameter.get_unique_name()):
                stored_param.extendUniqueName()
                isExist=True
            else:
                splittedUname = stored_param.get_unique_name().split('.')
                if(splittedUname.__class__ is list and splittedUname.__len__() > 0):
                    if(splittedUname[splittedUname.__len__()-1] == \
                                parameter.get_unique_name()):
                        isExist=True
                else:
                    if(splittedUname == parameter.get_unique_name()):
                        isExist=True
        if(isExist==True):
            parameter.extendUniqueName()
            return self.__makeCandidateUnique(parameter)
        else:
            return parameter        
        
    def extend(self,parametersContainer):
        self.__parameters.extend(parametersContainer.get_parameters())
            
    def __str__(self):
        for item in self.__parameters:
            print item.__str__()
            
    def get_parameters(self):
        return self.__parameters


    def del_parameters(self):
        del self.__parameters
        
    parameters = property(get_parameters, del_parameters, "parameters's docstring")
    
    
