﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace wsdl_helper
{
    class Program
    {
        static void Main(string[] args)
        {
            StreamWriter dst = new StreamWriter(args[1]);

            // list of types we shouldn't check for non nullability on when assiging to (for *Sepcified handling)
            List<string> non_nullable = new List<string>();
            non_nullable.Add("bool");
            non_nullable.Add("int");
            non_nullable.Add("long");
            non_nullable.Add("decimal");

            // identify all enums as they are not nullable as well
            using (StreamReader src = new StreamReader(args[0]))
            {
                String line;
                while ((line = src.ReadLine()) != null)
                {
                    if (line.Contains("public enum"))
                    {
                        //publc enum XXX
                        string[] line_parts = line.Trim().Split(' ');
                        non_nullable.Add(line_parts[2]);
                        //Console.WriteLine("enum added: " + line_parts[2] + " - " + line);
                    }
                }
            }


            using (StreamReader src = new StreamReader(args[0]))
            {
                String line;
                List<string> specified_fields = new List<string>();
                bool InsideArrayGetter = false;
                //bool InsideGuidGetter = false;
                //bool InsideGuidArrayGetter = false;
                string PropertyType = String.Empty;
                string ArrayGetterType = String.Empty;
                string ArrayGetterField = String.Empty;
                //string GuidGetterType = String.Empty;
                //string GuidGetterField = String.Empty;
                //int ClosingBracketCount = 0;
                int line_counter = 0;
                //string XmlElementLine = string.Empty;

				bool IRegisterQueryUpdatedDataHandler = false;

                while ((line = src.ReadLine()) != null)
                {
                    line_counter++;

                    // if an xml element line - keep it.
                    //if (line.Contains("[System.Xml.Serialization.XmlElementAttribute"))
                    //    XmlElementLine = line;

                    //*** Setting FieldSpecified on setter's logic ***
                    //before: this.isReadonlyField = value;
                    //after:  this.isReadonlyField = value; this.isReadonlyFieldSpecified = (value != null);
                    // init on each class
                    if (line.Contains("public partial class")) {
                        specified_fields.Clear();
						// check for IRegisterQueryUpdatedData handling - need to check full string, since there are 
						// lines containing IRegisterQueryUpdatedData as part of class definition as a parent class
						if (line.Contains("public partial class IRegisterQueryUpdatedData"))
						{
							IRegisterQueryUpdatedDataHandler = true;
						}
                    }
                    // specified field found
                    else if (line.Contains("private ") && line.Contains("FieldSpecified;"))
                    {
                        //strip private prefix, FieldSpecified suffix, then take portion after the space.
                        //line format is: private bool storage_pool_typeFieldSpecified;
                        string field = line.Trim().Replace("private ", "").Replace("FieldSpecified;", "").Split(' ')[1];
                        specified_fields.Add(field);
                    }
                    // field setter found
                    else if (line.Contains("Field = value;"))
                    {
                        // strip "this." prefix and "Field = value;" suffix to leave the field name
                        // line format is: this.storage_pool_typeField = value;
                        string field = line.Trim().Replace("this.","").Replace("Field = value;", "");
                        if (specified_fields.Contains(field)) {
                            string specfied_helper = "true";
                            // check field is nullable (not non-nullable), and set specified only if not passing null for it
                            if (PropertyType.Contains("?") || PropertyType.Contains("System.Nullable") || !non_nullable.Contains(PropertyType))
                            {
                                specfied_helper = "(value != null)";
                            }
                            // we should be inside a setter for this, which means we already passed getter
                            line += string.Format(" this.{0}FieldSpecified = {1};", field, specfied_helper);
                        }
                    }

                    // detect properties
                    if (line.Contains("public") &&  
                        !line.Contains("class") && 
                        !line.Contains("enum") && 
                        !line.Contains("interface") &&
                        !line.Contains(";") &&
                        !line.Contains("(") &&
                        line.Trim().Split(' ').Length == 3)
                    {
                        PropertyType = line.Trim().Split(' ')[1];
                        //Console.WriteLine(PropertyType + " : " + line);
                    }

                    //*** changing an array getter to return an empty array instead of a null array ***
                    // before: return this.tagsField
                    // after:  return this.tagsField != null ? this.tagsField : new tags[0];
                    if (line.Contains("public ") && line.Contains("[]")
                        && !line.Contains("(") //filter constructors
                        //&& line.Contains("{") // make sure this is a getter - removed now that svcutil generates brackets on next line
                        && !line.Contains(";") // use this test to filter non getters, now that we can't rely on brackets
                        ) 
                    {
                        InsideArrayGetter = true;
                        ArrayGetterType = line.Trim().Split(' ')[1].Trim('[', ']');
                    }

                    if (InsideArrayGetter)
                    {
                        if (line.Contains("return "))
                        {
                            ArrayGetterField = line.Replace("return this.", "").TrimEnd(';').Trim();
                            line = String.Format("                return this.{0} != null ? this.{0} : new {1}[0];", ArrayGetterField, ArrayGetterType);
                            InsideArrayGetter = false;
                        }
                        else if (line.Contains("}"))
                        {
                            Console.WriteLine("ERROR: Array getter closed, but no getter fixed at line {0}", line_counter);
                            InsideArrayGetter = false;
                        }
                    }

					// if we are in the IRegisterQueryUpdatedData class, we want to replace the default 
					// event handler with a method call, since we need our code to be convertible to java
					// so we use method call, instead of an event.
					if (IRegisterQueryUpdatedDataHandler && line.Contains("propertyChanged(this, new System.ComponentModel.PropertyChangedEventArgs(propertyName));"))
					{
						line = "";
						line += "\t\t\t\tSystem.ComponentModel.PropertyChangedEventArgs args = new System.ComponentModel.PropertyChangedEventArgs(propertyName);\n";
						line += "\t\t\t\tpropertyChanged(this, args);\n";
						line += "\t\t\t\tPropertyChangedEvent.raise(this, args);\n";
						IRegisterQueryUpdatedDataHandler = false; // disable custom logic for rest of code
					}

                    //*** changing guid/nguid to Guid/Guid? - main issue is we can't change the current public getter/setter's since they are serialized.

                    //if (line.Contains("public guid") || line.Contains("public nguid"))
                    //{
                    //    InsideGuidGetter = true;
                    //    GuidGetterType = line.Trim().Split(' ')[1].Trim('[', ']');
                    //    GuidGetterField = line.Trim().Split(' ')[2].Trim('[', ']');
                    //    if (line.Contains('['))
                    //        InsideGuidArrayGetter = true;

                    //    XmlElementLine = XmlElementLine.Replace(")]", String.Format(", ElementName=\"{0}\")]", GuidGetterField));

                    //    line = line.Replace(" " + GuidGetterField, " " + GuidGetterField + "private");
                    //    line = line.Replace("public ", "private ");
                    //}

                    //print the line if XmlElementLine is empty

                    // if previous line was an XmlElementLine
                    //string orig_line = line;

                    //set the Element Name in the Xml Element Line.
                    //if (!String.IsNullOrEmpty(XmlElementLine) && !line.Equals(XmlElementLine))
                    //{
                    //    line = XmlElementLine + "\n" + line;
                    //    XmlElementLine = String.Empty;
                    //}

                    //don't print the Xml element line (will be printed with next line)
                    //if (String.IsNullOrEmpty(XmlElementLine))
                        dst.WriteLine(line);
                    
                    //line = orig_line;
                    
                    //if (InsideGuidGetter && line.Contains("}"))
                    //{
                    //    ClosingBracketCount++;
                    //}
                    //if (InsideGuidGetter && (ClosingBracketCount == 3)) { // this line has last closing bracket of property 
                    //    ClosingBracketCount = 0;
                    //    //public System.Guid UserId { get { return this.UserId2; } set { this.UserId2 = value; } }
                    //    string GuidTargetType = GuidGetterType.Equals("nguid") ? "System.Guid?" : "System.Guid";
                    //    if (!InsideGuidArrayGetter)
                    //    {
                    //        dst.WriteLine(string.Format("        [System.Xml.Serialization.XmlIgnoreAttribute] public {0} {1} {{get {{ return this.{1}private; }} set {{ this.{1}private = value; }} }}",
                    //            GuidTargetType, GuidGetterField));
                    //    }
                    //    else
                    //    {
                    //        //   public System.Guid[] StorageDomainsList {get { return this.StorageDomainsListprivate.Cast<System.Guid>().ToArray<System.Guid>(); } set { this.StorageDomainsListprivate = value.Cast<guid>().ToArray<guid>(); } }
                    //        dst.WriteLine(string.Format("        [System.Xml.Serialization.XmlIgnoreAttribute] public {0}[] {1} {{get {{ return this.{1}private.Cast<{0}>().ToArray<{0}>(); }} set {{ this.{1}private = value.Cast<{2}>().ToArray<{2}>(); }} }}",
                    //            GuidTargetType, GuidGetterField, GuidGetterType));
                    //    }
                    //    InsideGuidGetter = false;
                    //    InsideGuidArrayGetter = false;
                    //}
                }
            }
            dst.Close();

        }
    }
}
