﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Controls;
using System.Windows;
using System.Windows.Media;

namespace UI.WPFClient
{
	public class FloatingPanel : Panel
	{
		#region Properties

		public Orientation Orientation
		{
			get { return (Orientation)GetValue(OrientationProperty); }
			set { SetValue(OrientationProperty, value); }
		}
		public static readonly DependencyProperty OrientationProperty =
			DependencyProperty.Register("Orientation", typeof(Orientation), typeof(FloatingPanel));


		public static double GetPosition(DependencyObject obj)
		{
			return (double)obj.GetValue(PositionProperty);
		}

		public static void SetPosition(DependencyObject obj, double value)
		{
			obj.SetValue(PositionProperty, value);
		}

		public static readonly DependencyProperty PositionProperty =
			DependencyProperty.RegisterAttached("Position", typeof(double), typeof(FloatingPanel));

		#endregion


		protected override Size MeasureOverride(Size availableSize)
		{
			foreach (UIElement child in Children)
			{
				child.Measure(availableSize);
			}

			return base.MeasureOverride(availableSize);
		}

		protected override Size ArrangeOverride(Size finalSize)
		{
			foreach (UIElement child in Children)
			{
				UIElement obj = child;
				if (child is ContentPresenter)
				{
					obj = (UIElement)VisualTreeHelper.GetChild(child, 0);
				}

				double p = GetPosition(obj);

				if (Orientation == Orientation.Horizontal)
				{
					double childDesiredWidth = obj.DesiredSize.Width;
					child.Arrange(
						new Rect(
							finalSize.Width * p - childDesiredWidth / 2.0,
							0.0,
							childDesiredWidth,
							finalSize.Height
							)
						);
				}
				else
				{
					double childDesiredHeight = obj.DesiredSize.Height;
					child.Arrange(
						new Rect(
							0.0,
							finalSize.Height * p - childDesiredHeight / 2.0,
							finalSize.Width,
							childDesiredHeight
							)
						);
				}
			}

			return base.ArrangeOverride(finalSize);
		}
	}
}
